/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.common.RuntimeUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;

public class VertexManager {
    VertexManagerPluginDescriptor pluginDesc;
    VertexManagerPlugin plugin;
    Vertex managedVertex;
    VertexManagerPluginContextImpl pluginContext;
    byte[] payload = null;
    AppContext appContext;
    private static final Log LOG = LogFactory.getLog(VertexManager.class);

    public VertexManager(VertexManagerPlugin plugin, Vertex managedVertex, AppContext appContext) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin is null");
        Preconditions.checkNotNull((Object)managedVertex, (Object)"managedVertex is null");
        Preconditions.checkNotNull((Object)appContext, (Object)"appContext is null");
        this.plugin = plugin;
        this.managedVertex = managedVertex;
        this.appContext = appContext;
    }

    public VertexManager(VertexManagerPluginDescriptor pluginDesc, Vertex managedVertex, AppContext appContext) {
        Preconditions.checkNotNull((Object)pluginDesc, (Object)"pluginDesc is null");
        Preconditions.checkNotNull((Object)managedVertex, (Object)"managedVertex is null");
        Preconditions.checkNotNull((Object)appContext, (Object)"appContext is null");
        this.pluginDesc = pluginDesc;
        this.managedVertex = managedVertex;
        this.appContext = appContext;
    }

    public VertexManagerPlugin getPlugin() {
        return this.plugin;
    }

    public void initialize() {
        this.pluginContext = new VertexManagerPluginContextImpl();
        if (this.pluginDesc != null) {
            this.plugin = (VertexManagerPlugin)RuntimeUtils.createClazzInstance((String)this.pluginDesc.getClassName());
            this.payload = this.pluginDesc.getUserPayload();
        }
        if (this.payload == null) {
            try {
                this.payload = TezUtils.createUserPayloadFromConf((Configuration)this.appContext.getAMConf());
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
        this.plugin.initialize((VertexManagerPluginContext)this.pluginContext);
    }

    public void onVertexStarted(List<TezTaskAttemptID> completions) {
        HashMap pluginCompletionsMap = Maps.newHashMap();
        if (completions != null && !completions.isEmpty()) {
            for (TezTaskAttemptID tezTaskAttemptID : completions) {
                Integer taskId = new Integer(tezTaskAttemptID.getTaskID().getId());
                String vertexName = this.appContext.getCurrentDAG().getVertex(tezTaskAttemptID.getTaskID().getVertexID()).getName();
                List taskIdList = (List)pluginCompletionsMap.get(vertexName);
                if (taskIdList == null) {
                    taskIdList = Lists.newArrayList();
                    pluginCompletionsMap.put(vertexName, taskIdList);
                }
                taskIdList.add(taskId);
            }
        }
        this.plugin.onVertexStarted((Map)pluginCompletionsMap);
    }

    public void onSourceTaskCompleted(TezTaskID tezTaskId) {
        Integer taskId = new Integer(tezTaskId.getId());
        String vertexName = this.appContext.getCurrentDAG().getVertex(tezTaskId.getVertexID()).getName();
        this.plugin.onSourceTaskCompleted(vertexName, taskId);
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
        this.plugin.onVertexManagerEventReceived(vmEvent);
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<org.apache.tez.runtime.api.Event> events) {
        this.plugin.onRootVertexInitialized(inputName, inputDescriptor, events);
    }

    class VertexManagerPluginContextImpl
    implements VertexManagerPluginContext {
        private EventMetaData rootEventSourceMetadata;
        private Map<String, EventMetaData> destinationEventMetadataMap;

        VertexManagerPluginContextImpl() {
            this.rootEventSourceMetadata = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, VertexManager.this.managedVertex.getName(), "NULL_VERTEX", null);
            this.destinationEventMetadataMap = Maps.newHashMap();
        }

        public Map<String, EdgeProperty> getInputVertexEdgeProperties() {
            Map<Vertex, Edge> inputs = VertexManager.this.managedVertex.getInputVertices();
            HashMap vertexEdgeMap = Maps.newHashMapWithExpectedSize((int)inputs.size());
            for (Map.Entry<Vertex, Edge> entry : inputs.entrySet()) {
                vertexEdgeMap.put(entry.getKey().getName(), entry.getValue().getEdgeProperty());
            }
            return vertexEdgeMap;
        }

        public String getVertexName() {
            return VertexManager.this.managedVertex.getName();
        }

        public int getVertexNumTasks(String vertexName) {
            return VertexManager.this.appContext.getCurrentDAG().getVertex(vertexName).getTotalTasks();
        }

        public boolean setVertexParallelism(int parallelism, VertexLocationHint vertexLocationHint, Map<String, EdgeManagerDescriptor> sourceEdgeManagers) {
            return VertexManager.this.managedVertex.setParallelism(parallelism, vertexLocationHint, sourceEdgeManagers);
        }

        public void scheduleVertexTasks(List<Integer> taskIDs) {
            VertexManager.this.managedVertex.scheduleTasks(taskIDs);
        }

        public Set<String> getVertexInputNames() {
            Set<String> inputNames = null;
            Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> inputs = VertexManager.this.managedVertex.getAdditionalInputs();
            if (inputs != null) {
                inputNames = inputs.keySet();
            }
            return inputNames;
        }

        public byte[] getUserPayload() {
            return VertexManager.this.payload;
        }

        public void addRootInputEvents(final String inputName, Collection<RootInputDataInformationEvent> events) {
            this.verifyIsRootInput(inputName);
            Iterable tezEvents = Iterables.transform(events, (Function)new Function<RootInputDataInformationEvent, TezEvent>(){

                public TezEvent apply(RootInputDataInformationEvent riEvent) {
                    TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)riEvent, VertexManagerPluginContextImpl.this.rootEventSourceMetadata);
                    tezEvent.setDestinationInfo(VertexManagerPluginContextImpl.this.getDestinationMetaData(inputName));
                    return tezEvent;
                }
            });
            VertexManager.this.appContext.getEventHandler().handle((Event)new VertexEventRouteEvent(VertexManager.this.managedVertex.getVertexId(), Lists.newArrayList((Iterable)tezEvents)));
        }

        public void setVertexLocationHint(VertexLocationHint locationHint) {
            VertexManager.this.managedVertex.setVertexLocationHint(locationHint);
        }

        public int getDAGAttemptNumber() {
            return VertexManager.this.appContext.getApplicationAttemptId().getAttemptId();
        }

        private void verifyIsRootInput(String inputName) {
            Preconditions.checkState((VertexManager.this.managedVertex.getAdditionalInputs().get(inputName) != null ? 1 : 0) != 0, (Object)"Cannot add events for non-root inputs");
        }

        private EventMetaData getDestinationMetaData(String inputName) {
            EventMetaData destMeta = this.destinationEventMetadataMap.get(inputName);
            if (destMeta == null) {
                destMeta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, VertexManager.this.managedVertex.getName(), inputName, null);
                this.destinationEventMetadataMap.put(inputName, destMeta);
            }
            return destMeta;
        }

        public Resource getVertexTaskResource() {
            return VertexManager.this.managedVertex.getTaskResource();
        }

        public Resource getTotalAVailableResource() {
            return VertexManager.this.appContext.getTaskScheduler().getTotalResources();
        }

        public int getNumClusterNodes() {
            return VertexManager.this.appContext.getTaskScheduler().getNumClusterNodes();
        }
    }
}

