/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TezTaskAttemptID taskAttemptId;
    private String inProgressLogsUrl;
    private String completedLogsUrl;
    private String vertexName;
    private long startTime;
    private ContainerId containerId;
    private NodeId nodeId;

    public TaskAttemptStartedEvent(TezTaskAttemptID taId, String vertexName, long startTime, ContainerId containerId, NodeId nodeId, String inProgressLogsUrl, String completedLogsUrl) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.startTime = startTime;
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.inProgressLogsUrl = inProgressLogsUrl;
        this.completedLogsUrl = completedLogsUrl;
    }

    public TaskAttemptStartedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_STARTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.taskAttemptId.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject nodeEntity = new JSONObject();
        nodeEntity.put("entity", (Object)this.nodeId.toString());
        nodeEntity.put("entitytype", (Object)"nodeId");
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)this.containerId.toString());
        containerEntity.put("entitytype", (Object)"containerId");
        JSONObject taskEntity = new JSONObject();
        taskEntity.put("entity", (Object)this.taskAttemptId.getTaskID().toString());
        taskEntity.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        relatedEntities.put((Object)nodeEntity);
        relatedEntities.put((Object)containerEntity);
        relatedEntities.put((Object)taskEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", this.startTime);
        startEvent.put("eventtype", (Object)HistoryEventType.TASK_ATTEMPT_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("inProgressLogsURL", (Object)this.inProgressLogsUrl);
        otherInfo.put("completedLogsURL", (Object)this.completedLogsUrl);
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskAttemptStartedProto toProto() {
        return RecoveryProtos.TaskAttemptStartedProto.newBuilder().setTaskAttemptId(this.taskAttemptId.toString()).setStartTime(this.startTime).setContainerId(this.containerId.toString()).setNodeId(this.nodeId.toString()).build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptStartedProto proto) {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.startTime = proto.getStartTime();
        this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        this.nodeId = ConverterUtils.toNodeId((String)proto.getNodeId());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptStartedProto proto = RecoveryProtos.TaskAttemptStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskAttemptId=" + this.taskAttemptId + ", startTime=" + this.startTime + ", containerId=" + this.containerId + ", nodeId=" + this.nodeId + ", inProgressLogs=" + this.inProgressLogsUrl + ", completedLogs=" + this.completedLogsUrl;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }
}

