/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TaskStartedEvent
implements HistoryEvent {
    private TezTaskID taskID;
    private String vertexName;
    private long scheduledTime;
    private long startTime;

    public TaskStartedEvent(TezTaskID taskId, String vertexName, long scheduledTime, long startTime) {
        this.vertexName = vertexName;
        this.taskID = taskId;
        this.scheduledTime = scheduledTime;
        this.startTime = startTime;
    }

    public TaskStartedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_STARTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.taskID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)this.taskID.getVertexID().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", this.startTime);
        startEvent.put("eventtype", (Object)HistoryEventType.TASK_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", this.startTime);
        otherInfo.put("scheduledTime", this.scheduledTime);
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskStartedProto toProto() {
        return RecoveryProtos.TaskStartedProto.newBuilder().setTaskId(this.taskID.toString()).setLaunchTime(this.startTime).setScheduledTime(this.scheduledTime).build();
    }

    public void fromProto(RecoveryProtos.TaskStartedProto proto) {
        this.taskID = TezTaskID.fromString((String)proto.getTaskId());
        this.startTime = proto.getLaunchTime();
        this.scheduledTime = proto.getScheduledTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskStartedProto proto = RecoveryProtos.TaskStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskId=" + this.taskID.toString() + ", scheduledTime=" + this.scheduledTime + ", launchTime=" + this.startTime;
    }

    public TezTaskID getTaskID() {
        return this.taskID;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

