/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.common.ProtoConverters;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexDataMovementEventsGeneratedEvent
implements HistoryEvent {
    private static final Log LOG = LogFactory.getLog(VertexDataMovementEventsGeneratedEvent.class);
    private List<TezEvent> events;
    private TezVertexID vertexID;

    public VertexDataMovementEventsGeneratedEvent(TezVertexID vertexID, List<TezEvent> events) {
        this.vertexID = vertexID;
        this.events = Lists.newArrayListWithCapacity((int)events.size());
        for (TezEvent event : events) {
            if (!EnumSet.of(EventType.DATA_MOVEMENT_EVENT, EventType.COMPOSITE_DATA_MOVEMENT_EVENT, EventType.ROOT_INPUT_DATA_INFORMATION_EVENT).contains(event.getEventType())) continue;
            this.events.add(event);
        }
        if (events.isEmpty()) {
            throw new RuntimeException("Invalid creation of VertexDataMovementEventsGeneratedEvent, no data movement/information events provided");
        }
    }

    public VertexDataMovementEventsGeneratedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_DATA_MOVEMENT_EVENTS_GENERATED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        return null;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    static RecoveryProtos.EventMetaDataProto convertEventMetaDataToProto(EventMetaData eventMetaData) {
        RecoveryProtos.EventMetaDataProto.Builder builder = RecoveryProtos.EventMetaDataProto.newBuilder().setProducerConsumerType(eventMetaData.getEventGenerator().ordinal()).setEdgeVertexName(eventMetaData.getEdgeVertexName()).setTaskVertexName(eventMetaData.getTaskVertexName());
        if (eventMetaData.getTaskAttemptID() != null) {
            builder.setTaskAttemptId(eventMetaData.getTaskAttemptID().toString());
        }
        return builder.build();
    }

    static EventMetaData convertEventMetaDataFromProto(RecoveryProtos.EventMetaDataProto proto) {
        TezTaskAttemptID attemptID = null;
        if (proto.hasTaskAttemptId()) {
            attemptID = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        }
        return new EventMetaData(EventMetaData.EventProducerConsumerType.values()[proto.getProducerConsumerType()], proto.getTaskVertexName(), proto.getEdgeVertexName(), attemptID);
    }

    public RecoveryProtos.VertexDataMovementEventsGeneratedProto toProto() {
        ArrayList tezEventProtos = null;
        if (this.events != null) {
            tezEventProtos = Lists.newArrayListWithCapacity((int)this.events.size());
            for (TezEvent event : this.events) {
                RecoveryProtos.TezDataMovementEventProto.Builder evtBuilder = RecoveryProtos.TezDataMovementEventProto.newBuilder();
                if (event.getEventType().equals((Object)EventType.COMPOSITE_DATA_MOVEMENT_EVENT)) {
                    evtBuilder.setCompositeDataMovementEvent(ProtoConverters.convertCompositeDataMovementEventToProto((CompositeDataMovementEvent)((CompositeDataMovementEvent)event.getEvent())));
                } else if (event.getEventType().equals((Object)EventType.DATA_MOVEMENT_EVENT)) {
                    evtBuilder.setDataMovementEvent(ProtoConverters.convertDataMovementEventToProto((DataMovementEvent)((DataMovementEvent)event.getEvent())));
                } else if (event.getEventType().equals((Object)EventType.ROOT_INPUT_DATA_INFORMATION_EVENT)) {
                    evtBuilder.setRootInputDataInformationEvent(ProtoConverters.convertRootInputDataInformationEventToProto((RootInputDataInformationEvent)((RootInputDataInformationEvent)event.getEvent())));
                }
                if (event.getSourceInfo() != null) {
                    evtBuilder.setSourceInfo(VertexDataMovementEventsGeneratedEvent.convertEventMetaDataToProto(event.getSourceInfo()));
                }
                if (event.getDestinationInfo() != null) {
                    evtBuilder.setDestinationInfo(VertexDataMovementEventsGeneratedEvent.convertEventMetaDataToProto(event.getDestinationInfo()));
                }
                tezEventProtos.add(evtBuilder.build());
            }
        }
        return RecoveryProtos.VertexDataMovementEventsGeneratedProto.newBuilder().setVertexId(this.vertexID.toString()).addAllTezDataMovementEvent(tezEventProtos).build();
    }

    public void fromProto(RecoveryProtos.VertexDataMovementEventsGeneratedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        int eventCount = proto.getTezDataMovementEventCount();
        if (eventCount > 0) {
            this.events = Lists.newArrayListWithCapacity((int)eventCount);
        }
        for (RecoveryProtos.TezDataMovementEventProto eventProto : proto.getTezDataMovementEventList()) {
            CompositeDataMovementEvent evt = null;
            if (eventProto.hasCompositeDataMovementEvent()) {
                evt = ProtoConverters.convertCompositeDataMovementEventFromProto((EventProtos.CompositeEventProto)eventProto.getCompositeDataMovementEvent());
            } else if (eventProto.hasDataMovementEvent()) {
                evt = ProtoConverters.convertDataMovementEventFromProto((EventProtos.DataMovementEventProto)eventProto.getDataMovementEvent());
            } else if (eventProto.hasRootInputDataInformationEvent()) {
                evt = ProtoConverters.convertRootInputDataInformationEventFromProto((EventProtos.RootInputDataInformationEventProto)eventProto.getRootInputDataInformationEvent());
            }
            EventMetaData sourceInfo = null;
            EventMetaData destinationInfo = null;
            if (eventProto.hasSourceInfo()) {
                sourceInfo = VertexDataMovementEventsGeneratedEvent.convertEventMetaDataFromProto(eventProto.getSourceInfo());
            }
            if (eventProto.hasDestinationInfo()) {
                destinationInfo = VertexDataMovementEventsGeneratedEvent.convertEventMetaDataFromProto(eventProto.getDestinationInfo());
            }
            TezEvent tezEvent = new TezEvent((Event)evt, sourceInfo);
            tezEvent.setDestinationInfo(destinationInfo);
            this.events.add(tezEvent);
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexDataMovementEventsGeneratedProto proto = RecoveryProtos.VertexDataMovementEventsGeneratedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID.toString() + ", eventCount=" + (this.events != null ? Integer.valueOf(this.events.size()) : "null");
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public List<TezEvent> getTezEvents() {
        return this.events;
    }
}

