/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.RuntimeUtils;
import org.apache.tez.dag.api.TezException;

public class RelocalizationUtils {
    public static List<URL> processAdditionalResources(Map<String, URI> additionalResources, Configuration conf) throws IOException, TezException {
        if (additionalResources == null || additionalResources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList urls = Lists.newArrayListWithCapacity((int)additionalResources.size());
        for (Map.Entry<String, URI> lrEntry : additionalResources.entrySet()) {
            Path dFile = RelocalizationUtils.downloadResource(lrEntry.getKey(), lrEntry.getValue(), conf);
            urls.add(dFile.toUri().toURL());
        }
        return urls;
    }

    public static void addUrlsToClassPath(List<URL> urls) {
        RuntimeUtils.addResourcesToSystemClassLoader(urls);
    }

    private static Path downloadResource(String destName, URI uri, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path cwd = new Path(System.getenv(ApplicationConstants.Environment.PWD.name()));
        Path dFile = new Path(cwd, destName);
        Path srcPath = new Path(uri);
        fs.copyToLocalFile(srcPath, dFile);
        return dFile.makeQualified(FileSystem.getLocal((Configuration)conf).getUri(), cwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getLocalSha(Path path, Configuration conf) throws IOException {
        FSDataInputStream is = null;
        try {
            is = FileSystem.getLocal((Configuration)conf).open(path);
            byte[] byArray = DigestUtils.sha256((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceSha(URI uri, Configuration conf) throws IOException {
        InputStream is = null;
        try {
            is = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));
            byte[] byArray = DigestUtils.sha256((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

