/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class VertexGroupCommitStartedEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private String vertexGroupName;
    private long commitStartTime;

    public VertexGroupCommitStartedEvent() {
    }

    public VertexGroupCommitStartedEvent(TezDAGID dagID, String vertexGroupName, long commitStartTime) {
        this.dagID = dagID;
        this.vertexGroupName = vertexGroupName;
        this.commitStartTime = commitStartTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_GROUP_COMMIT_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.VertexGroupCommitStartedProto toProto() {
        return RecoveryProtos.VertexGroupCommitStartedProto.newBuilder().setDagId(this.dagID.toString()).setVertexGroupName(this.vertexGroupName).build();
    }

    public void fromProto(RecoveryProtos.VertexGroupCommitStartedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.vertexGroupName = proto.getVertexGroupName();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexGroupCommitStartedProto proto = RecoveryProtos.VertexGroupCommitStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "dagId=" + this.dagID + ", vertexGroup=" + this.vertexGroupName;
    }

    public String getVertexGroupName() {
        return this.vertexGroupName;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.dagID.toString()).setTimestamp(this.commitStartTime).setEventType(this.getEventType().ordinal()).setEventPayload(this.toProto().toByteString());
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        RecoveryProtos.VertexGroupCommitStartedProto vertexGroupCommitStartedProto = RecoveryProtos.VertexGroupCommitStartedProto.parseFrom(proto.getEventPayload());
        this.fromProto(vertexGroupCommitStartedProto);
        this.commitStartTime = proto.getTimestamp();
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }
}

