/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.InputSpecUpdate;

public class VertexParallelismUpdatedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private int numTasks;
    private VertexLocationHint vertexLocationHint;
    private Map<String, EdgeManagerPluginDescriptor> sourceEdgeManagers;
    private Map<String, InputSpecUpdate> rootInputSpecUpdates;

    public VertexParallelismUpdatedEvent() {
    }

    public VertexParallelismUpdatedEvent(TezVertexID vertexID, int numTasks, VertexLocationHint vertexLocationHint, Map<String, EdgeManagerPluginDescriptor> sourceEdgeManagers, Map<String, InputSpecUpdate> rootInputSpecUpdates) {
        this.vertexID = vertexID;
        this.numTasks = numTasks;
        this.vertexLocationHint = vertexLocationHint;
        this.sourceEdgeManagers = sourceEdgeManagers;
        this.rootInputSpecUpdates = rootInputSpecUpdates;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_PARALLELISM_UPDATED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.VertexParallelismUpdatedProto toProto() {
        RecoveryProtos.VertexParallelismUpdatedProto.Builder builder = RecoveryProtos.VertexParallelismUpdatedProto.newBuilder();
        builder.setVertexId(this.vertexID.toString()).setNumTasks(this.numTasks);
        if (this.vertexLocationHint != null) {
            builder.setVertexLocationHint(DagTypeConverters.convertVertexLocationHintToProto((VertexLocationHint)this.vertexLocationHint));
        }
        if (this.sourceEdgeManagers != null) {
            for (Map.Entry<String, EdgeManagerPluginDescriptor> entry : this.sourceEdgeManagers.entrySet()) {
                RecoveryProtos.EdgeManagerDescriptorProto.Builder edgeMgrBuilder = RecoveryProtos.EdgeManagerDescriptorProto.newBuilder();
                edgeMgrBuilder.setEdgeName(entry.getKey());
                edgeMgrBuilder.setEntityDescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)((EntityDescriptor)entry.getValue())));
                builder.addEdgeManagerDescriptors(edgeMgrBuilder.build());
            }
        }
        if (this.rootInputSpecUpdates != null) {
            for (Map.Entry<String, EdgeManagerPluginDescriptor> entry : this.rootInputSpecUpdates.entrySet()) {
                RecoveryProtos.RootInputSpecUpdateProto.Builder rootInputSpecUpdateBuilder = RecoveryProtos.RootInputSpecUpdateProto.newBuilder();
                rootInputSpecUpdateBuilder.setInputName(entry.getKey());
                rootInputSpecUpdateBuilder.setForAllWorkUnits(((InputSpecUpdate)entry.getValue()).isForAllWorkUnits());
                rootInputSpecUpdateBuilder.addAllNumPhysicalInputs(((InputSpecUpdate)entry.getValue()).getAllNumPhysicalInputs());
                builder.addRootInputSpecUpdates(rootInputSpecUpdateBuilder.build());
            }
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.VertexParallelismUpdatedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.numTasks = proto.getNumTasks();
        if (proto.hasVertexLocationHint()) {
            this.vertexLocationHint = DagTypeConverters.convertVertexLocationHintFromProto((DAGProtos.VertexLocationHintProto)proto.getVertexLocationHint());
        }
        if (proto.getEdgeManagerDescriptorsCount() > 0) {
            this.sourceEdgeManagers = new HashMap<String, EdgeManagerPluginDescriptor>(proto.getEdgeManagerDescriptorsCount());
            for (RecoveryProtos.EdgeManagerDescriptorProto edgeManagerProto : proto.getEdgeManagerDescriptorsList()) {
                EdgeManagerPluginDescriptor edgeManagerDescriptor = DagTypeConverters.convertEdgeManagerPluginDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)edgeManagerProto.getEntityDescriptor());
                this.sourceEdgeManagers.put(edgeManagerProto.getEdgeName(), edgeManagerDescriptor);
            }
        }
        if (proto.getRootInputSpecUpdatesCount() > 0) {
            this.rootInputSpecUpdates = Maps.newHashMap();
            for (RecoveryProtos.RootInputSpecUpdateProto rootInputSpecUpdateProto : proto.getRootInputSpecUpdatesList()) {
                InputSpecUpdate specUpdate = rootInputSpecUpdateProto.getForAllWorkUnits() ? InputSpecUpdate.createAllTaskInputSpecUpdate((int)rootInputSpecUpdateProto.getNumPhysicalInputs(0)) : InputSpecUpdate.createPerTaskInputSpecUpdate(rootInputSpecUpdateProto.getNumPhysicalInputsList());
                this.rootInputSpecUpdates.put(rootInputSpecUpdateProto.getInputName(), specUpdate);
            }
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexParallelismUpdatedProto proto = RecoveryProtos.VertexParallelismUpdatedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID + ", numTasks=" + this.numTasks + ", vertexLocationHint=" + (this.vertexLocationHint == null ? "null" : this.vertexLocationHint) + ", edgeManagersCount=" + (this.sourceEdgeManagers == null ? "null" : this.sourceEdgeManagers.size() + ", rootInputSpecUpdateCount=" + (this.rootInputSpecUpdates == null ? "null" : Integer.valueOf(this.rootInputSpecUpdates.size())));
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public VertexLocationHint getVertexLocationHint() {
        return this.vertexLocationHint;
    }

    public Map<String, EdgeManagerPluginDescriptor> getSourceEdgeManagers() {
        return this.sourceEdgeManagers;
    }

    public Map<String, InputSpecUpdate> getRootInputSpecUpdates() {
        return this.rootInputSpecUpdates;
    }
}

