/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.records.TezTaskID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGUtils {
    public static final String DAG_NAME_KEY = "dagName";
    public static final String DAG_INFO_KEY = "dagInfo";
    public static final String VERTICES_KEY = "vertices";
    public static final String EDGES_KEY = "edges";
    public static final String VERTEX_GROUPS_KEY = "vertexGroups";
    public static final String VERTEX_NAME_KEY = "vertexName";
    public static final String VERTEX_ID_KEY = "vertexId";
    public static final String PROCESSOR_CLASS_KEY = "processorClass";
    public static final String IN_EDGE_IDS_KEY = "inEdgeIds";
    public static final String OUT_EDGE_IDS_KEY = "outEdgeIds";
    public static final String ADDITIONAL_INPUTS_KEY = "additionalInputs";
    public static final String ADDITIONAL_OUTPUTS_KEY = "additionalOutputs";
    public static final String VERTEX_MANAGER_PLUGIN_CLASS_KEY = "vertexManagerPluginClass";
    public static final String USER_PAYLOAD_AS_TEXT = "userPayloadAsText";
    public static final String OUTPUT_USER_PAYLOAD_AS_TEXT = "outputUserPayloadAsText";
    public static final String INPUT_USER_PAYLOAD_AS_TEXT = "inputUserPayloadAsText";
    public static final String EDGE_ID_KEY = "edgeId";
    public static final String INPUT_VERTEX_NAME_KEY = "inputVertexName";
    public static final String OUTPUT_VERTEX_NAME_KEY = "outputVertexName";
    public static final String DATA_MOVEMENT_TYPE_KEY = "dataMovementType";
    public static final String DATA_SOURCE_TYPE_KEY = "dataSourceType";
    public static final String SCHEDULING_TYPE_KEY = "schedulingType";
    public static final String EDGE_SOURCE_CLASS_KEY = "edgeSourceClass";
    public static final String EDGE_DESTINATION_CLASS_KEY = "edgeDestinationClass";
    public static final String EDGE_MANAGER_CLASS_KEY = "edgeManagerClass";
    public static final String NAME_KEY = "name";
    public static final String CLASS_KEY = "class";
    public static final String INITIALIZER_KEY = "initializer";
    public static final String VERTEX_GROUP_NAME_KEY = "groupName";
    public static final String VERTEX_GROUP_MEMBERS_KEY = "groupMembers";
    public static final String VERTEX_GROUP_OUTPUTS_KEY = "outputs";
    public static final String VERTEX_GROUP_EDGE_MERGED_INPUTS_KEY = "edgeMergedInputs";
    public static final String VERTEX_GROUP_DESTINATION_VERTEX_NAME_KEY = "destinationVertexName";

    public static JSONObject generateSimpleJSONPlan(DAGProtos.DAGPlan dagPlan) throws JSONException {
        JSONObject dagJson;
        try {
            dagJson = new JSONObject(DAGUtils.convertDAGPlanToATSMap(dagPlan));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        return dagJson;
    }

    public static JSONObject convertCountersToJSON(TezCounters counters) throws JSONException {
        JSONObject jsonObject = new JSONObject(DAGUtils.convertCountersToATSMap(counters));
        return jsonObject;
    }

    public static Map<String, Object> convertCountersToATSMap(TezCounters counters) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        if (counters == null) {
            return object;
        }
        ArrayList<Object> counterGroupsList = new ArrayList<Object>();
        for (CounterGroup group : counters) {
            LinkedHashMap<String, Object> counterGroupMap = new LinkedHashMap<String, Object>();
            counterGroupMap.put("counterGroupName", group.getName());
            counterGroupMap.put("counterGroupDisplayName", group.getDisplayName());
            ArrayList<Object> counterList = new ArrayList<Object>();
            for (TezCounter counter : group) {
                LinkedHashMap<String, Object> counterMap = new LinkedHashMap<String, Object>();
                counterMap.put("counterName", counter.getName());
                counterMap.put("counterDisplayName", counter.getDisplayName());
                counterMap.put("counterValue", counter.getValue());
                counterList.add(counterMap);
            }
            DAGUtils.putInto(counterGroupMap, "counters", counterList);
            counterGroupsList.add(counterGroupMap);
        }
        DAGUtils.putInto(object, "counterGroups", counterGroupsList);
        return object;
    }

    public static Map<String, Object> convertDAGPlanToATSMap(DAGProtos.DAGPlan dagPlan) throws IOException {
        String VERSION_KEY = "version";
        boolean version = true;
        LinkedHashMap<String, Object> dagMap = new LinkedHashMap<String, Object>();
        dagMap.put(DAG_NAME_KEY, dagPlan.getName());
        if (dagPlan.hasDagInfo()) {
            dagMap.put(DAG_INFO_KEY, dagPlan.getDagInfo());
        }
        dagMap.put("version", 1);
        ArrayList<Object> verticesList = new ArrayList<Object>();
        for (DAGProtos.VertexPlan vertexPlan : dagPlan.getVertexList()) {
            LinkedHashMap<String, Object> vertexMap = new LinkedHashMap<String, Object>();
            vertexMap.put(VERTEX_NAME_KEY, vertexPlan.getName());
            if (vertexPlan.hasProcessorDescriptor()) {
                vertexMap.put(PROCESSOR_CLASS_KEY, vertexPlan.getProcessorDescriptor().getClassName());
                if (vertexPlan.getProcessorDescriptor().hasHistoryText()) {
                    vertexMap.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)vertexPlan.getProcessorDescriptor()));
                }
            }
            ArrayList<Object> inEdgeIdList = new ArrayList<Object>();
            inEdgeIdList.addAll(vertexPlan.getInEdgeIdList());
            DAGUtils.putInto(vertexMap, IN_EDGE_IDS_KEY, inEdgeIdList);
            ArrayList<Object> outEdgeIdList = new ArrayList<Object>();
            outEdgeIdList.addAll(vertexPlan.getOutEdgeIdList());
            DAGUtils.putInto(vertexMap, OUT_EDGE_IDS_KEY, outEdgeIdList);
            ArrayList<Object> inputsList = new ArrayList<Object>();
            for (DAGProtos.RootInputLeafOutputProto input : vertexPlan.getInputsList()) {
                LinkedHashMap<String, String> inputMap = new LinkedHashMap<String, String>();
                inputMap.put(NAME_KEY, input.getName());
                inputMap.put(CLASS_KEY, input.getIODescriptor().getClassName());
                if (input.hasControllerDescriptor()) {
                    inputMap.put(INITIALIZER_KEY, input.getControllerDescriptor().getClassName());
                }
                if (input.getIODescriptor().hasHistoryText()) {
                    inputMap.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)input.getIODescriptor()));
                }
                inputsList.add(inputMap);
            }
            DAGUtils.putInto(vertexMap, ADDITIONAL_INPUTS_KEY, inputsList);
            ArrayList<Object> outputsList = new ArrayList<Object>();
            for (DAGProtos.RootInputLeafOutputProto output : vertexPlan.getOutputsList()) {
                LinkedHashMap<String, String> outputMap = new LinkedHashMap<String, String>();
                outputMap.put(NAME_KEY, output.getName());
                outputMap.put(CLASS_KEY, output.getIODescriptor().getClassName());
                if (output.hasControllerDescriptor()) {
                    outputMap.put(INITIALIZER_KEY, output.getControllerDescriptor().getClassName());
                }
                if (output.getIODescriptor().hasHistoryText()) {
                    outputMap.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)output.getIODescriptor()));
                }
                outputsList.add(outputMap);
            }
            DAGUtils.putInto(vertexMap, ADDITIONAL_OUTPUTS_KEY, outputsList);
            if (vertexPlan.hasVertexManagerPlugin()) {
                vertexMap.put(VERTEX_MANAGER_PLUGIN_CLASS_KEY, vertexPlan.getVertexManagerPlugin().getClassName());
            }
            verticesList.add(vertexMap);
        }
        DAGUtils.putInto(dagMap, VERTICES_KEY, verticesList);
        ArrayList<Object> edgesList = new ArrayList<Object>();
        for (DAGProtos.EdgePlan edgePlan : dagPlan.getEdgeList()) {
            LinkedHashMap<String, String> edgeMap = new LinkedHashMap<String, String>();
            edgeMap.put(EDGE_ID_KEY, edgePlan.getId());
            edgeMap.put(INPUT_VERTEX_NAME_KEY, edgePlan.getInputVertexName());
            edgeMap.put(OUTPUT_VERTEX_NAME_KEY, edgePlan.getOutputVertexName());
            edgeMap.put(DATA_MOVEMENT_TYPE_KEY, edgePlan.getDataMovementType().name());
            edgeMap.put(DATA_SOURCE_TYPE_KEY, edgePlan.getDataSourceType().name());
            edgeMap.put(SCHEDULING_TYPE_KEY, edgePlan.getSchedulingType().name());
            edgeMap.put(EDGE_SOURCE_CLASS_KEY, edgePlan.getEdgeSource().getClassName());
            edgeMap.put(EDGE_DESTINATION_CLASS_KEY, edgePlan.getEdgeDestination().getClassName());
            if (edgePlan.getEdgeSource().hasHistoryText()) {
                edgeMap.put(OUTPUT_USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)edgePlan.getEdgeSource()));
            }
            if (edgePlan.getEdgeDestination().hasHistoryText()) {
                edgeMap.put(INPUT_USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)edgePlan.getEdgeDestination()));
            }
            edgesList.add(edgeMap);
        }
        DAGUtils.putInto(dagMap, EDGES_KEY, edgesList);
        ArrayList<Object> vertexGroupsList = new ArrayList<Object>();
        for (DAGProtos.PlanVertexGroupInfo vertexGroupInfo : dagPlan.getVertexGroupsList()) {
            LinkedHashMap<String, Object> groupMap = new LinkedHashMap<String, Object>();
            groupMap.put(VERTEX_GROUP_NAME_KEY, vertexGroupInfo.getGroupName());
            if (vertexGroupInfo.getGroupMembersCount() > 0) {
                groupMap.put(VERTEX_GROUP_MEMBERS_KEY, vertexGroupInfo.getGroupMembersList());
            }
            if (vertexGroupInfo.getOutputsCount() > 0) {
                groupMap.put(VERTEX_GROUP_OUTPUTS_KEY, vertexGroupInfo.getOutputsList());
            }
            if (vertexGroupInfo.getEdgeMergedInputsCount() > 0) {
                ArrayList edgeMergedInputs = new ArrayList();
                for (DAGProtos.PlanGroupInputEdgeInfo edgeMergedInputInfo : vertexGroupInfo.getEdgeMergedInputsList()) {
                    LinkedHashMap<String, String> edgeMergedInput = new LinkedHashMap<String, String>();
                    edgeMergedInput.put(VERTEX_GROUP_DESTINATION_VERTEX_NAME_KEY, edgeMergedInputInfo.getDestVertexName());
                    if (edgeMergedInputInfo.hasMergedInput() && edgeMergedInputInfo.getMergedInput().hasClassName()) {
                        edgeMergedInput.put(PROCESSOR_CLASS_KEY, edgeMergedInputInfo.getMergedInput().getClassName());
                        if (edgeMergedInputInfo.getMergedInput().hasHistoryText()) {
                            edgeMergedInput.put(USER_PAYLOAD_AS_TEXT, DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)edgeMergedInputInfo.getMergedInput()));
                        }
                    }
                    edgeMergedInputs.add(edgeMergedInput);
                }
                groupMap.put(VERTEX_GROUP_EDGE_MERGED_INPUTS_KEY, edgeMergedInputs);
            }
            vertexGroupsList.add(groupMap);
        }
        DAGUtils.putInto(dagMap, VERTEX_GROUPS_KEY, vertexGroupsList);
        return dagMap;
    }

    private static void putInto(Map<String, Object> map, String key, ArrayList<Object> list) {
        if (list.isEmpty()) {
            return;
        }
        map.put(key, list);
    }

    private static ArrayList<String> convertToStringArrayList(Collection<TezTaskID> collection) {
        ArrayList<String> list = new ArrayList<String>(collection.size());
        for (TezTaskID t : collection) {
            list.add(t.toString());
        }
        return list;
    }

    public static JSONObject convertVertexStatsToJSON(VertexStats vertexStats) throws JSONException {
        JSONObject jsonObject = new JSONObject(DAGUtils.convertVertexStatsToATSMap(vertexStats));
        return jsonObject;
    }

    public static Map<String, Object> convertVertexStatsToATSMap(VertexStats vertexStats) {
        LinkedHashMap<String, Object> vertexStatsMap = new LinkedHashMap<String, Object>();
        if (vertexStats == null) {
            return vertexStatsMap;
        }
        String FIRST_TASK_START_TIME_KEY = "firstTaskStartTime";
        String FIRST_TASKS_TO_START_KEY = "firstTasksToStart";
        String LAST_TASK_FINISH_TIME_KEY = "lastTaskFinishTime";
        String LAST_TASKS_TO_FINISH_KEY = "lastTasksToFinish";
        String MIN_TASK_DURATION = "minTaskDuration";
        String MAX_TASK_DURATION = "maxTaskDuration";
        String AVG_TASK_DURATION = "avgTaskDuration";
        String SHORTEST_DURATION_TASKS = "shortestDurationTasks";
        String LONGEST_DURATION_TASKS = "longestDurationTasks";
        vertexStatsMap.put("firstTaskStartTime", vertexStats.getFirstTaskStartTime());
        if (vertexStats.getFirstTasksToStart() != null && !vertexStats.getFirstTasksToStart().isEmpty()) {
            vertexStatsMap.put("firstTasksToStart", DAGUtils.convertToStringArrayList(vertexStats.getFirstTasksToStart()));
        }
        vertexStatsMap.put("lastTaskFinishTime", vertexStats.getLastTaskFinishTime());
        if (vertexStats.getLastTasksToFinish() != null && !vertexStats.getLastTasksToFinish().isEmpty()) {
            vertexStatsMap.put("lastTasksToFinish", DAGUtils.convertToStringArrayList(vertexStats.getLastTasksToFinish()));
        }
        vertexStatsMap.put("minTaskDuration", vertexStats.getMinTaskDuration());
        vertexStatsMap.put("maxTaskDuration", vertexStats.getMaxTaskDuration());
        vertexStatsMap.put("avgTaskDuration", vertexStats.getAvgTaskDuration());
        if (vertexStats.getShortestDurationTasks() != null && !vertexStats.getShortestDurationTasks().isEmpty()) {
            vertexStatsMap.put("shortestDurationTasks", DAGUtils.convertToStringArrayList(vertexStats.getShortestDurationTasks()));
        }
        if (vertexStats.getLongestDurationTasks() != null && !vertexStats.getLongestDurationTasks().isEmpty()) {
            vertexStatsMap.put("longestDurationTasks", DAGUtils.convertToStringArrayList(vertexStats.getLongestDurationTasks()));
        }
        return vertexStatsMap;
    }

    public static Map<String, Object> convertEdgeManagerPluginDescriptor(EdgeManagerPluginDescriptor descriptor) {
        HashMap<String, Object> jsonDescriptor = new HashMap<String, Object>();
        jsonDescriptor.put(EDGE_MANAGER_CLASS_KEY, descriptor.getClassName());
        if (descriptor.getHistoryText() != null && !descriptor.getHistoryText().isEmpty()) {
            jsonDescriptor.put(USER_PAYLOAD_AS_TEXT, descriptor.getHistoryText());
        }
        return jsonDescriptor;
    }

    public static Map<String, String> convertConfigurationToATSMap(Configuration conf) {
        Iterator iter = conf.iterator();
        TreeMap<String, String> atsConf = new TreeMap<String, String>();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            atsConf.put((String)entry.getKey(), (String)entry.getValue());
        }
        return atsConf;
    }
}

