/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;

public class AMContainerEventCompleted
extends AMContainerEvent {
    private final int exitStatus;
    private final String diagnostics;
    private final TaskAttemptTerminationCause errCause;

    public AMContainerEventCompleted(ContainerId containerId, int exitStatus, String diagnostics, TaskAttemptTerminationCause errCause) {
        super(containerId, AMContainerEventType.C_COMPLETED);
        this.exitStatus = exitStatus;
        this.diagnostics = diagnostics;
        this.errCause = errCause;
    }

    public boolean isPreempted() {
        return this.exitStatus == -102;
    }

    public boolean isDiskFailed() {
        return this.exitStatus == -101;
    }

    public boolean isClusterAction() {
        return this.isPreempted() || this.isDiskFailed();
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public int getContainerExitStatus() {
        return this.exitStatus;
    }

    public TaskAttemptTerminationCause getTerminationCause() {
        return this.errCause;
    }
}

