/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.dag.utils.ProtoUtils;

public class DAGSubmittedEvent
implements HistoryEvent,
SummaryEvent {
    private static final Log LOG = LogFactory.getLog(DAGSubmittedEvent.class);
    private static final String CHARSET_NAME = "utf-8";
    private TezDAGID dagID;
    private String dagName;
    private long submitTime;
    private DAGProtos.DAGPlan dagPlan;
    private ApplicationAttemptId applicationAttemptId;
    private String user;
    private Map<String, LocalResource> cumulativeAdditionalLocalResources;
    private Configuration conf;

    public DAGSubmittedEvent() {
    }

    public DAGSubmittedEvent(TezDAGID dagID, long submitTime, DAGProtos.DAGPlan dagPlan, ApplicationAttemptId applicationAttemptId, Map<String, LocalResource> cumulativeAdditionalLocalResources, String user, Configuration conf) {
        this.dagID = dagID;
        this.dagName = dagPlan.getName();
        this.submitTime = submitTime;
        this.dagPlan = dagPlan;
        this.applicationAttemptId = applicationAttemptId;
        this.cumulativeAdditionalLocalResources = cumulativeAdditionalLocalResources;
        this.user = user;
        this.conf = conf;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_SUBMITTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.DAGSubmittedProto toProto() {
        RecoveryProtos.DAGSubmittedProto.Builder builder = RecoveryProtos.DAGSubmittedProto.newBuilder().setDagId(this.dagID.toString()).setApplicationAttemptId(this.applicationAttemptId.toString()).setDagPlan(this.dagPlan).setSubmitTime(this.submitTime);
        if (this.cumulativeAdditionalLocalResources != null && !this.cumulativeAdditionalLocalResources.isEmpty()) {
            builder.setCumulativeAdditionalAmResources(DagTypeConverters.convertFromLocalResources(this.cumulativeAdditionalLocalResources));
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.DAGSubmittedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.dagPlan = proto.getDagPlan();
        this.dagName = this.dagPlan.getName();
        this.submitTime = proto.getSubmitTime();
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
        if (proto.hasCumulativeAdditionalAmResources()) {
            this.cumulativeAdditionalLocalResources = DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)proto.getCumulativeAdditionalAmResources());
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGSubmittedProto proto = RecoveryProtos.DAGSubmittedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "dagID=" + this.dagID + ", submitTime=" + this.submitTime;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        ProtoUtils.toSummaryEventProto(this.dagID, this.submitTime, HistoryEventType.DAG_SUBMITTED, this.dagName.getBytes(CHARSET_NAME)).writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.submitTime = proto.getTimestamp();
        this.dagName = new String(proto.getEventPayload().toByteArray(), CHARSET_NAME);
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return true;
    }

    public String getDAGName() {
        return this.dagName;
    }

    public DAGProtos.DAGPlan getDAGPlan() {
        return this.dagPlan;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public Map<String, LocalResource> getCumulativeAdditionalLocalResources() {
        return this.cumulativeAdditionalLocalResources;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public DAGProtos.DAGPlan getDagPlan() {
        return this.dagPlan;
    }

    public String getUser() {
        return this.user;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

