/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptEventInfo;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.VertexTerminationCause;
import org.apache.tez.dag.app.dag.event.SpeculatorEvent;
import org.apache.tez.dag.app.dag.impl.AMUserCodeException;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.VertexStatistics;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;

public interface Vertex
extends Comparable<Vertex> {
    public TezVertexID getVertexId();

    public DAGProtos.VertexPlan getVertexPlan();

    public int getDistanceFromRoot();

    public LinkedHashMap<String, Integer> getIOIndices();

    public String getName();

    public VertexState getState();

    public TezCounters getAllCounters();

    public TezCounters getCachedCounters();

    public int getMaxTaskConcurrency();

    public Map<TezTaskID, Task> getTasks();

    public Task getTask(TezTaskID var1);

    public Task getTask(int var1);

    public List<String> getDiagnostics();

    public int getTotalTasks();

    public int getCompletedTasks();

    public int getSucceededTasks();

    public int getRunningTasks();

    public float getProgress();

    public float getCompletedTaskProgress();

    public ProgressBuilder getVertexProgress();

    public VertexStatusBuilder getVertexStatus(Set<StatusGetOpts> var1);

    @Nullable
    public TaskLocationHint getTaskLocationHint(TezTaskID var1);

    public void setParallelism(int var1, VertexLocationHint var2, Map<String, EdgeManagerPluginDescriptor> var3, Map<String, InputSpecUpdate> var4, boolean var5) throws AMUserCodeException;

    public void reconfigureVertex(int var1, @Nullable VertexLocationHint var2, @Nullable Map<String, EdgeProperty> var3) throws AMUserCodeException;

    public void reconfigureVertex(@Nullable Map<String, InputSpecUpdate> var1, int var2, @Nullable VertexLocationHint var3) throws AMUserCodeException;

    public void reconfigureVertex(int var1, @Nullable VertexLocationHint var2, @Nullable Map<String, EdgeProperty> var3, @Nullable Map<String, InputSpecUpdate> var4) throws AMUserCodeException;

    public void setVertexLocationHint(VertexLocationHint var1);

    public void vertexReconfigurationPlanned();

    public void doneReconfiguringVertex();

    public void setInputVertices(Map<Vertex, Edge> var1);

    public void setOutputVertices(Map<Vertex, Edge> var1);

    public VertexStatistics getStatistics();

    public Map<Vertex, Edge> getInputVertices();

    public Map<Vertex, Edge> getOutputVertices();

    public Map<String, OutputCommitter> getOutputCommitters();

    public void setAdditionalInputs(List<DAGProtos.RootInputLeafOutputProto> var1);

    public void setAdditionalOutputs(List<DAGProtos.RootInputLeafOutputProto> var1);

    @Nullable
    public Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> getAdditionalInputs();

    @Nullable
    public Map<String, RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> getAdditionalOutputs();

    public List<InputSpec> getInputSpecList(int var1) throws AMUserCodeException;

    public List<OutputSpec> getOutputSpecList(int var1) throws AMUserCodeException;

    public List<GroupInputSpec> getGroupInputSpecList(int var1);

    public void addSharedOutputs(Set<String> var1);

    public Set<String> getSharedOutputs();

    public int getInputVerticesCount();

    public int getOutputVerticesCount();

    public void scheduleTasks(List<VertexManagerPluginContext.ScheduleTaskRequest> var1);

    public void scheduleSpeculativeTask(TezTaskID var1);

    public Resource getTaskResource();

    public TaskAttemptEventInfo getTaskAttemptTezEvents(TezTaskAttemptID var1, int var2, int var3, int var4);

    public void handleSpeculatorEvent(SpeculatorEvent var1);

    public ProcessorDescriptor getProcessorDescriptor();

    public DAG getDAG();

    @Nullable
    public VertexTerminationCause getTerminationCause();

    public AppContext getAppContext();

    public String getLogIdentifier();

    public void incrementFailedTaskAttemptCount();

    public void incrementKilledTaskAttemptCount();

    public int getFailedTaskAttemptCount();

    public int getKilledTaskAttemptCount();

    public Configuration getConf();

    public boolean isSpeculationEnabled();

    public int getTaskSchedulerIdentifier();

    public int getContainerLauncherIdentifier();

    public int getTaskCommunicatorIdentifier();

    public ServicePluginInfo getServicePluginInfo();

    public long getInitTime();

    public long getStartTime();

    public long getFinishTime();

    public void reportTaskStartTime(long var1);

    public long getFirstTaskStartTime();

    public long getLastTaskFinishTime();
}

