/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class VertexStartedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private long startRequestedTime;
    private long startTime;

    public VertexStartedEvent() {
    }

    public VertexStartedEvent(TezVertexID vertexId, long startRequestedTime, long startTime) {
        this.vertexID = vertexId;
        this.startRequestedTime = startRequestedTime;
        this.startTime = startTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexStartedProto toProto() {
        return RecoveryProtos.VertexStartedProto.newBuilder().setVertexId(this.vertexID.toString()).setStartRequestedTime(this.startRequestedTime).setStartTime(this.startTime).build();
    }

    public void fromProto(RecoveryProtos.VertexStartedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.startRequestedTime = proto.getStartRequestedTime();
        this.startTime = proto.getStartTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexStartedProto proto = RecoveryProtos.VertexStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID + ", startRequestedTime=" + this.startRequestedTime + ", startedTime=" + this.startTime;
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public long getStartRequestedTime() {
        return this.startRequestedTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public VertexState getVertexState() {
        return VertexState.RUNNING;
    }
}

