/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.EnumSet;
import org.apache.hadoop.util.ProgramDriver;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.examples.JoinDataGen;
import org.apache.tez.examples.JoinExample;
import org.apache.tez.examples.JoinValidate;
import org.apache.tez.examples.OrderedWordCount;
import org.apache.tez.examples.SimpleSessionExample;
import org.apache.tez.examples.WordCount;

public class ExampleDriver {
    private static final DecimalFormat formatter = new DecimalFormat("###.##%");

    public static void main(String[] argv) {
        int exitCode = -1;
        ProgramDriver pgd = new ProgramDriver();
        try {
            pgd.addClass("wordcount", WordCount.class, "A native Tez wordcount program that counts the words in the input files.");
            pgd.addClass("orderedwordcount", OrderedWordCount.class, "Word Count with words sorted on frequency");
            pgd.addClass("simplesessionexample", SimpleSessionExample.class, "Example to run multiple dags in a session");
            pgd.addClass("joinexample", JoinExample.class, "Identify all occurences of lines in file1 which also occur in file2");
            pgd.addClass("joindatagen", JoinDataGen.class, "Generate data to run the joinexample");
            pgd.addClass("joinvalidate", JoinValidate.class, "Validate data generated by joinexample and joindatagen");
            exitCode = pgd.run(argv);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(exitCode);
    }

    public static void printDAGStatus(DAGClient dagClient, String[] vertexNames) throws IOException, TezException {
        ExampleDriver.printDAGStatus(dagClient, vertexNames, false, false);
    }

    public static void printDAGStatus(DAGClient dagClient, String[] vertexNames, boolean displayDAGCounters, boolean displayVertexCounters) throws IOException, TezException {
        TezCounters counters;
        EnumSet<StatusGetOpts> opts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
        DAGStatus dagStatus = dagClient.getDAGStatus(displayDAGCounters ? opts : null);
        Progress progress = dagStatus.getDAGProgress();
        double vProgressFloat = 0.0;
        if (progress != null) {
            System.out.println("");
            System.out.println("DAG: State: " + dagStatus.getState() + " Progress: " + (progress.getTotalTaskCount() < 0 ? formatter.format(0.0) : formatter.format((double)progress.getSucceededTaskCount() / (double)progress.getTotalTaskCount())));
            for (String vertexName : vertexNames) {
                TezCounters counters2;
                VertexStatus vStatus = dagClient.getVertexStatus(vertexName, displayVertexCounters ? opts : null);
                if (vStatus == null) {
                    System.out.println("Could not retrieve status for vertex: " + vertexName);
                    continue;
                }
                Progress vProgress = vStatus.getProgress();
                if (vProgress != null) {
                    vProgressFloat = 0.0;
                    if (vProgress.getTotalTaskCount() == 0) {
                        vProgressFloat = 1.0;
                    } else if (vProgress.getTotalTaskCount() > 0) {
                        vProgressFloat = (double)vProgress.getSucceededTaskCount() / (double)vProgress.getTotalTaskCount();
                    }
                    System.out.println("VertexStatus: VertexName: " + (vertexName.equals("ivertex1") ? "intermediate-reducer" : vertexName) + " Progress: " + formatter.format(vProgressFloat));
                }
                if (!displayVertexCounters || (counters2 = vStatus.getVertexCounters()) == null) continue;
                System.out.println("Vertex Counters for " + vertexName + ": " + counters2);
            }
        }
        if (displayDAGCounters && (counters = dagStatus.getDAGCounters()) != null) {
            System.out.println("DAG Counters: " + counters);
        }
    }
}

