/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezSession;
import org.apache.tez.client.TezSessionConfiguration;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.common.MRInputAMSplitGenerator;
import org.apache.tez.mapreduce.examples.ExampleDriver;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.input.ShuffledMergedInput;
import org.apache.tez.runtime.library.output.OnFileSortedOutput;

public class WordCount {
    private Credentials credentials = new Credentials();

    private DAG createDAG(FileSystem fs, TezConfiguration tezConf, Map<String, LocalResource> localResources, Path stagingDir, String inputPath, String outputPath) throws IOException {
        JobConf mapStageConf = new JobConf((Configuration)tezConf);
        mapStageConf.set("mapreduce.map.output.key.class", Text.class.getName());
        mapStageConf.set("mapreduce.map.output.value.class", IntWritable.class.getName());
        mapStageConf.set("mapreduce.job.inputformat.class", TezGroupedSplitsInputFormat.class.getName());
        mapStageConf.set("mapreduce.input.fileinputformat.inputdir", inputPath);
        mapStageConf.setBoolean("mapred.mapper.new-api", true);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)mapStageConf, null);
        JobConf finalReduceConf = new JobConf((Configuration)tezConf);
        finalReduceConf.set("mapreduce.map.output.key.class", Text.class.getName());
        finalReduceConf.set("mapreduce.map.output.value.class", IntWritable.class.getName());
        finalReduceConf.set("mapreduce.job.outputformat.class", TextOutputFormat.class.getName());
        finalReduceConf.set("mapreduce.output.fileoutputformat.outputdir", outputPath);
        finalReduceConf.setBoolean("mapred.mapper.new-api", false);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)finalReduceConf, (Configuration)mapStageConf);
        MRHelpers.doJobClientMagic((Configuration)mapStageConf);
        MRHelpers.doJobClientMagic((Configuration)finalReduceConf);
        byte[] mapPayload = MRHelpers.createUserPayloadFromConf((Configuration)mapStageConf);
        byte[] mapInputPayload = MRHelpers.createMRInputPayloadWithGrouping((byte[])mapPayload, (String)TextInputFormat.class.getName());
        int numMaps = -1;
        Vertex tokenizerVertex = new Vertex("tokenizer", new ProcessorDescriptor(TokenProcessor.class.getName()), numMaps, MRHelpers.getMapResource((Configuration)mapStageConf));
        tokenizerVertex.setJavaOpts(MRHelpers.getMapJavaOpts((Configuration)mapStageConf));
        HashMap mapEnv = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)mapStageConf, mapEnv, (boolean)true);
        tokenizerVertex.setTaskEnvironment(mapEnv);
        Class<MRInputAMSplitGenerator> initializerClazz = MRInputAMSplitGenerator.class;
        InputDescriptor id = new InputDescriptor(MRInput.class.getName()).setUserPayload(mapInputPayload);
        tokenizerVertex.addInput("MRInput", id, initializerClazz);
        byte[] finalReducePayload = MRHelpers.createUserPayloadFromConf((Configuration)finalReduceConf);
        Vertex summerVertex = new Vertex("summer", new ProcessorDescriptor(SumProcessor.class.getName()).setUserPayload(finalReducePayload), 1, MRHelpers.getReduceResource((Configuration)finalReduceConf));
        summerVertex.setJavaOpts(MRHelpers.getReduceJavaOpts((Configuration)finalReduceConf));
        HashMap reduceEnv = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)finalReduceConf, reduceEnv, (boolean)false);
        summerVertex.setTaskEnvironment(reduceEnv);
        OutputDescriptor od = new OutputDescriptor(MROutput.class.getName()).setUserPayload(finalReducePayload);
        summerVertex.addOutput("MROutput", od, MROutputCommitter.class);
        DAG dag = new DAG("WordCount");
        dag.addVertex(tokenizerVertex).addVertex(summerVertex).addEdge(new Edge(tokenizerVertex, summerVertex, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(OnFileSortedOutput.class.getName()).setUserPayload(mapPayload), new InputDescriptor(ShuffledMergedInput.class.getName()).setUserPayload(finalReducePayload))));
        return dag;
    }

    private static void waitForTezSessionReady(TezSession tezSession) throws IOException, TezException {
        while (true) {
            TezSessionStatus status;
            if ((status = tezSession.getSessionStatus()).equals((Object)TezSessionStatus.SHUTDOWN)) {
                throw new RuntimeException("TezSession has already shutdown");
            }
            if (status.equals((Object)TezSessionStatus.READY)) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage:  wordcount <in1> <out1>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String inputPath, String outputPath, Configuration conf) throws Exception {
        System.out.println("Running WordCount");
        TezConfiguration tezConf = conf != null ? new TezConfiguration(conf) : new TezConfiguration();
        UserGroupInformation.setConfiguration((Configuration)tezConf);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        TezClient tezClient = new TezClient(tezConf);
        ApplicationId appId = tezClient.createApplication();
        FileSystem fs = FileSystem.get((Configuration)tezConf);
        String stagingDirStr = "/user/" + user + "/" + ".staging" + "/" + "/" + appId.toString();
        Path stagingDir = new Path(stagingDirStr);
        tezConf.set("tez.staging-dir", stagingDirStr);
        stagingDir = fs.makeQualified(stagingDir);
        TokenCache.obtainTokensForNamenodes((Credentials)this.credentials, (Path[])new Path[]{stagingDir}, (Configuration)tezConf);
        TezClientUtils.ensureStagingDirExists((Configuration)tezConf, (Path)stagingDir);
        tezConf.set("tez.am.java.opts", MRHelpers.getMRAMJavaOpts((Configuration)tezConf));
        TezSession tezSession = null;
        AMConfiguration amConfig = new AMConfiguration(null, null, tezConf, this.credentials);
        TezSessionConfiguration sessionConfig = new TezSessionConfiguration(amConfig, tezConf);
        tezSession = new TezSession("WordCountSession", appId, sessionConfig);
        tezSession.start();
        DAGStatus dagStatus = null;
        DAGClient dagClient = null;
        String[] vNames = new String[]{"tokenizer", "summer"};
        EnumSet<StatusGetOpts> statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
        try {
            if (fs.exists(new Path(outputPath))) {
                throw new FileAlreadyExistsException("Output directory " + outputPath + " already exists");
            }
            TreeMap<String, LocalResource> localResources = new TreeMap<String, LocalResource>();
            DAG dag = this.createDAG(fs, tezConf, localResources, stagingDir, inputPath, outputPath);
            WordCount.waitForTezSessionReady(tezSession);
            dagClient = tezSession.submitDAG(dag);
            while ((dagStatus = dagClient.getDAGStatus(statusGetOpts)).getState() != DAGStatus.State.RUNNING && dagStatus.getState() != DAGStatus.State.SUCCEEDED && dagStatus.getState() != DAGStatus.State.FAILED && dagStatus.getState() != DAGStatus.State.KILLED && dagStatus.getState() != DAGStatus.State.ERROR) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            while (dagStatus.getState() == DAGStatus.State.RUNNING) {
                try {
                    ExampleDriver.printDAGStatus(dagClient, vNames);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    dagStatus = dagClient.getDAGStatus(statusGetOpts);
                }
                catch (TezException e) {
                    System.exit(-1);
                }
            }
            ExampleDriver.printDAGStatus(dagClient, vNames, true, true);
            System.out.println("DAG completed. FinalState=" + dagStatus.getState());
            if (dagStatus.getState() != DAGStatus.State.SUCCEEDED) {
                System.out.println("DAG diagnostics: " + dagStatus.getDiagnostics());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            fs.delete(stagingDir, true);
            tezSession.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length != 2) {
            WordCount.printUsage();
            System.exit(2);
        }
        WordCount job = new WordCount();
        job.run(otherArgs[0], otherArgs[1], conf);
    }

    public static class SumProcessor
    implements LogicalIOProcessor {
        TezProcessorContext context;

        public void initialize(TezProcessorContext processorContext) throws Exception {
            this.context = processorContext;
        }

        public void handleEvents(List<Event> processorEvents) {
        }

        public void close() throws Exception {
        }

        public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
            Preconditions.checkArgument((inputs.size() == 1 ? 1 : 0) != 0);
            for (LogicalInput input : inputs.values()) {
                input.start();
            }
            for (LogicalOutput output : outputs.values()) {
                output.start();
            }
            MROutput out = (MROutput)outputs.values().iterator().next();
            KeyValueWriter kvWriter = out.getWriter();
            KeyValuesReader kvReader = (KeyValuesReader)inputs.values().iterator().next().getReader();
            while (kvReader.next()) {
                Text word = (Text)kvReader.getCurrentKey();
                int sum = 0;
                for (Object value : kvReader.getCurrentValues()) {
                    sum += ((IntWritable)value).get();
                }
                kvWriter.write((Object)word, (Object)new IntWritable(sum));
            }
            if (out.isCommitRequired()) {
                while (!this.context.canCommit()) {
                    Thread.sleep(100L);
                }
                out.commit();
            }
        }
    }

    public static class TokenProcessor
    implements LogicalIOProcessor {
        TezProcessorContext context;
        IntWritable one = new IntWritable(1);
        Text word = new Text();

        public void initialize(TezProcessorContext processorContext) throws Exception {
            this.context = processorContext;
        }

        public void handleEvents(List<Event> processorEvents) {
        }

        public void close() throws Exception {
        }

        public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
            for (LogicalInput input : inputs.values()) {
                input.start();
            }
            for (LogicalOutput output : outputs.values()) {
                output.start();
            }
            Preconditions.checkArgument((inputs.size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0);
            MRInput input = (MRInput)inputs.values().iterator().next();
            KeyValueReader kvReader = input.getReader();
            OnFileSortedOutput output = (OnFileSortedOutput)outputs.values().iterator().next();
            KeyValueWriter kvWriter = output.getWriter();
            while (kvReader.next()) {
                StringTokenizer itr = new StringTokenizer(kvReader.getCurrentValue().toString());
                while (itr.hasMoreTokens()) {
                    this.word.set(itr.nextToken());
                    kvWriter.write((Object)this.word, (Object)this.one);
                }
            }
        }
    }
}

