/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TezEvent;

public class TezHeartbeatRequest
implements Writable {
    private String containerIdentifier;
    private List<TezEvent> events;
    private TezTaskAttemptID currentTaskAttemptID;
    private int startIndex;
    private int preRoutedStartIndex;
    private int maxEvents;
    private long requestId;

    public TezHeartbeatRequest() {
    }

    public TezHeartbeatRequest(long requestId, List<TezEvent> events, int preRoutedStartIndex, String containerIdentifier, TezTaskAttemptID taskAttemptID, int startIndex, int maxEvents) {
        this.containerIdentifier = containerIdentifier;
        this.requestId = requestId;
        this.events = Collections.unmodifiableList(events);
        this.startIndex = startIndex;
        this.preRoutedStartIndex = preRoutedStartIndex;
        this.maxEvents = maxEvents;
        this.currentTaskAttemptID = taskAttemptID;
    }

    public String getContainerIdentifier() {
        return this.containerIdentifier;
    }

    public List<TezEvent> getEvents() {
        return this.events;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getPreRoutedStartIndex() {
        return this.preRoutedStartIndex;
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public TezTaskAttemptID getCurrentTaskAttemptID() {
        return this.currentTaskAttemptID;
    }

    public void write(DataOutput out) throws IOException {
        if (this.events != null) {
            out.writeBoolean(true);
            out.writeInt(this.events.size());
            for (TezEvent e : this.events) {
                e.write(out);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.currentTaskAttemptID != null) {
            out.writeBoolean(true);
            this.currentTaskAttemptID.write(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.startIndex);
        out.writeInt(this.preRoutedStartIndex);
        out.writeInt(this.maxEvents);
        out.writeLong(this.requestId);
        Text.writeString((DataOutput)out, (String)this.containerIdentifier);
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            int eventsCount = in.readInt();
            this.events = new ArrayList<TezEvent>(eventsCount);
            for (int i = 0; i < eventsCount; ++i) {
                TezEvent e = new TezEvent();
                e.readFields(in);
                this.events.add(e);
            }
        }
        this.currentTaskAttemptID = in.readBoolean() ? TezTaskAttemptID.readTezTaskAttemptID((DataInput)in) : null;
        this.startIndex = in.readInt();
        this.preRoutedStartIndex = in.readInt();
        this.maxEvents = in.readInt();
        this.requestId = in.readLong();
        this.containerIdentifier = Text.readString((DataInput)in);
    }

    public String toString() {
        return "{  containerId=" + this.containerIdentifier + ", requestId=" + this.requestId + ", startIndex=" + this.startIndex + ", preRoutedStartIndex=" + this.preRoutedStartIndex + ", maxEventsToGet=" + this.maxEvents + ", taskAttemptId=" + this.currentTaskAttemptID + ", eventCount=" + (this.events != null ? this.events.size() : 0) + " }";
    }
}

