/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.Writer;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutput
extends AbstractLogicalOutput {
    private static final Logger LOG = LoggerFactory.getLogger(TestOutput.class);
    public static final String COUNTER_NAME = "TestOutput";
    int output;

    public TestOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public static OutputDescriptor getOutputDesc(UserPayload payload) {
        OutputDescriptor desc = OutputDescriptor.create((String)TestOutput.class.getName());
        if (payload != null) {
            desc.setUserPayload(payload);
        }
        return desc;
    }

    public List<Event> initialize() throws Exception {
        this.getContext().requestInitialMemory(0L, null);
        return Collections.emptyList();
    }

    void write(int value) {
        this.output = value;
    }

    public void start() {
    }

    public Writer getWriter() throws Exception {
        return null;
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public List<Event> close() throws Exception {
        LOG.info("Sending data movement event with value: " + this.output);
        this.getContext().getCounters().findCounter(COUNTER_NAME, COUNTER_NAME).increment(1L);
        ByteBuffer result = ByteBuffer.allocate(4).putInt(this.output);
        result.flip();
        ArrayList events = Lists.newArrayListWithCapacity((int)this.getNumPhysicalOutputs());
        for (int i = 0; i < this.getNumPhysicalOutputs(); ++i) {
            DataMovementEvent event = DataMovementEvent.create((int)i, (ByteBuffer)result);
            events.add(event);
        }
        ShuffleUserPayloads.VertexManagerEventPayloadProto.Builder vmBuilder = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder().setNumRecord(1L);
        VertexManagerEvent vmEvent = VertexManagerEvent.create((String)this.getContext().getDestinationVertexName(), (ByteBuffer)vmBuilder.build().toByteString().asReadOnlyByteBuffer());
        events.add(vmEvent);
        return events;
    }
}

