/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.ats.acls;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.tez.common.security.ACLConfigurationParser;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.common.security.ACLType;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.common.security.HistoryACLPolicyException;
import org.apache.tez.common.security.HistoryACLPolicyManager;
import org.apache.tez.dag.api.TezUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATSHistoryACLPolicyManager
implements HistoryACLPolicyManager {
    private static final Logger LOG = LoggerFactory.getLogger(ATSHistoryACLPolicyManager.class);
    TimelineClient timelineClient;
    Configuration conf;
    String user;
    static final String DOMAIN_ID_PREFIX = "Tez_ATS_";
    private static final String atsHistoryLoggingServiceClassName = "org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService";

    private void initializeTimelineClient() {
        if (this.conf == null) {
            throw new TezUncheckedException("ATSACLManager not configured");
        }
        if (this.timelineClient != null) {
            this.timelineClient.stop();
            this.timelineClient = null;
        }
        if (this.conf.getBoolean("yarn.timeline-service.enabled", false)) {
            this.timelineClient = TimelineClient.createTimelineClient();
            this.timelineClient.init(this.conf);
            this.timelineClient.start();
        } else {
            this.timelineClient = null;
            if (this.conf.get("tez.history.logging.service.class", "").equals(atsHistoryLoggingServiceClassName)) {
                LOG.warn("org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService is disabled due to Timeline Service being disabled, yarn.timeline-service.enabled set to false");
            }
        }
        try {
            this.user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            throw new TezUncheckedException("Unable to get Current User UGI", (Throwable)e);
        }
    }

    private String getMergedViewACLs(ACLConfigurationParser parser, DAGAccessControls dagAccessControls) {
        Map allowedUsers = parser.getAllowedUsers();
        Map allowedGroups = parser.getAllowedGroups();
        HashSet<String> viewUsers = new HashSet<String>();
        viewUsers.add(this.user);
        if (allowedUsers.containsKey(ACLType.AM_VIEW_ACL)) {
            viewUsers.addAll((Collection)allowedUsers.get(ACLType.AM_VIEW_ACL));
        }
        if (dagAccessControls != null && dagAccessControls.getUsersWithViewACLs() != null) {
            viewUsers.addAll(dagAccessControls.getUsersWithViewACLs());
        }
        if (viewUsers.contains("*")) {
            return "*";
        }
        HashSet viewGroups = new HashSet();
        if (allowedGroups.containsKey(ACLType.AM_VIEW_ACL)) {
            viewGroups.addAll((Collection)allowedGroups.get(ACLType.AM_VIEW_ACL));
        }
        if (dagAccessControls != null && dagAccessControls.getGroupsWithViewACLs() != null) {
            viewGroups.addAll(dagAccessControls.getGroupsWithViewACLs());
        }
        return ACLManager.toCommaSeparatedString(viewUsers) + " " + ACLManager.toCommaSeparatedString(viewGroups);
    }

    private void createTimelineDomain(String domainId, Configuration tezConf, DAGAccessControls dagAccessControls) throws IOException, HistoryACLPolicyException {
        TimelineDomain timelineDomain = new TimelineDomain();
        timelineDomain.setId(domainId);
        ACLConfigurationParser parser = new ACLConfigurationParser(tezConf, false);
        timelineDomain.setReaders(this.getMergedViewACLs(parser, dagAccessControls));
        timelineDomain.setWriters(this.user);
        try {
            if (this.timelineClient != null) {
                this.timelineClient.putDomain(timelineDomain);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not post timeline domain", (Throwable)e);
            throw new HistoryACLPolicyException("Fail to create ACL-related domain in Timeline", (Throwable)e);
        }
    }

    private Map<String, String> createSessionDomain(Configuration tezConf, ApplicationId applicationId, DAGAccessControls dagAccessControls) throws IOException, HistoryACLPolicyException {
        String domainId = tezConf.get("tez.yarn.ats.acl.session.domain.id");
        if (!tezConf.getBoolean("tez.am.acls.enabled", true)) {
            if (domainId != null) {
                throw new TezUncheckedException("ACLs disabled but DomainId is specified, aclsEnabled=true, domainId=" + domainId);
            }
            return null;
        }
        boolean autoCreateDomain = tezConf.getBoolean("tez.yarn.ats.acl.domains.auto-create", true);
        if (domainId != null) {
            LOG.info("Using specified domainId with Timeline, domainId=" + domainId);
            return null;
        }
        if (!autoCreateDomain) {
            throw new TezUncheckedException("Timeline DomainId is not specified and auto-create Domains is disabled");
        }
        domainId = DOMAIN_ID_PREFIX + applicationId.toString();
        this.createTimelineDomain(domainId, tezConf, dagAccessControls);
        LOG.info("Created Timeline Domain for History ACLs, domainId=" + domainId);
        return Collections.singletonMap("tez.yarn.ats.acl.session.domain.id", domainId);
    }

    private Map<String, String> createDAGDomain(Configuration tezConf, ApplicationId applicationId, String dagName, DAGAccessControls dagAccessControls) throws IOException, HistoryACLPolicyException {
        if (dagAccessControls == null) {
            return null;
        }
        String domainId = tezConf.get("tez.yarn.ats.acl.dag.domain.id");
        if (!tezConf.getBoolean("tez.am.acls.enabled", true)) {
            if (domainId != null) {
                throw new TezUncheckedException("ACLs disabled but domainId for DAG is specified, aclsEnabled=true, domainId=" + domainId);
            }
            return null;
        }
        boolean autoCreateDomain = tezConf.getBoolean("tez.yarn.ats.acl.domains.auto-create", true);
        if (domainId != null) {
            LOG.info("Using specified domainId with Timeline, domainId=" + domainId);
            return null;
        }
        if (!autoCreateDomain) {
            throw new TezUncheckedException("Timeline DomainId is not specified and auto-create Domains is disabled");
        }
        domainId = DOMAIN_ID_PREFIX + applicationId.toString() + "_" + dagName;
        this.createTimelineDomain(domainId, tezConf, dagAccessControls);
        LOG.info("Created Timeline Domain for DAG-specific History ACLs, domainId=" + domainId);
        return Collections.singletonMap("tez.yarn.ats.acl.dag.domain.id", domainId);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.initializeTimelineClient();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Map<String, String> setupSessionACLs(Configuration conf, ApplicationId applicationId) throws IOException, HistoryACLPolicyException {
        return this.createSessionDomain(conf, applicationId, null);
    }

    public Map<String, String> setupNonSessionACLs(Configuration conf, ApplicationId applicationId, DAGAccessControls dagAccessControls) throws IOException, HistoryACLPolicyException {
        return this.createSessionDomain(conf, applicationId, dagAccessControls);
    }

    public Map<String, String> setupSessionDAGACLs(Configuration conf, ApplicationId applicationId, String dagName, DAGAccessControls dagAccessControls) throws IOException, HistoryACLPolicyException {
        return this.createDAGDomain(conf, applicationId, dagName, dagAccessControls);
    }

    public void updateTimelineEntityDomain(Object timelineEntity, String domainId) {
        if (!(timelineEntity instanceof TimelineEntity)) {
            throw new UnsupportedOperationException("Invalid object provided of type" + timelineEntity.getClass().getName());
        }
        TimelineEntity entity = (TimelineEntity)timelineEntity;
        entity.setDomainId(domainId);
    }

    public void close() {
        if (this.timelineClient != null && this.timelineClient.isInState(Service.STATE.STARTED)) {
            this.timelineClient.stop();
        }
    }
}

