/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFNotes;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HSLFExtractor
extends AbstractPOIFSExtractor {
    public HSLFExtractor(ParseContext context) {
        super(context);
    }

    protected void parse(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HSLFNotes notes;
        HSLFSlideShow ss = new HSLFSlideShow(root);
        List _slides = ss.getSlides();
        xhtml.startElement("div", "class", "slideShow");
        for (HSLFSlide slide : _slides) {
            xhtml.startElement("div", "class", "slide");
            HeadersFooters hf = slide.getHeadersFooters();
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.extractMaster(xhtml, slide.getMasterSheet());
            xhtml.startElement("div", "class", "slide-content");
            this.textRunsToText(xhtml, slide.getTextParagraphs());
            xhtml.endElement("div");
            for (HSLFShape shape : slide.getShapes()) {
                if (!(shape instanceof HSLFTable)) continue;
                this.extractTableText(xhtml, (HSLFTable)shape);
            }
            if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                xhtml.startElement("p", "class", "slide-footer");
                xhtml.characters(hf.getFooterText());
                xhtml.endElement("p");
            }
            StringBuilder authorStringBuilder = new StringBuilder();
            for (Comment comment : slide.getComments()) {
                authorStringBuilder.setLength(0);
                xhtml.startElement("p", "class", "slide-comment");
                if (comment.getAuthor() != null) {
                    authorStringBuilder.append(comment.getAuthor());
                }
                if (comment.getAuthorInitials() != null) {
                    if (authorStringBuilder.length() > 0) {
                        authorStringBuilder.append(" ");
                    }
                    authorStringBuilder.append("(" + comment.getAuthorInitials() + ")");
                }
                if (authorStringBuilder.length() > 0) {
                    if (comment.getText() != null) {
                        authorStringBuilder.append(" - ");
                    }
                    xhtml.startElement("b");
                    xhtml.characters(authorStringBuilder.toString());
                    xhtml.endElement("b");
                }
                if (comment.getText() != null) {
                    xhtml.characters(comment.getText());
                }
                xhtml.endElement("p");
            }
            this.handleSlideEmbeddedResources(slide, xhtml);
            notes = slide.getNotes();
            if (notes != null) {
                xhtml.startElement("div", "class", "slide-notes");
                this.textRunsToText(xhtml, notes.getTextParagraphs());
                xhtml.endElement("div");
            }
            xhtml.endElement("div");
        }
        xhtml.endElement("div");
        xhtml.startElement("div", "class", "slide-notes");
        HashSet<Integer> seenNotes = new HashSet<Integer>();
        HeadersFooters hf = ss.getNotesHeadersFooters();
        for (HSLFSlide slide : _slides) {
            Integer id;
            notes = slide.getNotes();
            if (notes == null || seenNotes.contains(id = Integer.valueOf(notes._getSheetNumber()))) continue;
            seenNotes.add(id);
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-note-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.textRunsToText(xhtml, notes.getTextParagraphs());
            if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
            xhtml.startElement("p", "class", "slide-note-footer");
            xhtml.characters(hf.getFooterText());
            xhtml.endElement("p");
        }
        this.handleSlideEmbeddedPictures(ss, xhtml);
        xhtml.endElement("div");
    }

    private void extractMaster(XHTMLContentHandler xhtml, HSLFMasterSheet master) throws SAXException {
        if (master == null) {
            return;
        }
        List shapes = master.getShapes();
        if (shapes == null || shapes.isEmpty()) {
            return;
        }
        xhtml.startElement("div", "class", "slide-master-content");
        for (HSLFShape shape : shapes) {
            HSLFTextShape tsh;
            String text;
            if (shape == null || HSLFMasterSheet.isPlaceholder((HSLFShape)shape) || !(shape instanceof HSLFTextShape) || (text = (tsh = (HSLFTextShape)shape).getText()) == null) continue;
            xhtml.element("p", text);
        }
        xhtml.endElement("div");
    }

    private void extractTableText(XHTMLContentHandler xhtml, HSLFTable shape) throws SAXException {
        xhtml.startElement("table");
        for (int row = 0; row < shape.getNumberOfRows(); ++row) {
            xhtml.startElement("tr");
            for (int col = 0; col < shape.getNumberOfColumns(); ++col) {
                HSLFTableCell cell = shape.getCell(row, col);
                String txt = "";
                if (cell != null) {
                    txt = cell.getText();
                }
                xhtml.element("td", txt);
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("table");
    }

    private void textRunsToText(XHTMLContentHandler xhtml, List<List<HSLFTextParagraph>> paragraphsList) throws SAXException {
        if (paragraphsList == null) {
            return;
        }
        for (List<HSLFTextParagraph> run : paragraphsList) {
            boolean isBullet = false;
            for (HSLFTextParagraph htp : run) {
                boolean nextBullet = htp.isBullet();
                if (isBullet != nextBullet) {
                    isBullet = nextBullet;
                    if (isBullet) {
                        xhtml.startElement("ul");
                    } else {
                        xhtml.endElement("ul");
                    }
                }
                List textRuns = htp.getTextRuns();
                String firstLine = HSLFExtractor.removePBreak(((HSLFTextRun)textRuns.get(0)).getRawText());
                boolean showBullet = isBullet && (textRuns.size() > 1 || !"".equals(firstLine));
                String paraTag = showBullet ? "li" : "p";
                xhtml.startElement(paraTag);
                for (HSLFTextRun htr : textRuns) {
                    String line = htr.getRawText();
                    if (line == null) continue;
                    boolean isfirst = true;
                    for (String fragment : line.split("\\u000b")) {
                        if (!isfirst) {
                            xhtml.startElement("br");
                            xhtml.endElement("br");
                        }
                        isfirst = false;
                        xhtml.characters(HSLFExtractor.removePBreak(fragment));
                    }
                    if (!line.endsWith("\u000b")) continue;
                    xhtml.startElement("br");
                    xhtml.endElement("br");
                }
                xhtml.endElement(paraTag);
            }
            if (!isBullet) continue;
            xhtml.endElement("ul");
        }
    }

    private static String removePBreak(String fragment) {
        return fragment.replaceFirst("\\r$", "");
    }

    private void handleSlideEmbeddedPictures(HSLFSlideShow slideshow, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        for (HSLFPictureData pic : slideshow.getPictureData()) {
            String mediaType;
            switch (pic.getType()) {
                case EMF: {
                    mediaType = "application/x-emf";
                    break;
                }
                case WMF: {
                    mediaType = "application/x-msmetafile";
                    break;
                }
                case DIB: {
                    mediaType = "image/bmp";
                    break;
                }
                default: {
                    mediaType = pic.getContentType();
                }
            }
            this.handleEmbeddedResource(TikaInputStream.get((byte[])pic.getData()), null, null, mediaType, xhtml, false);
        }
    }

    private void handleSlideEmbeddedResources(HSLFSlide slide, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        List shapes;
        try {
            shapes = slide.getShapes();
        }
        catch (NullPointerException e) {
            return;
        }
        for (HSLFShape shape : shapes) {
            if (!(shape instanceof OLEShape)) continue;
            OLEShape oleShape = (OLEShape)shape;
            HSLFObjectData data = null;
            try {
                data = oleShape.getObjectData();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (data == null) continue;
            String objID = Integer.toString(oleShape.getObjectID());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", objID);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
            TikaInputStream stream = TikaInputStream.get((InputStream)data.getData());
            Throwable throwable = null;
            try {
                String mediaType = null;
                if ("Excel.Chart.8".equals(oleShape.getProgID())) {
                    mediaType = "application/vnd.ms-excel";
                }
                this.handleEmbeddedResource(stream, objID, objID, mediaType, xhtml, false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }
}

