/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamProvider;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.ServiceLoaderIterator;
import org.apache.commons.compress.utils.Sets;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.MemoryLimitException;

@Deprecated
class TikaCompressorStreamFactory
implements CompressorStreamProvider {
    private static final TikaCompressorStreamFactory SINGLETON = new TikaCompressorStreamFactory(true, -1);
    public static final String BZIP2 = "bzip2";
    public static final String GZIP = "gz";
    public static final String PACK200 = "pack200";
    public static final String XZ = "xz";
    public static final String LZMA = "lzma";
    public static final String SNAPPY_FRAMED = "snappy-framed";
    public static final String SNAPPY_RAW = "snappy-raw";
    public static final String Z = "z";
    public static final String DEFLATE = "deflate";
    private final int memoryLimitInKb;
    private SortedMap<String, CompressorStreamProvider> compressorInputStreamProviders;
    private final Boolean decompressUntilEOF;
    private volatile boolean decompressConcatenated = false;

    public static String getBzip2() {
        return BZIP2;
    }

    public static String getDeflate() {
        return DEFLATE;
    }

    public static String getGzip() {
        return GZIP;
    }

    public static String getLzma() {
        return LZMA;
    }

    public static String getPack200() {
        return PACK200;
    }

    public static TikaCompressorStreamFactory getSingleton() {
        return SINGLETON;
    }

    public static String getSnappyFramed() {
        return SNAPPY_FRAMED;
    }

    public static String getSnappyRaw() {
        return SNAPPY_RAW;
    }

    public static String getXz() {
        return XZ;
    }

    public static String getZ() {
        return Z;
    }

    static void putAll(Set<String> names, CompressorStreamProvider provider, TreeMap<String, CompressorStreamProvider> map) {
        for (String name : names) {
            map.put(TikaCompressorStreamFactory.toKey(name), provider);
        }
    }

    private static String toKey(String name) {
        return name.toUpperCase(Locale.ROOT);
    }

    public TikaCompressorStreamFactory(boolean decompressUntilEOF, int memoryLimitInKb) {
        this.decompressUntilEOF = decompressUntilEOF;
        this.decompressConcatenated = decompressUntilEOF;
        this.memoryLimitInKb = memoryLimitInKb;
    }

    public static String detect(InputStream in) throws CompressorException {
        if (in == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] signature = new byte[12];
        in.mark(signature.length);
        int signatureLength = -1;
        try {
            signatureLength = IOUtils.readFully((InputStream)in, (byte[])signature);
            in.reset();
        }
        catch (IOException e) {
            throw new CompressorException("IOException while reading signature.", (Throwable)e);
        }
        if (BZip2CompressorInputStream.matches((byte[])signature, (int)signatureLength)) {
            return BZIP2;
        }
        if (GzipCompressorInputStream.matches((byte[])signature, (int)signatureLength)) {
            return GZIP;
        }
        if (Pack200CompressorInputStream.matches((byte[])signature, (int)signatureLength)) {
            return PACK200;
        }
        if (FramedSnappyCompressorInputStream.matches((byte[])signature, (int)signatureLength)) {
            return SNAPPY_FRAMED;
        }
        if (ZCompressorInputStream.matches((byte[])signature, (int)signatureLength)) {
            return Z;
        }
        if (DeflateCompressorInputStream.matches((byte[])signature, (int)signatureLength)) {
            return DEFLATE;
        }
        if (XZUtils.matches((byte[])signature, (int)signatureLength)) {
            return XZ;
        }
        if (LZMAUtils.matches((byte[])signature, (int)signatureLength)) {
            return LZMA;
        }
        throw new CompressorException("No Compressor found for the stream signature.");
    }

    public SortedMap<String, CompressorStreamProvider> getCompressorInputStreamProviders() {
        if (this.compressorInputStreamProviders == null) {
            this.compressorInputStreamProviders = Collections.unmodifiableSortedMap(TikaCompressorStreamFactory.findAvailableCompressorInputStreamProviders());
        }
        return this.compressorInputStreamProviders;
    }

    public static SortedMap<String, CompressorStreamProvider> findAvailableCompressorInputStreamProviders() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, CompressorStreamProvider>>(){

            @Override
            public SortedMap<String, CompressorStreamProvider> run() {
                TreeMap<String, CompressorStreamProvider> map = new TreeMap<String, CompressorStreamProvider>();
                TikaCompressorStreamFactory.putAll(SINGLETON.getInputStreamCompressorNames(), SINGLETON, map);
                for (CompressorStreamProvider provider : TikaCompressorStreamFactory.findCompressorStreamProviders()) {
                    TikaCompressorStreamFactory.putAll(provider.getInputStreamCompressorNames(), provider, map);
                }
                return map;
            }
        });
    }

    private static ArrayList<CompressorStreamProvider> findCompressorStreamProviders() {
        return Lists.newArrayList(TikaCompressorStreamFactory.serviceLoaderIterator());
    }

    private static Iterator<CompressorStreamProvider> serviceLoaderIterator() {
        return new ServiceLoaderIterator(CompressorStreamProvider.class);
    }

    public CompressorInputStream createCompressorInputStream(InputStream in) throws CompressorException, TikaMemoryLimitException {
        return this.createCompressorInputStream(TikaCompressorStreamFactory.detect(in), in);
    }

    public CompressorInputStream createCompressorInputStream(String name, InputStream in) throws CompressorException, TikaMemoryLimitException {
        return this.createCompressorInputStream(name, in, this.decompressConcatenated);
    }

    public CompressorInputStream createCompressorInputStream(String name, InputStream in, boolean actualDecompressConcatenated) throws CompressorException {
        if (name == null || in == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if (GZIP.equalsIgnoreCase(name)) {
                return new GzipCompressorInputStream(in, actualDecompressConcatenated);
            }
            if (BZIP2.equalsIgnoreCase(name)) {
                return new BZip2CompressorInputStream(in, actualDecompressConcatenated);
            }
            if (XZ.equalsIgnoreCase(name)) {
                if (!XZUtils.isXZCompressionAvailable()) {
                    throw new CompressorException("XZ compression is not available.");
                }
                return new XZCompressorInputStream(in, actualDecompressConcatenated);
            }
            if (LZMA.equalsIgnoreCase(name)) {
                if (!LZMAUtils.isLZMACompressionAvailable()) {
                    throw new CompressorException("LZMA compression is not available");
                }
                try {
                    return new SaferLZMACompressorInputStream(in);
                }
                catch (MemoryLimitException e) {
                    throw new CompressorException("MemoryLimitException: " + e.getMessage(), (Throwable)e);
                }
            }
            if (PACK200.equalsIgnoreCase(name)) {
                return new Pack200CompressorInputStream(in);
            }
            if (SNAPPY_RAW.equalsIgnoreCase(name)) {
                return new SnappyCompressorInputStream(in);
            }
            if (SNAPPY_FRAMED.equalsIgnoreCase(name)) {
                return new FramedSnappyCompressorInputStream(in);
            }
            if (Z.equalsIgnoreCase(name)) {
                try {
                    return new SaferZCompressorInputStream(in);
                }
                catch (TikaRuntimeMemoryLimitException e) {
                    throw new CompressorException("MemoryLimitException: " + e.getMessage(), (Throwable)e);
                }
            }
            if (DEFLATE.equalsIgnoreCase(name)) {
                return new DeflateCompressorInputStream(in);
            }
        }
        catch (IOException e) {
            throw new CompressorException("Could not create CompressorInputStream.", (Throwable)e);
        }
        CompressorStreamProvider compressorStreamProvider = (CompressorStreamProvider)this.getCompressorInputStreamProviders().get(TikaCompressorStreamFactory.toKey(name));
        if (compressorStreamProvider != null) {
            return compressorStreamProvider.createCompressorInputStream(name, in, actualDecompressConcatenated);
        }
        throw new CompressorException("Compressor: " + name + " not found.");
    }

    public CompressorOutputStream createCompressorOutputStream(String s, OutputStream outputStream) throws CompressorException {
        throw new UnsupportedOperationException();
    }

    boolean getDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    public Set<String> getInputStreamCompressorNames() {
        return Sets.newHashSet((Object[])new String[]{GZIP, BZIP2, XZ, LZMA, PACK200, DEFLATE, SNAPPY_RAW, SNAPPY_FRAMED, Z});
    }

    public Set<String> getOutputStreamCompressorNames() {
        throw new UnsupportedOperationException();
    }

    public Boolean getDecompressUntilEOF() {
        return this.decompressUntilEOF;
    }

    private class SaferLZMACompressorInputStream
    extends CompressorInputStream {
        private final InputStream in;

        public SaferLZMACompressorInputStream(InputStream inputStream) throws IOException {
            this.in = new LZMAInputStream(inputStream, TikaCompressorStreamFactory.this.memoryLimitInKb);
        }

        public int read() throws IOException {
            int ret = this.in.read();
            this.count(ret == -1 ? 0 : 1);
            return ret;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int ret = this.in.read(buf, off, len);
            this.count(ret);
            return ret;
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class TikaRuntimeMemoryLimitException
    extends RuntimeException {
        public TikaRuntimeMemoryLimitException(String msg) {
            super(msg);
        }
    }

    private class SaferZCompressorInputStream
    extends ZCompressorInputStream {
        public SaferZCompressorInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected void initializeTables(int maxCodeSize) {
            int maxTableSize = 1 << maxCodeSize;
            if (TikaCompressorStreamFactory.this.memoryLimitInKb > -1 && maxTableSize > TikaCompressorStreamFactory.this.memoryLimitInKb * 1024) {
                throw new TikaRuntimeMemoryLimitException("Calculated maxCodeSize (" + maxCodeSize + " bytes) is greater than the maximum allowable (" + TikaCompressorStreamFactory.this.memoryLimitInKb * 1024 + " bytes).\nIf the file is not corrupt, consider increasing the memoryLimitInKb parameter in the CompressorParser");
            }
            super.initializeTables(maxCodeSize);
        }
    }
}

