/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic;

import java.io.File;
import java.io.Serializable;
import java.net.URISyntaxException;

public class GeoParserConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nerModelPath = null;

    public GeoParserConfig() {
        try {
            if (GeoParserConfig.class.getResource("en-ner-location.bin") != null) {
                this.nerModelPath = new File(GeoParserConfig.class.getResource("en-ner-location.bin").toURI()).getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void setNERModelPath(String path) {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isDirectory() || !file.exists()) {
            return;
        }
        this.nerModelPath = path;
    }

    public String getNERPath() {
        return this.nerModelPath;
    }
}

