/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.Span;
import org.apache.commons.io.IOUtils;

public class NameEntityExtractor {
    private String nerModelPath = null;
    ArrayList<String> locationNameEntities = new ArrayList();
    String bestNameEntity = null;
    private HashMap<String, Integer> tf;

    public NameEntityExtractor(String nerModelpath) {
        this.nerModelPath = nerModelpath;
        this.tf = new HashMap();
    }

    public void getAllNameEntitiesfromInput(InputStream stream) throws InvalidFormatException, IOException {
        String[] tmp;
        FileInputStream modelIn = new FileInputStream(this.nerModelPath);
        TokenNameFinderModel model = new TokenNameFinderModel((InputStream)modelIn);
        NameFinderME nameFinder = new NameFinderME(model);
        String[] in = IOUtils.toString((InputStream)stream, (String)"UTF-8").split(" ");
        Span[] nameE = nameFinder.find(in);
        String spanNames = Arrays.toString(Span.spansToStrings((Span[])nameE, (String[])in));
        spanNames = spanNames.substring(1, spanNames.length() - 1);
        ((InputStream)modelIn).close();
        for (String name : tmp = spanNames.split(",")) {
            name = name.trim();
            this.locationNameEntities.add(name);
        }
    }

    public void getBestNameEntity() {
        if (this.locationNameEntities.size() == 0) {
            return;
        }
        for (int i = 0; i < this.locationNameEntities.size(); ++i) {
            if (this.tf.containsKey(this.locationNameEntities.get(i))) {
                this.tf.put(this.locationNameEntities.get(i), this.tf.get(this.locationNameEntities.get(i)) + 1);
                continue;
            }
            this.tf.put(this.locationNameEntities.get(i), 1);
        }
        int max = 0;
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.tf.entrySet());
        Collections.shuffle(list);
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.locationNameEntities.clear();
        for (Map.Entry entry : list) {
            this.locationNameEntities.add((String)entry.getKey());
            if ((Integer)entry.getValue() <= max) continue;
            max = (Integer)entry.getValue();
            this.bestNameEntity = (String)entry.getKey();
        }
    }
}

