/*
 * This file was automatically generated by Apache Tiles Autotag.
 */
package org.apache.tiles.velocity.template;

import java.io.IOException;
import java.io.Writer;

import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.autotag.core.runtime.AutotagRuntime;
import org.apache.tiles.request.Request;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

/**
 * <p>
 * <strong>Insert a template.</strong>
 * </p>
 * <p>
 * Insert a template with the possibility to pass parameters (called
 * attributes). A template can be seen as a procedure that can take parameters
 * or attributes. <code>&lt;tiles:insertTemplate&gt;</code> allows to define
 * these attributes and pass them to the inserted jsp page, called template.
 * Attributes are defined using nested tag
 * <code>&lt;tiles:putAttribute&gt;</code> or
 * <code>&lt;tiles:putListAttribute&gt;</code>.
 * </p>
 * <p>
 * You must specify <code>template</code> attribute, for inserting a template
 * </p>
 * 
 * <p>
 * <strong>Example : </strong>
 * </p>
 * 
 * <pre>
 * &lt;code&gt;
 *           &lt;tiles:insertTemplate template=&quot;/basic/myLayout.jsp&quot; flush=&quot;true&quot;&gt;
 *              &lt;tiles:putAttribute name=&quot;title&quot; value=&quot;My first page&quot; /&gt;
 *              &lt;tiles:putAttribute name=&quot;header&quot; value=&quot;/common/header.jsp&quot; /&gt;
 *              &lt;tiles:putAttribute name=&quot;footer&quot; value=&quot;/common/footer.jsp&quot; /&gt;
 *              &lt;tiles:putAttribute name=&quot;menu&quot; value=&quot;/basic/menu.jsp&quot; /&gt;
 *              &lt;tiles:putAttribute name=&quot;body&quot; value=&quot;/basic/helloBody.jsp&quot; /&gt;
 *           &lt;/tiles:insertTemplate&gt;
 *         &lt;/code&gt;
 * </pre>
 */
public class InsertTemplateDirective extends Directive {

    /**
     * The template model.
     */
    private org.apache.tiles.template.InsertTemplateModel model = new org.apache.tiles.template.InsertTemplateModel();

    /** {@inheritDoc} */
    @Override
    public String getName() {
        return "tiles_insertTemplate";
    }

    /** {@inheritDoc} */
    @Override
    public int getType() {
        return BLOCK;
    }

    /** {@inheritDoc} */
    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node)
            throws IOException {
        AutotagRuntime runtime = new org.apache.tiles.request.velocity.autotag.VelocityAutotagRuntime();
        if (runtime instanceof Directive) {
            ((Directive) runtime).render(context, writer, node);
        }
        Request request = runtime.createRequest();
        ModelBody modelBody = runtime.createModelBody();
        model.execute(
            (java.lang.String) runtime.getParameter("template", null),
            (java.lang.String) runtime.getParameter("templateType", null),
            (java.lang.String) runtime.getParameter("templateExpression", null),
            (java.lang.String) runtime.getParameter("role", null),
            (java.lang.String) runtime.getParameter("preparer", null),
            (java.lang.Boolean) runtime.getParameter("flush", false),
            request, modelBody
        );
        return true;
    }
}
