/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceLockSet;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.http.RequestUtil;

public class DirResourceSet
extends AbstractFileResourceSet
implements WebResourceLockSet {
    private static final Log log = LogFactory.getLog(DirResourceSet.class);
    private final Map<String, WebResourceLockSet.ResourceLock> resourceLocksByPath = new HashMap<String, WebResourceLockSet.ResourceLock>();
    private final Object resourceLocksByPathLock = new Object();

    public DirResourceSet() {
        super("/");
    }

    public DirResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) {
        super(internalPath);
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        if (root.getContext().getAddWebinfClassesResources()) {
            File f = new File(base, internalPath);
            if ((f = new File(f, "/WEB-INF/classes/META-INF/resources")).isDirectory()) {
                root.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", f.getAbsolutePath(), null, "/");
            }
        }
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResource getResource(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        boolean readOnly = this.isReadOnly();
        if (path.startsWith(webAppMount)) {
            WebResourceLockSet.ResourceLock lock = readOnly ? null : this.lockForRead(path);
            try {
                File f = this.file(path.substring(webAppMount.length()), false);
                if (f == null) {
                    EmptyResource emptyResource = new EmptyResource(root, path);
                    return emptyResource;
                }
                if (!f.exists()) {
                    EmptyResource emptyResource = new EmptyResource(root, path, f);
                    return emptyResource;
                }
                if (f.isDirectory() && path.charAt(path.length() - 1) != '/') {
                    path = path + '/';
                }
                FileResource fileResource = new FileResource(root, path, f, readOnly, this.getManifest(), this, readOnly ? null : lock.key);
                return fileResource;
            }
            finally {
                if (!readOnly) {
                    this.unlockForRead(lock);
                }
            }
        }
        return new EmptyResource(root, path);
    }

    @Override
    public String[] list(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        if (path.startsWith(webAppMount)) {
            File f = this.file(path.substring(webAppMount.length()), true);
            if (f == null) {
                return EMPTY_STRING_ARRAY;
            }
            String[] result = f.list();
            if (result == null) {
                return EMPTY_STRING_ARRAY;
            }
            return result;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (webAppMount.startsWith(path)) {
            int i = webAppMount.indexOf(47, path.length());
            if (i == -1) {
                return new String[]{webAppMount.substring(path.length())};
            }
            return new String[]{webAppMount.substring(path.length(), i)};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result = new ResourceSet<String>();
        if (path.startsWith(webAppMount)) {
            File[] list;
            File f = this.file(path.substring(webAppMount.length()), true);
            if (f != null && (list = f.listFiles()) != null) {
                String fCanPath = null;
                for (File entry : list) {
                    if (!this.getAllowLinking()) {
                        boolean symlink = true;
                        String absPath = null;
                        String canPath = null;
                        try {
                            absPath = entry.getAbsolutePath().substring(f.getAbsolutePath().length());
                            String entryCanPath = entry.getCanonicalPath();
                            if (fCanPath == null) {
                                fCanPath = f.getCanonicalPath();
                            }
                            if (entryCanPath.length() >= fCanPath.length() && absPath.equals(canPath = entryCanPath.substring(fCanPath.length()))) {
                                symlink = false;
                            }
                        }
                        catch (IOException ioe) {
                            canPath = "Unknown";
                        }
                        if (symlink) {
                            this.logIgnoredSymlink(this.getRoot().getContext().getName(), absPath, canPath);
                            continue;
                        }
                    }
                    StringBuilder sb = new StringBuilder(path);
                    if (path.charAt(path.length() - 1) != '/') {
                        sb.append('/');
                    }
                    sb.append(entry.getName());
                    if (entry.isDirectory()) {
                        sb.append('/');
                    }
                    result.add(sb.toString());
                }
            }
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    result.add(webAppMount + "/");
                } else {
                    result.add(webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path) {
        this.checkPath(path);
        if (this.isReadOnly()) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (path.startsWith(webAppMount)) {
            File f = this.file(path.substring(webAppMount.length()), false);
            if (f == null) {
                return false;
            }
            return f.mkdir();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(String path, InputStream is, boolean overwrite) {
        this.checkPath(path);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (path.endsWith("/")) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (!path.startsWith(webAppMount)) {
            return false;
        }
        WebResourceLockSet.ResourceLock lock = this.lockForWrite(path);
        try {
            File dest = this.file(path.substring(webAppMount.length()), false);
            if (dest == null) {
                boolean bl = false;
                return bl;
            }
            if (dest.exists() && !overwrite) {
                boolean bl = false;
                return bl;
            }
            try {
                if (overwrite) {
                    Files.copy(is, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(is, dest.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException ioe) {
                boolean bl = false;
                this.unlockForWrite(lock);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockForWrite(lock);
        }
    }

    @Override
    protected void checkType(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("dirResourceSet.notDirectory", new Object[]{this.getBase(), File.separator, this.getInternalPath()}));
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        File mf;
        super.initInternal();
        if (this.getWebAppMount().isEmpty() && (mf = this.file("META-INF/MANIFEST.MF", true)) != null && mf.isFile()) {
            try (FileInputStream fis = new FileInputStream(mf);){
                this.setManifest(new Manifest(fis));
            }
            catch (IOException e) {
                log.warn((Object)sm.getString("dirResourceSet.manifestFail", new Object[]{mf.getAbsolutePath()}), (Throwable)e);
            }
        }
        if (this.isReadOnly()) {
            return;
        }
        if (JreCompat.getInstance().isCanonCachesDisabled()) {
            return;
        }
        if (!JreCompat.getInstance().disableCanonCaches()) {
            throw new IllegalStateException(sm.getString("dirResourceSet.canonCaches.enabled", new Object[]{this.getFileBase(), this.getRoot().getContext().getName()}));
        }
        log.warn((Object)sm.getString("dirResourceSet.canonCaches.disabled", new Object[]{this.getFileBase(), this.getRoot().getContext().getName()}));
    }

    private String getLockKey(String path) {
        return RequestUtil.normalize((String)path).toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResourceLockSet.ResourceLock lockForRead(String path) {
        WebResourceLockSet.ResourceLock resourceLock;
        String key = this.getLockKey(path);
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            resourceLock = this.resourceLocksByPath.get(key);
            if (resourceLock == null) {
                resourceLock = new WebResourceLockSet.ResourceLock(key);
                this.resourceLocksByPath.put(key, resourceLock);
            }
            resourceLock.count.incrementAndGet();
        }
        resourceLock.reentrantLock.readLock().lock();
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForRead(WebResourceLockSet.ResourceLock resourceLock) {
        resourceLock.reentrantLock.readLock().unlock();
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            if (resourceLock.count.decrementAndGet() == 0) {
                this.resourceLocksByPath.remove(resourceLock.key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResourceLockSet.ResourceLock lockForWrite(String path) {
        WebResourceLockSet.ResourceLock resourceLock;
        String key = this.getLockKey(path);
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            resourceLock = this.resourceLocksByPath.get(key);
            if (resourceLock == null) {
                resourceLock = new WebResourceLockSet.ResourceLock(key);
                this.resourceLocksByPath.put(key, resourceLock);
            }
            resourceLock.count.incrementAndGet();
        }
        resourceLock.reentrantLock.writeLock().lock();
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForWrite(WebResourceLockSet.ResourceLock resourceLock) {
        resourceLock.reentrantLock.writeLock().unlock();
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            if (resourceLock.count.decrementAndGet() == 0) {
                this.resourceLocksByPath.remove(resourceLock.key);
            }
        }
    }
}

