/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.enterprise.event.NotificationOptions;

class ImmutableNotificationOptions
implements NotificationOptions {
    private final Executor executor;
    private final Map<String, Object> options;

    private ImmutableNotificationOptions(Executor executor, Map<String, Object> options) {
        this.executor = executor;
        this.options = options;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Object get(String optionKey) {
        return this.options.get(optionKey);
    }

    static class Builder
    implements NotificationOptions.Builder {
        private Executor executor;
        private Map<String, Object> options = new HashMap<String, Object>();

        Builder() {
        }

        @Override
        public NotificationOptions.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public NotificationOptions.Builder set(String optionKey, Object value) {
            this.options.put(optionKey, value);
            return this;
        }

        @Override
        public NotificationOptions build() {
            return new ImmutableNotificationOptions(this.executor, this.options);
        }
    }
}

