/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.beans;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.openejb.test.beans.Calculator;
import org.apache.openejb.test.beans.CalculatorHome;

public class ShoppingCartBean
implements SessionBean,
SessionSynchronization {
    String name;
    SessionContext context;
    Context jndiContext;
    Context envContext;
    Boolean useJdbc = Boolean.FALSE;

    public void ejbCreate(String name) throws CreateException {
        try {
            this.jndiContext = new InitialContext();
            String author = (String)this.jndiContext.lookup("java:comp/env/author");
            Double d = (Double)this.jndiContext.lookup("java:comp/env/price");
        }
        catch (NamingException re) {
            throw new RuntimeException("Using JNDI failed");
        }
    }

    public Calculator getCalculator() {
        try {
            boolean test = this.context.isCallerInRole("TheMan");
            this.jndiContext = new InitialContext();
            CalculatorHome home = (CalculatorHome)this.jndiContext.lookup("java:comp/env/ejb/calculator");
            Calculator calc = home.create();
            return calc;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Getting calulator bean failed");
        }
        catch (NamingException re) {
            throw new RuntimeException("Using JNDI failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJdbcCall() {
        Connection con = null;
        try {
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/jdbc/orders");
            con = ds.getConnection();
            try (Statement stmt = con.createStatement();){
                ResultSet rs = stmt.executeQuery("select * from Employees");
                while (rs.next()) {
                    System.out.println(rs.getString(2));
                }
                Calculator calc = this.getCalculator();
                calc.add(1, 1);
                calc.sub(1, 2);
                boolean bl = true;
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Accessing Calculator bean failed");
        }
        catch (NamingException ne) {
            throw new RuntimeException("Using JNDI failed");
        }
        catch (SQLException se) {
            throw new RuntimeException("Getting JDBC data source failed");
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSessionContext(SessionContext cntx) {
        this.context = cntx;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void afterBegin() {
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(boolean commit) {
    }

    private void testAllowedOperations(String methodName) {
        System.out.println("******************************************************");
        System.out.println("\nTesting Allowed Operations for " + methodName + "() method\n");
        try {
            this.context.getEJBObject();
            System.out.println("SessionContext.getEJBObject() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.getEJBObject() ... Failed");
        }
        try {
            this.context.getEJBHome();
            System.out.println("SessionContext.getEJBHome() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.getEJBHome() ... Failed");
        }
        try {
            this.context.getCallerPrincipal();
            System.out.println("SessionContext.getCallerPrincipal() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.getCallerPrincipal() ... Failed");
        }
        try {
            this.context.isCallerInRole("ROLE");
            System.out.println("SessionContext.isCallerInRole() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.isCallerInRole() ... Failed");
        }
        try {
            this.context.getRollbackOnly();
            System.out.println("SessionContext.getRollbackOnly() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.getRollbackOnly() ... Failed");
        }
        try {
            this.context.setRollbackOnly();
            System.out.println("SessionContext.setRollbackOnly() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.setRollbackOnly() ... Failed");
        }
        try {
            this.context.getUserTransaction();
            System.out.println("SessionContext.getUserTransaction() ... Allowed");
        }
        catch (IllegalStateException ise) {
            System.out.println("SessionContext.getUserTransaction() ... Failed");
        }
    }
}

