/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.test.mdb.MdbUtil;

public class MdbInvoker
implements MessageListener {
    private final Map<String, Method> signatures = new TreeMap<String, Method>();
    private final ConnectionFactory connectionFactory;
    private final Object target;
    private Connection connection;
    private Session session;
    private MessageProducer replyProducer = null;

    public MdbInvoker(ConnectionFactory connectionFactory, Object target) throws JMSException {
        this.connectionFactory = connectionFactory;
        this.target = target;
        for (Method method : target.getClass().getMethods()) {
            String signature = MdbUtil.getSignature(method);
            this.signatures.put(signature, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void destroy() {
        MdbUtil.close(this.replyProducer);
        MdbUtil.close(this.session);
        this.session = null;
        MdbUtil.close(this.connection);
        this.connection = null;
    }

    private synchronized Session getSession() throws JMSException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        boolean isBeanManagedTransaction = false;
        try {
            new InitialContext().lookup("java:comp/UserTransaction");
            isBeanManagedTransaction = true;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.session = isBeanManagedTransaction ? this.connection.createSession(false, 1) : this.connection.createSession(true, 0);
        this.replyProducer = this.session.createProducer(null);
        this.replyProducer.setDeliveryMode(1);
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            Object result;
            if (!(message instanceof ObjectMessage)) {
                return;
            }
            Session session = this.getSession();
            if (session == null) {
                throw new IllegalStateException("Invoker has been destroyed");
            }
            if (message == null) {
                throw new NullPointerException("request message is null");
            }
            if (!(message instanceof ObjectMessage)) {
                throw new IllegalArgumentException("Expected a ObjectMessage request but got a " + message.getClass().getName());
            }
            Serializable object = ((ObjectMessage)message).getObject();
            if (object == null) {
                throw new NullPointerException("object in ObjectMessage is null");
            }
            if (!(object instanceof Map) && message instanceof ObjectMessage) {
                throw new IllegalArgumentException("Expected a Map contained in the ObjectMessage request but got a " + object.getClass().getName());
            }
            Map request = (Map)((Object)object);
            String signature = (String)request.get("method");
            if (signature == null) {
                throw new NullPointerException("method property is null");
            }
            Method method = this.signatures.get(signature);
            if (method == null) {
                throw new IllegalArgumentException("no such method " + signature + "; known methods are " + this.signatures.keySet());
            }
            Object[] args = (Object[])request.get("args");
            boolean exception = false;
            try {
                result = method.invoke(this.target, args);
            }
            catch (IllegalAccessException e) {
                result = e;
                exception = true;
            }
            catch (InvocationTargetException e) {
                result = e.getCause();
                if (result == null) {
                    result = e;
                }
                exception = true;
            }
            catch (Exception e) {
                result = e.getCause();
                if (result == null) {
                    result = e;
                }
                exception = true;
            }
            try {
                TreeMap<String, Object> response = new TreeMap<String, Object>();
                if (exception) {
                    response.put("exception", "true");
                }
                response.put("return", result);
                ObjectMessage resMessage = session.createObjectMessage();
                resMessage.setJMSCorrelationID(message.getJMSCorrelationID());
                resMessage.setObject((Serializable)response);
                this.replyProducer.send(message.getJMSReplyTo(), (Message)resMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.destroy();
        }
    }
}

