/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.openejb.jee.sun;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
public class ParameterEncoding {
    @XmlAttribute(name = "form-hint-field")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String formHintField;
    @XmlAttribute(name = "default-charset")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String defaultCharset;

    public String getFormHintField() {
        return formHintField;
    }

    public void setFormHintField(final String value) {
        this.formHintField = value;
    }

    public String getDefaultCharset() {
        return defaultCharset;
    }

    public void setDefaultCharset(final String value) {
        this.defaultCharset = value;
    }
}
