/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

public class ConsumeOffsetInfo {
    private String partitionKey;
    private long currOffset = -2L;
    private long maxOffset = -2L;
    private long updateTime = -2L;

    public ConsumeOffsetInfo(String partitionKey, long currOffset, long maxOffset) {
        this.partitionKey = partitionKey;
        this.currOffset = currOffset;
        this.maxOffset = maxOffset;
        this.updateTime = System.currentTimeMillis();
    }

    public ConsumeOffsetInfo(String partitionKey, long currOffset, long maxOffset, long updateTime) {
        this.partitionKey = partitionKey;
        this.currOffset = currOffset;
        this.maxOffset = maxOffset;
        this.updateTime = updateTime;
    }

    public void updateOffsetInfo(long currOffset, long maxOffset) {
        boolean updated = false;
        if (currOffset >= 0L) {
            this.currOffset = currOffset;
            updated = true;
        }
        if (maxOffset >= 0L) {
            this.maxOffset = maxOffset;
            updated = true;
        }
        if (updated) {
            this.updateTime = System.currentTimeMillis();
        }
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public long getCurrOffset() {
        return this.currOffset;
    }

    public long getMaxOffset() {
        return this.maxOffset;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String toString() {
        return this.partitionKey + "#" + this.currOffset + ":" + this.maxOffset;
    }
}

