/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

public enum ConsumePosition {
    CONSUMER_FROM_MAX_OFFSET_ALWAYS(1, "Always start from the max consume position."),
    CONSUMER_FROM_LATEST_OFFSET(0, "Start from the latest position for the first time. Otherwise start from last consume position."),
    CONSUMER_FROM_FIRST_OFFSET(-1, "Start from 0 for the first time. Otherwise start from last consume position.");

    private int code;
    private String description;

    private ConsumePosition(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ConsumePosition valueOf(int code) {
        for (ConsumePosition consumePosition : ConsumePosition.values()) {
            if (consumePosition.getCode() != code) continue;
            return consumePosition;
        }
        throw new IllegalArgumentException(String.format("unknown ConsumePosition code %s", code));
    }
}

