/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.tubemq.client.common.PeerInfo;
import org.apache.tubemq.client.consumer.FetchContext;
import org.apache.tubemq.corebase.Message;
import org.apache.tubemq.corebase.cluster.Partition;

public class ConsumerResult {
    private boolean success = false;
    private int errCode = -2;
    private String errMsg = "";
    private String topicName = "";
    private PeerInfo peerInfo = new PeerInfo();
    private String confirmContext = "";
    private List<Message> messageList = new ArrayList<Message>();

    public ConsumerResult(int errCode, String errMsg) {
        this.success = false;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public ConsumerResult(FetchContext taskContext) {
        this.success = taskContext.isSuccess();
        this.errCode = taskContext.getErrCode();
        this.errMsg = taskContext.getErrMsg();
        this.topicName = taskContext.getPartition().getTopic();
        this.peerInfo.setMsgSourceInfo(taskContext.getPartition(), taskContext.getCurrOffset(), taskContext.getMaxOffset());
        if (this.success) {
            this.messageList = taskContext.getMessageList();
            this.confirmContext = taskContext.getConfirmContext();
        }
    }

    public ConsumerResult(boolean isSuccess, int errCode, String errMsg, String topicName, Partition partition, long currOffset, long maxOffset) {
        this.success = isSuccess;
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.topicName = topicName;
        this.peerInfo.setMsgSourceInfo(partition, currOffset, maxOffset);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public String getPartitionKey() {
        return this.peerInfo.getPartitionKey();
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public final String getConfirmContext() {
        return this.confirmContext;
    }

    public long getCurrOffset() {
        return this.peerInfo.getCurrOffset();
    }

    public final List<Message> getMessageList() {
        return this.messageList;
    }

    public long getMaxOffset() {
        return this.peerInfo.getMaxOffset();
    }
}

