/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

import org.apache.tubemq.corebase.utils.AbstractSamplePrint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerSamplePrint
extends AbstractSamplePrint {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerSamplePrint.class);

    public ConsumerSamplePrint() {
    }

    public ConsumerSamplePrint(long sampleDetailDur, long sampleResetDur, long maxDetailCount, long maxTotalCount) {
        super(sampleDetailDur, sampleResetDur, maxDetailCount, maxTotalCount);
    }

    public void printExceptionCaught(Throwable e) {
        if (e == null) {
            return;
        }
        if (e instanceof Exception) {
            long now = System.currentTimeMillis();
            long diffTime = now - this.lastLogTime.get();
            long curPrintCnt = this.totalPrintCount.incrementAndGet();
            if (curPrintCnt < this.maxTotalCount) {
                if (diffTime < this.sampleDetailDur && curPrintCnt < this.maxDetailCount) {
                    logger.error("[heartbeat failed] heartbeat to broker error 1: ", e);
                } else {
                    logger.error(this.sBuilder.append("[heartbeat failed] heartbeat to broker error 2 is ").append(e.toString()).toString());
                    this.sBuilder.delete(0, this.sBuilder.length());
                }
            }
            if (diffTime > this.sampleResetDur && this.lastLogTime.compareAndSet(now - diffTime, now)) {
                this.totalPrintCount.set(0L);
            }
        } else {
            logger.error("[heartbeat failed] heartbeat to broker error 3: ", e);
        }
    }

    public void printExceptionCaught(Throwable e, String hostName, String nodeName) {
    }
}

