/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.tubemq.client.consumer.PartitionSelectResult;
import org.apache.tubemq.corebase.Message;
import org.apache.tubemq.corebase.cluster.Partition;

public class FetchContext {
    private Partition partition;
    private long usedToken;
    private boolean lastConsumed = false;
    private boolean success = false;
    private int errCode = 0;
    private String errMsg = "";
    private long currOffset = -2L;
    private String confirmContext = "";
    private List<Message> messageList = new ArrayList<Message>();
    private long maxOffset = -2L;

    public FetchContext(PartitionSelectResult selectResult) {
        this.partition = selectResult.getPartition();
        this.usedToken = selectResult.getUsedToken();
        this.lastConsumed = selectResult.isLastPackConsumed();
    }

    public void setFailProcessResult(int errCode, String errMsg) {
        this.success = false;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public void setSuccessProcessResult(long currOffset, String confirmContext, List<Message> messageList, long maxOffset) {
        this.success = true;
        this.errCode = 200;
        this.errMsg = "Ok!";
        if (currOffset >= 0L) {
            this.currOffset = currOffset;
        }
        this.confirmContext = confirmContext;
        this.messageList = messageList;
        if (maxOffset >= 0L) {
            this.maxOffset = maxOffset;
        }
    }

    public Partition getPartition() {
        return this.partition;
    }

    public long getUsedToken() {
        return this.usedToken;
    }

    public boolean isLastConsumed() {
        return this.lastConsumed;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public List<Message> getMessageList() {
        return this.messageList;
    }

    public long getCurrOffset() {
        return this.currOffset;
    }

    public String getConfirmContext() {
        return this.confirmContext;
    }

    public long getMaxOffset() {
        return this.maxOffset;
    }
}

