/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

import org.apache.tubemq.corebase.cluster.BrokerInfo;
import org.apache.tubemq.corebase.cluster.Partition;
import org.apache.tubemq.corebase.policies.FlowCtrlItem;
import org.apache.tubemq.corebase.policies.FlowCtrlResult;
import org.apache.tubemq.corebase.policies.FlowCtrlRuleHandler;

public class PartitionExt
extends Partition {
    private static final long serialVersionUID = 7587342323917872253L;
    private final FlowCtrlRuleHandler groupFlowCtrlRuleHandler;
    private final FlowCtrlRuleHandler defFlowCtrlRuleHandler;
    private long nextLimitUpdateTime = 0L;
    private FlowCtrlResult curFlowCtrlVal;
    private long nextStatTime = 0L;
    private long lastGetTime = 0L;
    private int recvMsgSize = 0;
    private FlowCtrlItem filterCtrlItem = new FlowCtrlItem(3, -2, -2, -2);
    private long recvMsgInMin = 0L;
    private long limitMsgInSec = 0L;
    private long lastDataRdDlt = -2L;
    private int totalRcvZeroCount = 0;
    private long lastRptTIme;
    private int reqProcType;
    private int errCode;
    private boolean isEscLimit;
    private int msgSize;
    private long limitDlt;
    private long curDataDlt;
    private boolean isRequireSlow = false;
    private boolean isLastPackConsumed = false;

    public PartitionExt(FlowCtrlRuleHandler groupFlowCtrlRuleHandler, FlowCtrlRuleHandler defFlowCtrlRuleHandler, BrokerInfo broker, String topic, int partitionId) {
        super(broker, topic, partitionId);
        this.groupFlowCtrlRuleHandler = groupFlowCtrlRuleHandler;
        this.defFlowCtrlRuleHandler = defFlowCtrlRuleHandler;
    }

    public long procConsumeResult(boolean isFilterConsume) {
        long dltTime = System.currentTimeMillis() - this.lastRptTIme;
        return this.procConsumeResult(isFilterConsume, this.reqProcType, this.errCode, this.msgSize, this.isEscLimit, this.limitDlt, this.curDataDlt, this.isRequireSlow) - dltTime;
    }

    public long procConsumeResult(boolean isFilterConsume, int reqProcType, int errCode, int msgSize, boolean isReqEscLimit, long rsplimitDlt, long lastDataDlt, boolean isRRequireSlow) {
        if (lastDataDlt >= 0L) {
            this.lastDataRdDlt = lastDataDlt;
        }
        this.recvMsgSize += msgSize;
        this.recvMsgInMin += (long)msgSize;
        long currTime = System.currentTimeMillis();
        this.checkAndCalcDataLimit(currTime);
        if (errCode != 404 && errCode != 200) {
            return rsplimitDlt;
        }
        this.totalRcvZeroCount = msgSize == 0 && errCode != 200 ? ++this.totalRcvZeroCount : 0;
        if (this.totalRcvZeroCount > 0) {
            if (this.groupFlowCtrlRuleHandler.getMinZeroCnt() != Integer.MAX_VALUE) {
                return this.groupFlowCtrlRuleHandler.getCurFreqLimitTime(this.totalRcvZeroCount, (int)rsplimitDlt);
            }
            return this.defFlowCtrlRuleHandler.getCurFreqLimitTime(this.totalRcvZeroCount, (int)rsplimitDlt);
        }
        if (isReqEscLimit) {
            return 0L;
        }
        if (this.recvMsgInMin >= this.curFlowCtrlVal.dataLtInSize || (long)this.recvMsgSize >= this.limitMsgInSec) {
            return (long)this.curFlowCtrlVal.freqLtInMs > rsplimitDlt ? (long)this.curFlowCtrlVal.freqLtInMs : rsplimitDlt;
        }
        if (errCode == 200) {
            if (isFilterConsume && this.filterCtrlItem.getFreqLtInMs() >= 0) {
                if (isRRequireSlow) {
                    return this.filterCtrlItem.getZeroCnt();
                }
                return this.filterCtrlItem.getFreqLtInMs();
            }
            if (!isFilterConsume && this.filterCtrlItem.getDataLtInSZ() >= 0L) {
                return this.filterCtrlItem.getDataLtInSZ();
            }
        }
        return rsplimitDlt;
    }

    public long getCurDataDlt() {
        return this.curDataDlt;
    }

    public FlowCtrlResult getCurFlowCtrlVal() {
        return this.curFlowCtrlVal;
    }

    public long getRecvMsgInMin() {
        return this.recvMsgInMin;
    }

    public long getLimitMsgInSec() {
        return this.limitMsgInSec;
    }

    public long getLastRptTIme() {
        return this.lastRptTIme;
    }

    public int getReqProcType() {
        return this.reqProcType;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public boolean isEscLimit() {
        return this.isEscLimit;
    }

    public int getMsgSize() {
        return this.msgSize;
    }

    public long getLimitDlt() {
        return this.limitDlt;
    }

    public boolean isLastPackConsumed() {
        return this.isLastPackConsumed;
    }

    public void setLastPackConsumed(boolean lastPackConsumed) {
        this.isLastPackConsumed = lastPackConsumed;
    }

    public boolean getAndResetLastPackConsumed() {
        boolean curVal = this.isLastPackConsumed;
        this.isLastPackConsumed = false;
        return curVal;
    }

    public void setPullTempData(int reqProcType, int errCode, boolean isEscLimit, int msgSize, long limitDlt, long curDataDlt, boolean isRequireSlow) {
        this.lastRptTIme = System.currentTimeMillis();
        this.reqProcType = reqProcType;
        this.errCode = errCode;
        this.isEscLimit = isEscLimit;
        this.msgSize = msgSize;
        this.limitDlt = limitDlt;
        this.curDataDlt = curDataDlt;
        this.isRequireSlow = isRequireSlow;
    }

    public void clearPullTempData() {
        this.lastRptTIme = -1L;
        this.reqProcType = -1;
        this.errCode = -1;
        this.isEscLimit = false;
        this.msgSize = -1;
        this.limitDlt = -1L;
        this.curDataDlt = -1L;
    }

    public long getNextLimitUpdateTime() {
        return this.nextLimitUpdateTime;
    }

    public void setNextLimitUpdateTime(long nextLimitUpdateTime) {
        this.nextLimitUpdateTime = nextLimitUpdateTime;
    }

    public long getCurAllowedMsgSize() {
        return this.curFlowCtrlVal.dataLtInSize;
    }

    public void setCurAllowedMsgSize(int curAllowedMsgSize) {
        this.curFlowCtrlVal.setDataLtInSize((long)curAllowedMsgSize);
    }

    public long getNextStatTime() {
        return this.nextStatTime;
    }

    public void setNextStatTime(long nextStatTime) {
        this.nextStatTime = nextStatTime;
    }

    public long getLastGetTime() {
        return this.lastGetTime;
    }

    public void setLastGetTime(long lastGetTime) {
        this.lastGetTime = lastGetTime;
    }

    public int getRecvMsgSize() {
        return this.recvMsgSize;
    }

    public void setRecvMsgSize(int recvMsgSize) {
        this.recvMsgSize = recvMsgSize;
    }

    public long getLastDataRdDlt() {
        return this.lastDataRdDlt;
    }

    public void setLastDataRdDlt(long lastDataRdDlt) {
        this.lastDataRdDlt = lastDataRdDlt;
    }

    public int getTotalRcvZeroCount() {
        return this.totalRcvZeroCount;
    }

    public void setTotalRcvZeroCount(int totalRcvZeroCount) {
        this.totalRcvZeroCount = totalRcvZeroCount;
    }

    private void checkAndCalcDataLimit(long currTime) {
        if (currTime > this.nextLimitUpdateTime) {
            this.recvMsgSize = 0;
            this.recvMsgInMin = 0L;
            if (this.lastDataRdDlt < 0L) {
                this.curFlowCtrlVal = new FlowCtrlResult(Integer.MAX_VALUE, 20);
            } else {
                this.curFlowCtrlVal = this.groupFlowCtrlRuleHandler.getCurDataLimit(this.lastDataRdDlt);
                this.filterCtrlItem = this.groupFlowCtrlRuleHandler.getFilterCtrlItem();
                if (this.curFlowCtrlVal == null) {
                    this.curFlowCtrlVal = this.defFlowCtrlRuleHandler.getCurDataLimit(this.lastDataRdDlt);
                    if (this.curFlowCtrlVal == null) {
                        this.curFlowCtrlVal = new FlowCtrlResult(Long.MAX_VALUE, 0);
                    }
                }
                if (this.filterCtrlItem.getFreqLtInMs() < 0) {
                    this.filterCtrlItem = this.defFlowCtrlRuleHandler.getFilterCtrlItem();
                }
                currTime = System.currentTimeMillis();
            }
            this.limitMsgInSec = this.curFlowCtrlVal.dataLtInSize / 12L;
            this.nextLimitUpdateTime = currTime + 60000L;
            this.nextStatTime = currTime + 5000L;
        } else if (currTime > this.nextStatTime) {
            this.recvMsgSize = 0;
            this.nextStatTime = currTime + 5000L;
        }
    }
}

