/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.consumer;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.tubemq.client.config.ConsumerConfig;
import org.apache.tubemq.client.consumer.BaseMessageConsumer;
import org.apache.tubemq.client.consumer.ConsumeOffsetInfo;
import org.apache.tubemq.client.consumer.ConsumerResult;
import org.apache.tubemq.client.consumer.FetchContext;
import org.apache.tubemq.client.consumer.PartitionSelectResult;
import org.apache.tubemq.client.consumer.PullMessageConsumer;
import org.apache.tubemq.client.exception.TubeClientException;
import org.apache.tubemq.client.factory.InnerSessionFactory;
import org.apache.tubemq.corebase.cluster.Partition;
import org.apache.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.tubemq.corebase.utils.AddressUtils;
import org.apache.tubemq.corebase.utils.TStringUtils;
import org.apache.tubemq.corebase.utils.ThreadUtils;

public class SimplePullMessageConsumer
implements PullMessageConsumer {
    private final BaseMessageConsumer baseConsumer;

    public SimplePullMessageConsumer(InnerSessionFactory messageSessionFactory, ConsumerConfig consumerConfig) throws TubeClientException {
        this.baseConsumer = new BaseMessageConsumer(messageSessionFactory, consumerConfig, true);
    }

    @Override
    public boolean isPartitionsReady(long maxWaitTime) {
        return this.baseConsumer.rmtDataCache.isPartitionsReady(maxWaitTime);
    }

    public void shutdown() throws Throwable {
        this.baseConsumer.shutdown();
    }

    @Override
    public String getClientVersion() {
        return this.baseConsumer.getClientVersion();
    }

    @Override
    public String getConsumerId() {
        return this.baseConsumer.getConsumerId();
    }

    @Override
    public boolean isShutdown() {
        return this.baseConsumer.isShutdown();
    }

    @Override
    public ConsumerConfig getConsumerConfig() {
        return this.baseConsumer.getConsumerConfig();
    }

    @Override
    public boolean isFilterConsume(String topic) {
        return this.baseConsumer.isFilterConsume(topic);
    }

    @Override
    public Map<String, ConsumeOffsetInfo> getCurConsumedPartitions() throws TubeClientException {
        return this.baseConsumer.getCurConsumedPartitions();
    }

    @Override
    public void freezePartitions(List<String> partitionKeys) throws TubeClientException {
        this.baseConsumer.freezePartitions(partitionKeys);
    }

    @Override
    public void unfreezePartitions(List<String> partitionKeys) throws TubeClientException {
        this.baseConsumer.unfreezePartitions(partitionKeys);
    }

    @Override
    public void relAllFrozenPartitions() {
        this.baseConsumer.relAllFrozenPartitions();
    }

    @Override
    public Map<String, Long> getFrozenPartInfo() {
        return this.baseConsumer.getFrozenPartInfo();
    }

    @Override
    public PullMessageConsumer subscribe(String topic, TreeSet<String> filterConds) throws TubeClientException {
        this.baseConsumer.subscribe(topic, filterConds, null);
        return this;
    }

    @Override
    public void completeSubscribe() throws TubeClientException {
        this.baseConsumer.completeSubscribe();
    }

    @Override
    public void completeSubscribe(String sessionKey, int sourceCount, boolean isSelectBig, Map<String, Long> partOffsetMap) throws TubeClientException {
        this.baseConsumer.completeSubscribe(sessionKey, sourceCount, isSelectBig, partOffsetMap);
    }

    @Override
    public ConsumerResult getMessage() throws TubeClientException {
        this.baseConsumer.checkClientRunning();
        if (!this.baseConsumer.isSubscribed()) {
            throw new TubeClientException("Please complete topic's Subscribe call first!");
        }
        PartitionSelectResult selectResult = null;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.baseConsumer.isShutdown()) {
                return new ConsumerResult(400, "Client instance has been shutdown!");
            }
            selectResult = this.baseConsumer.rmtDataCache.getCurrPartsStatus();
            if (selectResult.isSuccess()) break;
            if (this.baseConsumer.getConsumerConfig().getPullConsumeReadyWaitPeriodMs() >= 0L && System.currentTimeMillis() - startTime >= this.baseConsumer.getConsumerConfig().getPullConsumeReadyWaitPeriodMs()) {
                return new ConsumerResult(selectResult.getErrCode(), selectResult.getErrMsg());
            }
            ThreadUtils.sleep((long)this.baseConsumer.getConsumerConfig().getPullConsumeReadyChkSliceMs());
        }
        StringBuilder sBuilder = new StringBuilder(512);
        selectResult = this.baseConsumer.rmtDataCache.pullSelect();
        if (!selectResult.isSuccess()) {
            return new ConsumerResult(selectResult.getErrCode(), selectResult.getErrMsg());
        }
        FetchContext taskContext = this.baseConsumer.fetchMessage(selectResult, sBuilder);
        return new ConsumerResult(taskContext);
    }

    @Override
    public ConsumerResult confirmConsume(String confirmContext, boolean isConsumed) throws TubeClientException {
        this.baseConsumer.checkClientRunning();
        if (!this.baseConsumer.isSubscribed()) {
            throw new TubeClientException("Please complete topic's Subscribe call first!");
        }
        StringBuilder sBuilder = new StringBuilder(512);
        long currOffset = -2L;
        long maxOffset = -2L;
        if (TStringUtils.isBlank((String)confirmContext)) {
            throw new TubeClientException("ConfirmContext is null !");
        }
        String[] strConfirmContextItems = confirmContext.split(":");
        if (strConfirmContextItems.length != 4) {
            throw new TubeClientException("ConfirmContext format error: value must be aaaa:bbbb:cccc:ddddd !");
        }
        for (String itemStr : strConfirmContextItems) {
            if (!TStringUtils.isBlank((String)itemStr)) continue;
            throw new TubeClientException(sBuilder.append("ConfirmContext's format error: item (").append(itemStr).append(") is null !").toString());
        }
        String keyId = sBuilder.append(strConfirmContextItems[0].trim()).append(":").append(strConfirmContextItems[1].trim()).append(":").append(strConfirmContextItems[2].trim()).toString();
        sBuilder.delete(0, sBuilder.length());
        String topicName = strConfirmContextItems[1].trim();
        long timeStamp = Long.parseLong(strConfirmContextItems[3]);
        if (!this.baseConsumer.rmtDataCache.isPartitionInUse(keyId, timeStamp)) {
            return new ConsumerResult(400, "The confirmContext's value invalid!");
        }
        Partition curPartition = this.baseConsumer.rmtDataCache.getPartitionByKey(keyId);
        if (curPartition == null) {
            return new ConsumerResult(404, sBuilder.append("Not found the partition by confirmContext:").append(confirmContext).toString());
        }
        if (this.baseConsumer.consumerConfig.isPullConfirmInLocal()) {
            this.baseConsumer.rmtDataCache.succRspRelease(keyId, topicName, timeStamp, isConsumed, this.isFilterConsume(topicName), currOffset, maxOffset);
            return new ConsumerResult(true, 200, "OK!", topicName, curPartition, currOffset, maxOffset);
        }
        try {
            ClientBroker.CommitOffsetResponseB2C commitResponse = this.baseConsumer.getBrokerService(curPartition.getBroker()).consumerCommitC2B(this.baseConsumer.createBrokerCommitRequest(curPartition, isConsumed), AddressUtils.getLocalAddress(), this.getConsumerConfig().isTlsEnable());
            if (commitResponse == null) {
                ConsumerResult consumerResult = new ConsumerResult(400, sBuilder.append("Confirm ").append(confirmContext).append("'s offset failed!").toString());
                return consumerResult;
            }
            if (commitResponse.hasCurrOffset() && commitResponse.getCurrOffset() >= 0L) {
                currOffset = commitResponse.getCurrOffset();
            }
            if (commitResponse.hasMaxOffset() && commitResponse.getMaxOffset() >= 0L) {
                maxOffset = commitResponse.getMaxOffset();
            }
            ConsumerResult consumerResult = new ConsumerResult(commitResponse.getSuccess(), commitResponse.getErrCode(), commitResponse.getErrMsg(), topicName, curPartition, currOffset, maxOffset);
            return consumerResult;
        }
        catch (Throwable e) {
            sBuilder.delete(0, sBuilder.length());
            throw new TubeClientException(sBuilder.append("Confirm ").append(confirmContext).append("'s offset failed.").toString(), e);
        }
        finally {
            this.baseConsumer.rmtDataCache.succRspRelease(keyId, topicName, timeStamp, isConsumed, this.isFilterConsume(topicName), currOffset, maxOffset);
        }
    }
}

