/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.factory;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tubemq.client.config.ConsumerConfig;
import org.apache.tubemq.client.config.TubeClientConfig;
import org.apache.tubemq.client.consumer.PullMessageConsumer;
import org.apache.tubemq.client.consumer.PushMessageConsumer;
import org.apache.tubemq.client.consumer.SimplePullMessageConsumer;
import org.apache.tubemq.client.consumer.SimplePushMessageConsumer;
import org.apache.tubemq.client.exception.TubeClientException;
import org.apache.tubemq.client.factory.InnerSessionFactory;
import org.apache.tubemq.client.producer.MessageProducer;
import org.apache.tubemq.client.producer.ProducerManager;
import org.apache.tubemq.client.producer.SimpleMessageProducer;
import org.apache.tubemq.client.producer.qltystats.DefaultBrokerRcvQltyStats;
import org.apache.tubemq.corebase.Shutdownable;
import org.apache.tubemq.corebase.cluster.MasterInfo;
import org.apache.tubemq.corerpc.RpcConfig;
import org.apache.tubemq.corerpc.RpcServiceFactory;
import org.apache.tubemq.corerpc.client.ClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeBaseSessionFactory
implements InnerSessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(TubeBaseSessionFactory.class);
    private final RpcServiceFactory rpcServiceFactory;
    private final ProducerManager producerManager;
    private final TubeClientConfig tubeClientConfig;
    private final CopyOnWriteArrayList<Shutdownable> clientLst = new CopyOnWriteArrayList();
    private final DefaultBrokerRcvQltyStats brokerRcvQltyStats;
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public TubeBaseSessionFactory(ClientFactory clientFactory, TubeClientConfig tubeClientConfig) throws TubeClientException {
        this.checkConfig(tubeClientConfig);
        this.tubeClientConfig = tubeClientConfig;
        RpcConfig config = new RpcConfig();
        config.put("rpc.link.quality.stats.duration", (Object)tubeClientConfig.getLinkStatsDurationMs());
        config.put("rpc.link.quality.forbidden.duration", (Object)tubeClientConfig.getLinkStatsForbiddenDurationMs());
        config.put("rpc.link.quality.max.allowed.fail.count", (Object)tubeClientConfig.getLinkStatsMaxAllowedFailTimes());
        config.put("rpc.link.quality.max.fail.forbidden.rate", (Object)tubeClientConfig.getLinkStatsMaxForbiddenRate());
        config.put("rpc.unavailable.service.forbidden.duration", (Object)tubeClientConfig.getUnAvailableFbdDurationMs());
        this.rpcServiceFactory = new RpcServiceFactory(clientFactory, config);
        this.producerManager = new ProducerManager(this, this.tubeClientConfig);
        this.brokerRcvQltyStats = new DefaultBrokerRcvQltyStats(this.getRpcServiceFactory(), this.tubeClientConfig);
        logger.info(new StringBuilder(512).append("Created Session Factory, the config is: ").append(tubeClientConfig.toJsonString()).toString());
    }

    public TubeClientConfig getTubeClientConfig() {
        return this.tubeClientConfig;
    }

    public CopyOnWriteArrayList<Shutdownable> getCurrClients() {
        return this.clientLst;
    }

    private void checkConfig(TubeClientConfig tubeClientConfig) throws TubeClientException {
        if (tubeClientConfig == null) {
            throw new TubeClientException("null configuration");
        }
        MasterInfo masterInfo = tubeClientConfig.getMasterInfo();
        if (masterInfo == null || masterInfo.getAddrMap4Failover().isEmpty()) {
            throw new TubeClientException("Blank MasterInfo content in ClientConfig");
        }
    }

    @Override
    public DefaultBrokerRcvQltyStats getBrokerRcvQltyStats() {
        return this.brokerRcvQltyStats;
    }

    @Override
    public void shutdown() throws TubeClientException {
        logger.info("[SHUTDOWN_TUBE] Shutting down tube factory...");
        if (this.shutdown.get()) {
            return;
        }
        if (this.shutdown.compareAndSet(false, true)) {
            for (Shutdownable client : this.clientLst) {
                try {
                    client.shutdown();
                }
                catch (Throwable e) {
                    logger.error("[SHUTDOWN_TUBE] child shutdown failed", e);
                }
            }
            try {
                this.producerManager.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.brokerRcvQltyStats.stopBrokerStatistic();
            try {
                this.rpcServiceFactory.destroy();
            }
            catch (Exception e2) {
                logger.error("Fail to destroy RpcServiceFactory!", (Throwable)e2);
            }
        }
    }

    @Override
    public MessageProducer createProducer() throws TubeClientException {
        this.brokerRcvQltyStats.startBrokerStatistic();
        try {
            this.producerManager.start();
        }
        catch (Throwable e) {
            if (e instanceof TubeClientException) {
                throw (TubeClientException)e;
            }
            throw new TubeClientException("Create Producer failure, ", e);
        }
        return this.addClient(new SimpleMessageProducer(this, this.tubeClientConfig));
    }

    @Override
    public RpcServiceFactory getRpcServiceFactory() {
        return this.rpcServiceFactory;
    }

    @Override
    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    @Override
    public <T extends Shutdownable> void removeClient(T client) {
        this.clientLst.remove(client);
    }

    @Override
    public PullMessageConsumer createPullConsumer(ConsumerConfig consumerConfig) throws TubeClientException {
        if (!this.tubeClientConfig.getMasterInfo().equals((Object)consumerConfig.getMasterInfo())) {
            throw new TubeClientException(new StringBuilder(512).append("consumerConfig's masterInfo not equal!").append(" SessionFactory's masterInfo is ").append(this.tubeClientConfig.getMasterInfo()).append(", consumerConfig's masterInfo is ").append(consumerConfig.getMasterInfo()).toString());
        }
        return this.addClient(new SimplePullMessageConsumer(this, consumerConfig));
    }

    @Override
    public PushMessageConsumer createPushConsumer(ConsumerConfig consumerConfig) throws TubeClientException {
        if (!this.tubeClientConfig.getMasterInfo().equals((Object)consumerConfig.getMasterInfo())) {
            throw new TubeClientException(new StringBuilder(512).append("consumerConfig's masterInfo not equal!").append(" SessionFactory's masterInfo is ").append(this.tubeClientConfig.getMasterInfo()).append(", consumerConfig's masterInfo is ").append(consumerConfig.getMasterInfo()).toString());
        }
        return this.addClient(new SimplePushMessageConsumer(this, consumerConfig));
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    private <T extends Shutdownable> T addClient(T client) {
        this.clientLst.add(client);
        return client;
    }
}

