/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.factory;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tubemq.client.config.ConsumerConfig;
import org.apache.tubemq.client.config.TubeClientConfig;
import org.apache.tubemq.client.config.TubeClientConfigUtils;
import org.apache.tubemq.client.consumer.PullMessageConsumer;
import org.apache.tubemq.client.consumer.PushMessageConsumer;
import org.apache.tubemq.client.exception.TubeClientException;
import org.apache.tubemq.client.factory.MessageSessionFactory;
import org.apache.tubemq.client.factory.TubeBaseSessionFactory;
import org.apache.tubemq.client.producer.MessageProducer;
import org.apache.tubemq.corebase.Shutdownable;
import org.apache.tubemq.corerpc.RpcConfig;
import org.apache.tubemq.corerpc.client.ClientFactory;
import org.apache.tubemq.corerpc.netty.NettyClientFactory;

public class TubeMultiSessionFactory
implements MessageSessionFactory {
    private final NettyClientFactory clientFactory = new NettyClientFactory();
    private final TubeBaseSessionFactory baseSessionFactory;
    private final AtomicBoolean isShutDown = new AtomicBoolean(true);

    public TubeMultiSessionFactory(TubeClientConfig tubeClientConfig) throws TubeClientException {
        RpcConfig config = TubeClientConfigUtils.getRpcConfigByClientConfig(tubeClientConfig, false);
        this.clientFactory.configure(config);
        this.baseSessionFactory = new TubeBaseSessionFactory((ClientFactory)this.clientFactory, tubeClientConfig);
        this.isShutDown.set(false);
    }

    @Override
    public void shutdown() throws TubeClientException {
        if (this.isShutDown.compareAndSet(false, true)) {
            this.baseSessionFactory.shutdown();
            this.clientFactory.shutdown();
        }
    }

    @Override
    public <T extends Shutdownable> void removeClient(T client) {
        if (this.baseSessionFactory == null) {
            return;
        }
        this.baseSessionFactory.removeClient(client);
    }

    @Override
    public MessageProducer createProducer() throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Please initialize the object first!");
        }
        return this.baseSessionFactory.createProducer();
    }

    @Override
    public PushMessageConsumer createPushConsumer(ConsumerConfig consumerConfig) throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Please initialize the object first!");
        }
        return this.baseSessionFactory.createPushConsumer(consumerConfig);
    }

    @Override
    public PullMessageConsumer createPullConsumer(ConsumerConfig consumerConfig) throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Please initialize the object first!");
        }
        return this.baseSessionFactory.createPullConsumer(consumerConfig);
    }
}

