/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tubemq.client.producer;

import java.lang.management.ManagementFactory;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tubemq.client.config.TubeClientConfig;
import org.apache.tubemq.client.exception.TubeClientException;
import org.apache.tubemq.client.factory.InnerSessionFactory;
import org.apache.tubemq.corebase.aaaclient.ClientAuthenticateHandler;
import org.apache.tubemq.corebase.aaaclient.SimpleClientAuthenticateHandler;
import org.apache.tubemq.corebase.cluster.BrokerInfo;
import org.apache.tubemq.corebase.cluster.Partition;
import org.apache.tubemq.corebase.cluster.TopicInfo;
import org.apache.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.tubemq.corebase.utils.AddressUtils;
import org.apache.tubemq.corebase.utils.DataConverterUtil;
import org.apache.tubemq.corebase.utils.MixedUtils;
import org.apache.tubemq.corebase.utils.TStringUtils;
import org.apache.tubemq.corebase.utils.ThreadUtils;
import org.apache.tubemq.corerpc.RpcConfig;
import org.apache.tubemq.corerpc.RpcServiceFactory;
import org.apache.tubemq.corerpc.exception.ClientClosedException;
import org.apache.tubemq.corerpc.exception.LocalConnException;
import org.apache.tubemq.corerpc.service.MasterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerManager {
    private static final Logger logger = LoggerFactory.getLogger(ProducerManager.class);
    private static final int BROKER_UPDATED_TIME_AFTER_RETRY_FAIL = 0x6DDD00;
    private static final AtomicInteger producerCounter = new AtomicInteger(0);
    private final String producerId;
    private final int producerAddrId;
    private final TubeClientConfig tubeClientConfig;
    private final InnerSessionFactory sessionFactory;
    private final RpcServiceFactory rpcServiceFactory;
    private final ConcurrentHashMap<String, AtomicInteger> publishTopics = new ConcurrentHashMap();
    private final RpcConfig rpcConfig = new RpcConfig();
    private final ScheduledExecutorService heartbeatService;
    private final AtomicLong visitToken = new AtomicLong(-2L);
    private final AtomicReference<String> authAuthorizedTokenRef = new AtomicReference<String>("");
    private final ClientAuthenticateHandler authenticateHandler = new SimpleClientAuthenticateHandler();
    private MasterService masterService;
    private Map<Integer, BrokerInfo> brokersMap = new ConcurrentHashMap<Integer, BrokerInfo>();
    private long brokerInfoCheckSum = -1L;
    private long lastBrokerUpdatedTime = System.currentTimeMillis();
    private long lastEmptyBrokerPrintTime = 0L;
    private long lastEmptyTopicPrintTime = 0L;
    private int heartbeatRetryTimes = 0;
    private AtomicBoolean isStartHeart = new AtomicBoolean(false);
    private AtomicInteger heartBeatStatus = new AtomicInteger(-1);
    private volatile long lastHeartbeatTime = System.currentTimeMillis();
    private AtomicInteger nodeStatus = new AtomicInteger(-1);
    private Map<String, Map<Integer, List<Partition>>> topicPartitionMap = new ConcurrentHashMap<String, Map<Integer, List<Partition>>>();
    private AtomicBoolean nextWithAuthInfo2M = new AtomicBoolean(false);

    public ProducerManager(InnerSessionFactory sessionFactory, TubeClientConfig tubeClientConfig) throws TubeClientException {
        Security.setProperty("networkaddress.cache.ttl", "3");
        Security.setProperty("networkaddress.cache.negative.ttl", "1");
        if (sessionFactory == null || tubeClientConfig == null) {
            throw new TubeClientException("Illegal parameter: messageSessionFactory or tubeClientConfig is null!");
        }
        this.tubeClientConfig = tubeClientConfig;
        this.sessionFactory = sessionFactory;
        try {
            this.producerId = this.generateProducerID();
            this.producerAddrId = AddressUtils.ipToInt((String)AddressUtils.getLocalAddress());
        }
        catch (Exception e) {
            throw new TubeClientException("Generate producer id failed!", e);
        }
        this.rpcServiceFactory = this.sessionFactory.getRpcServiceFactory();
        this.rpcConfig.put("rpc.connect.timeout", (Object)3000);
        this.rpcConfig.put("rpc.request.timeout", (Object)tubeClientConfig.getRpcTimeoutMs());
        this.rpcConfig.put("rpc.netty.write.highmark", (Object)tubeClientConfig.getNettyWriteBufferHighWaterMark());
        this.rpcConfig.put("rpc.netty.write.lowmark", (Object)tubeClientConfig.getNettyWriteBufferLowWaterMark());
        this.rpcConfig.put("rpc.netty.worker.count", (Object)tubeClientConfig.getRpcConnProcessorCnt());
        this.rpcConfig.put("rpc.netty.worker.thread.name", (Object)"tube_netty_worker-");
        this.rpcConfig.put("rpc.netty.callback.count", (Object)tubeClientConfig.getRpcRspCallBackThreadCnt());
        this.heartBeatStatus.set(0);
        this.masterService = (MasterService)this.rpcServiceFactory.getFailoverService(MasterService.class, tubeClientConfig.getMasterInfo(), this.rpcConfig);
        this.heartbeatService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, new StringBuilder(256).append("Producer-Heartbeat-Thread-").append(ProducerManager.this.producerId).toString());
                t.setPriority(10);
                return t;
            }
        });
    }

    public String getClientVersion() {
        return "0.6.0-incubating";
    }

    public void start() throws Throwable {
        if (this.nodeStatus.get() <= 0 && this.nodeStatus.compareAndSet(-1, 0)) {
            this.register2Master();
            logger.info("[Producer] Producer status from ready to running!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topic) throws TubeClientException {
        this.checkServiceStatus();
        StringBuilder sBuilder = new StringBuilder(512);
        try {
            AtomicInteger tmpPubCnt;
            logger.info(sBuilder.append("[Publish begin 1] publish topic ").append(topic).append(", address = ").append(this.toString()).toString());
            sBuilder.delete(0, sBuilder.length());
            AtomicInteger curPubCnt = this.publishTopics.get(topic);
            if (curPubCnt == null && (curPubCnt = this.publishTopics.putIfAbsent(topic, tmpPubCnt = new AtomicInteger(0))) == null) {
                curPubCnt = tmpPubCnt;
            }
            if (curPubCnt.incrementAndGet() == 1) {
                long curTime = System.currentTimeMillis();
                new ProducerHeartbeatTask().run();
                logger.info(sBuilder.append("[Publish begin 1] already get meta info, topic: ").append(topic).append(", waste time ").append(System.currentTimeMillis() - curTime).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
            }
            if (this.topicPartitionMap.get(topic) == null) {
                throw new TubeClientException(sBuilder.append("Publish topic failure, make sure the topic ").append(topic).append(" exist or acceptPublish and try later!").toString());
            }
        }
        finally {
            if (this.isStartHeart.compareAndSet(false, true)) {
                this.heartbeatService.scheduleWithFixedDelay(new ProducerHeartbeatTask(), 5L, this.tubeClientConfig.getHeartbeatPeriodMs(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> publish(Set<String> topicSet) throws TubeClientException {
        this.checkServiceStatus();
        StringBuilder sBuilder = new StringBuilder(512);
        HashSet<String> failTopicSet = new HashSet<String>();
        HashSet<String> successTopicSet = new HashSet<String>();
        try {
            logger.info(sBuilder.append("[Publish begin 2] publish topicSet ").append(topicSet).append(", address = ").append(this.toString()).toString());
            sBuilder.delete(0, sBuilder.length());
            boolean hasNewTopic = false;
            for (String topicItem : topicSet) {
                AtomicInteger tmpPubCnt;
                AtomicInteger curPubCnt = this.publishTopics.get(topicItem);
                if (curPubCnt == null && (curPubCnt = this.publishTopics.putIfAbsent(topicItem, tmpPubCnt = new AtomicInteger(0))) == null) {
                    curPubCnt = tmpPubCnt;
                }
                if (curPubCnt.incrementAndGet() != 1) continue;
                hasNewTopic = true;
            }
            if (hasNewTopic) {
                long curTime = System.currentTimeMillis();
                new ProducerHeartbeatTask().run();
                logger.info(sBuilder.append("[Publish begin 2] already get meta info, topicSet: ").append(topicSet).append(", waste time ").append(System.currentTimeMillis() - curTime).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
            }
            for (String topicItem : topicSet) {
                if (this.topicPartitionMap.containsKey(topicItem)) {
                    successTopicSet.add(topicItem);
                    continue;
                }
                failTopicSet.add(topicItem);
            }
            if (!failTopicSet.isEmpty()) {
                logger.info(sBuilder.append("Publish topic failure, make sure the topics ").append(failTopicSet).append(" exist or acceptPublish and try later!").toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
        finally {
            if (this.isStartHeart.compareAndSet(false, true)) {
                this.heartbeatService.scheduleWithFixedDelay(new ProducerHeartbeatTask(), 5L, this.tubeClientConfig.getHeartbeatPeriodMs(), TimeUnit.MILLISECONDS);
            }
        }
        return successTopicSet;
    }

    public void shutdown() throws Throwable {
        logger.info("[ShutDown Producer] Shutting down heartbeat...");
        if (this.nodeStatus.get() != 0) {
            if (this.isShutdown()) {
                logger.info(new StringBuilder(512).append("[ShutDown Producer] Producer ").append(this.producerId).append("has been shutdown,please do not make a duplicated invocation.").toString());
            }
            return;
        }
        if (this.nodeStatus.compareAndSet(0, 1)) {
            this.heartbeatService.shutdownNow();
            this.topicPartitionMap.clear();
            this.masterService.producerCloseClientP2M(this.createCloseProducerRequest(), AddressUtils.getLocalAddress(), this.tubeClientConfig.isTlsEnable());
            logger.info("[SHUTDOWN_TUBE] tube heartbeat was shutdown.");
        }
    }

    public String getProducerId() {
        return this.producerId;
    }

    public int getProducerAddrId() {
        return this.producerAddrId;
    }

    public boolean isShutdown() {
        return this.nodeStatus.get() > 0;
    }

    public ClientBroker.SendMessageRequestP2B.Builder setAuthorizedTokenInfo(ClientBroker.SendMessageRequestP2B.Builder builder) {
        ClientBroker.AuthorizedInfo.Builder authInfoBuilder = ClientBroker.AuthorizedInfo.newBuilder();
        authInfoBuilder.setVisitAuthorizedToken(this.visitToken.get());
        String authAuthorizedToken = this.authAuthorizedTokenRef.get();
        if (TStringUtils.isNotBlank((String)authAuthorizedToken)) {
            authInfoBuilder.setAuthAuthorizedToken(authAuthorizedToken);
        }
        builder.setAuthInfo(authInfoBuilder.build());
        return builder;
    }

    public void removeTopic(Set<String> topicSet) {
        for (String topic : topicSet) {
            if (topic == null) continue;
            AtomicInteger subCnt = this.publishTopics.get(topic);
            if (subCnt == null) {
                return;
            }
            if (subCnt.decrementAndGet() != 0) continue;
            this.publishTopics.remove(topic);
        }
    }

    public Map<Integer, List<Partition>> getTopicPartition(String topic) {
        return this.topicPartitionMap.get(topic);
    }

    private void checkServiceStatus() throws TubeClientException {
        if (this.nodeStatus.get() < 0) {
            throw new TubeClientException("Status error: please call start function first!");
        }
        if (this.nodeStatus.get() > 0) {
            throw new TubeClientException("Status error: producer service has been shutdown!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void register2Master() throws Throwable {
        int remainingRetry = this.tubeClientConfig.getMaxRegisterRetryTimes();
        StringBuilder sBuilder = new StringBuilder(512);
        while (true) {
            if (this.isShutdown()) {
                logger.error("Producer service has been shutdown, exit register to master!");
                return;
            }
            --remainingRetry;
            try {
                ClientMaster.RegisterResponseM2P response = this.masterService.producerRegisterP2M(this.createRegisterRequest(), AddressUtils.getLocalAddress(), this.tubeClientConfig.isTlsEnable());
                if (response != null && response.getSuccess()) {
                    if (response.getBrokerCheckSum() != this.brokerInfoCheckSum) {
                        this.updateBrokerInfoList(true, response.getBrokerInfosList(), response.getBrokerCheckSum(), sBuilder);
                    }
                    this.processRegAuthorizedToken(response);
                    return;
                }
                if (remainingRetry <= 0) {
                    if (response != null) throw new TubeClientException(sBuilder.append("Register producer failure, error is ").append(response.getErrMsg()).toString());
                    throw new TubeClientException("Register producer failure, response is null!");
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable e) {
                sBuilder.delete(0, sBuilder.length());
                if (e instanceof LocalConnException) {
                    logger.warn("register2Master error, retry... exception: ", e);
                }
                ThreadUtils.sleep((long)1200L);
                if (remainingRetry <= 0) throw e;
                continue;
            }
            break;
        }
    }

    private ClientMaster.RegisterRequestP2M createRegisterRequest() throws Exception {
        ClientMaster.RegisterRequestP2M.Builder builder = ClientMaster.RegisterRequestP2M.newBuilder();
        builder.setClientId(this.producerId);
        builder.addAllTopicList((Iterable)this.publishTopics.keySet());
        builder.setBrokerCheckSum(this.brokerInfoCheckSum);
        builder.setHostName(AddressUtils.getLocalAddress());
        builder.setJdkVersion(MixedUtils.getJavaVersion());
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo(true);
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        return builder.build();
    }

    private ClientMaster.HeartRequestP2M createHeartbeatRequest() throws Exception {
        ClientMaster.HeartRequestP2M.Builder builder = ClientMaster.HeartRequestP2M.newBuilder();
        builder.setClientId(this.producerId);
        builder.addAllTopicList((Iterable)this.publishTopics.keySet());
        builder.setBrokerCheckSum(this.brokerInfoCheckSum);
        if (System.currentTimeMillis() - this.lastBrokerUpdatedTime > 0x6DDD00L) {
            builder.setBrokerCheckSum(-1L);
            this.lastBrokerUpdatedTime = System.currentTimeMillis();
        }
        builder.setHostName(AddressUtils.getLocalAddress());
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo(false);
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        return builder.build();
    }

    private ClientMaster.CloseRequestP2M createCloseProducerRequest() {
        ClientMaster.CloseRequestP2M.Builder builder = ClientMaster.CloseRequestP2M.newBuilder();
        builder.setClientId(this.producerId);
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo(true);
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder);
        }
        return builder.build();
    }

    private void updateTopicPartitions(List<TopicInfo> topicInfoList) {
        ConcurrentHashMap<String, Map<Integer, List<Partition>>> partitionListMap = new ConcurrentHashMap<String, Map<Integer, List<Partition>>>();
        for (TopicInfo topicInfo : topicInfoList) {
            ConcurrentHashMap<Integer, ArrayList<Partition>> brokerPartList = (ConcurrentHashMap<Integer, ArrayList<Partition>>)partitionListMap.get(topicInfo.getTopic());
            if (brokerPartList == null) {
                brokerPartList = new ConcurrentHashMap<Integer, ArrayList<Partition>>();
                partitionListMap.put(topicInfo.getTopic(), brokerPartList);
            }
            for (int j = 0; j < topicInfo.getTopicStoreNum(); ++j) {
                int baseValue = j * 10000;
                for (int i = 0; i < topicInfo.getPartitionNum(); ++i) {
                    Partition part = new Partition(topicInfo.getBroker(), topicInfo.getTopic(), baseValue + i);
                    ArrayList<Partition> partList = (ArrayList<Partition>)brokerPartList.get(part.getBrokerId());
                    if (partList == null) {
                        partList = new ArrayList<Partition>();
                        brokerPartList.put(part.getBrokerId(), partList);
                    }
                    partList.add(part);
                }
            }
        }
        this.topicPartitionMap = partitionListMap;
    }

    private String generateProducerID() throws Exception {
        String pidName = ManagementFactory.getRuntimeMXBean().getName();
        if (pidName != null && pidName.contains("@")) {
            pidName = pidName.split("@")[0];
        }
        return new StringBuilder(256).append(AddressUtils.getLocalAddress()).append("-").append(pidName).append("-").append(System.currentTimeMillis()).append("-").append(producerCounter.incrementAndGet()).append("-").append("0.6.0-incubating").toString();
    }

    private void updateBrokerInfoList(boolean isRegister, List<String> pkgBrokerInfos, long pkgCheckSum, StringBuilder sBuilder) {
        if (pkgCheckSum != this.brokerInfoCheckSum && pkgBrokerInfos != null) {
            this.brokersMap = DataConverterUtil.convertBrokerInfo(pkgBrokerInfos);
            this.brokerInfoCheckSum = pkgCheckSum;
            this.lastBrokerUpdatedTime = System.currentTimeMillis();
            if (pkgBrokerInfos.isEmpty()) {
                if (System.currentTimeMillis() - this.lastEmptyBrokerPrintTime > 60000L) {
                    if (isRegister) {
                        logger.warn(sBuilder.append("[Register Update] Found empty brokerList, changed checksum is ").append(this.brokerInfoCheckSum).toString());
                    } else {
                        logger.warn(sBuilder.append("[Heartbeat Update] Found empty brokerList, changed checksum is ").append(this.brokerInfoCheckSum).toString());
                    }
                    sBuilder.delete(0, sBuilder.length());
                    this.lastEmptyBrokerPrintTime = System.currentTimeMillis();
                }
            } else if (!isRegister) {
                logger.info(sBuilder.append("[Heartbeat Update] Found brokerList changed checksum is ").append(this.brokerInfoCheckSum).toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
    }

    private void processRegAuthorizedToken(ClientMaster.RegisterResponseM2P response) {
        if (response.hasAuthorizedInfo()) {
            this.processAuthorizedToken(response.getAuthorizedInfo());
        }
    }

    private void processHeartBeatAuthorizedToken(ClientMaster.HeartResponseM2P response) {
        if (response.hasAuthorizedInfo()) {
            this.processAuthorizedToken(response.getAuthorizedInfo());
        }
    }

    private void processAuthorizedToken(ClientMaster.MasterAuthorizedInfo inAuthorizedTokenInfo) {
        if (inAuthorizedTokenInfo != null) {
            String curAuthAuthorizedToken;
            String inAuthAuthorizedToken;
            this.visitToken.set(inAuthorizedTokenInfo.getVisitAuthorizedToken());
            if (inAuthorizedTokenInfo.hasAuthAuthorizedToken() && TStringUtils.isNotBlank((String)(inAuthAuthorizedToken = inAuthorizedTokenInfo.getAuthAuthorizedToken())) && !inAuthAuthorizedToken.equals(curAuthAuthorizedToken = this.authAuthorizedTokenRef.get())) {
                this.authAuthorizedTokenRef.set(inAuthAuthorizedToken);
            }
        }
    }

    private ClientMaster.MasterCertificateInfo.Builder genMasterCertificateInfo(boolean force) {
        boolean needAdd = false;
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = null;
        if (this.tubeClientConfig.isEnableUserAuthentic()) {
            authInfoBuilder = ClientMaster.MasterCertificateInfo.newBuilder();
            if (force) {
                needAdd = true;
                this.nextWithAuthInfo2M.set(false);
            } else if (this.nextWithAuthInfo2M.get() && this.nextWithAuthInfo2M.compareAndSet(true, false)) {
                needAdd = true;
            }
            if (needAdd) {
                authInfoBuilder.setAuthInfo(this.authenticateHandler.genMasterAuthenticateToken(this.tubeClientConfig.getUsrName(), this.tubeClientConfig.getUsrPassWord()));
            } else {
                authInfoBuilder.setAuthorizedToken(this.authAuthorizedTokenRef.get());
            }
        }
        return authInfoBuilder;
    }

    private class ProducerHeartbeatTask
    implements Runnable {
        private ProducerHeartbeatTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder sBuilder = new StringBuilder(512);
            while (!ProducerManager.this.heartBeatStatus.compareAndSet(0, 1)) {
                ThreadUtils.sleep((long)100L);
            }
            if (ProducerManager.this.publishTopics.isEmpty()) {
                return;
            }
            try {
                ClientMaster.HeartResponseM2P response = ProducerManager.this.masterService.producerHeartbeatP2M(ProducerManager.this.createHeartbeatRequest(), AddressUtils.getLocalAddress(), ProducerManager.this.tubeClientConfig.isTlsEnable());
                if (response == null || !response.getSuccess()) {
                    ProducerManager.this.heartbeatRetryTimes++;
                    if (response == null) {
                        logger.error("[Heartbeat Failed] receive null HeartResponseM2P response!");
                    } else {
                        logger.error(sBuilder.append("[Heartbeat Failed] ").append(response.getErrMsg()).toString());
                        sBuilder.delete(0, sBuilder.length());
                        if (response.getErrCode() == 411) {
                            try {
                                ProducerManager.this.register2Master();
                            }
                            catch (Throwable ee) {
                                logger.error(sBuilder.append("[Heartbeat Failed] re-register failure, error is ").append(ee.getMessage()).toString());
                                sBuilder.delete(0, sBuilder.length());
                            }
                        } else if (response.getErrCode() == 415) {
                            this.adjustHeartBeatPeriod("certificate failure", sBuilder);
                        }
                    }
                    return;
                }
                if (response.hasRequireAuth()) {
                    ProducerManager.this.nextWithAuthInfo2M.set(response.getRequireAuth());
                }
                ProducerManager.this.processHeartBeatAuthorizedToken(response);
                if (response.getErrCode() == 201) {
                    ProducerManager.this.lastHeartbeatTime = System.currentTimeMillis();
                    return;
                }
                if (response.getBrokerCheckSum() != ProducerManager.this.brokerInfoCheckSum) {
                    ProducerManager.this.updateBrokerInfoList(false, response.getBrokerInfosList(), response.getBrokerCheckSum(), sBuilder);
                }
                if (response.getTopicInfosList() != null) {
                    if (response.getTopicInfosList().isEmpty() && System.currentTimeMillis() - ProducerManager.this.lastEmptyTopicPrintTime > 60000L) {
                        logger.warn("[Heartbeat Update] found empty topicList update!");
                        ProducerManager.this.lastEmptyTopicPrintTime = System.currentTimeMillis();
                    }
                    ProducerManager.this.updateTopicPartitions(DataConverterUtil.convertTopicInfo((Map)ProducerManager.this.brokersMap, (List)response.getTopicInfosList()));
                } else {
                    logger.error(sBuilder.append("[Heartbeat Failed] Found brokerList or topicList is null, brokerList is ").append(response.getBrokerInfosList() != null).toString());
                    sBuilder.delete(0, sBuilder.length());
                }
                ProducerManager.this.heartbeatRetryTimes = 0;
                long currentTime = System.currentTimeMillis();
                if (currentTime - ProducerManager.this.lastHeartbeatTime > ProducerManager.this.tubeClientConfig.getHeartbeatPeriodMs() * 4L) {
                    logger.warn(sBuilder.append(ProducerManager.this.producerId).append(" heartbeat interval is too long, please check! Total time : ").append(currentTime - ProducerManager.this.lastHeartbeatTime).toString());
                    sBuilder.delete(0, sBuilder.length());
                }
                ProducerManager.this.lastHeartbeatTime = currentTime;
            }
            catch (Throwable e) {
                sBuilder.delete(0, sBuilder.length());
                if (e.getCause() == null || !(e.getCause() instanceof ClientClosedException)) {
                    logger.error("Heartbeat failed,retry later.Reason:{}", (Object)sBuilder.append(e.getClass().getSimpleName()).append("#").append(e.getMessage()).toString());
                    sBuilder.delete(0, sBuilder.length());
                }
                this.adjustHeartBeatPeriod("heartbeat exception", sBuilder);
            }
            finally {
                ProducerManager.this.heartBeatStatus.compareAndSet(1, 0);
            }
        }

        private void adjustHeartBeatPeriod(String reason, StringBuilder sBuilder) {
            ProducerManager.this.lastHeartbeatTime = System.currentTimeMillis();
            ProducerManager.this.heartbeatRetryTimes++;
            if (ProducerManager.this.nodeStatus.get() != 1 && ProducerManager.this.heartbeatRetryTimes > ProducerManager.this.tubeClientConfig.getMaxHeartBeatRetryTimes()) {
                logger.warn(sBuilder.append("Adjust HeartbeatPeriod for ").append(reason).append(", sleep ").append(ProducerManager.this.tubeClientConfig.getHeartbeatPeriodAfterFail()).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
                try {
                    Thread.sleep(ProducerManager.this.tubeClientConfig.getHeartbeatPeriodAfterFail());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

