/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.tubemq;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;

public class Tubemq
extends ConnectorDescriptor {
    @Nullable
    private String topic;
    @Nullable
    private String master;
    @Nullable
    private String group;
    @Nullable
    private String tids;
    @Nonnull
    private Map<String, String> properties = new HashMap<String, String>();

    public Tubemq() {
        super("tubemq", 1, true);
    }

    public Tubemq topic(String topic) {
        Preconditions.checkNotNull((Object)topic);
        this.topic = topic;
        return this;
    }

    public Tubemq master(String master) {
        Preconditions.checkNotNull((Object)master);
        this.master = master;
        return this;
    }

    public Tubemq group(String group) {
        Preconditions.checkNotNull((Object)group);
        this.group = group;
        return this;
    }

    public Tubemq tids(String tids) {
        this.tids = tids;
        return this;
    }

    public Tubemq property(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        this.properties.put(key, value);
        return this;
    }

    protected Map<String, String> toConnectorProperties() {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        if (this.topic != null) {
            descriptorProperties.putString("connector.topic", this.topic);
        }
        if (this.master != null) {
            descriptorProperties.putString("connector.master", this.master);
        }
        if (this.group != null) {
            descriptorProperties.putString("connector.group", this.group);
        }
        if (this.tids != null) {
            descriptorProperties.putString("connector.tids", this.tids);
        }
        descriptorProperties.putPropertiesWithPrefix("connector.properties", this.properties);
        return descriptorProperties.asMap();
    }
}

