/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.tubemq;

import java.util.Arrays;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.tubemq.TubemqSinkFunction;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class TubemqTableSink
implements AppendStreamTableSink<Row> {
    private final SerializationSchema<Row> serializationSchema;
    private final TableSchema schema;
    private final String topic;
    private final String masterAddress;
    private final Configuration configuration;

    public TubemqTableSink(SerializationSchema<Row> serializationSchema, TableSchema schema, String topic, String masterAddress, Configuration configuration) {
        this.serializationSchema = (SerializationSchema)Preconditions.checkNotNull(serializationSchema, (String)"The deserialization schema must not be null.");
        this.schema = (TableSchema)Preconditions.checkNotNull((Object)schema, (String)"The schema must not be null.");
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.masterAddress = (String)Preconditions.checkNotNull((Object)masterAddress, (String)"Master address must not be null.");
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration, (String)"The configuration must not be null.");
    }

    public void emitDataStream(DataStream<Row> dataStream) {
        this.consumeDataStream(dataStream);
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
        TubemqSinkFunction<Row> tubemqSinkFunction = new TubemqSinkFunction<Row>(this.topic, this.masterAddress, this.serializationSchema, this.configuration);
        return dataStream.addSink(tubemqSinkFunction).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.getFieldNames()));
    }

    public TypeInformation<Row> getOutputType() {
        return this.schema.toRowType();
    }

    public String[] getFieldNames() {
        return this.schema.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.schema.getFieldTypes();
    }

    public TubemqTableSink configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        return this;
    }
}

