/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.MultirefHelper;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.deployment.util.ExcludeInfo;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.StreamWrapper;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class BeanUtil {
    private static int nsCount = 1;

    public static XMLStreamReader getPullParser(Object beanObject, QName beanName, TypeTable typeTable, boolean qualified, boolean processingDocLitBare) {
        try {
            JamServiceFactory factory = JamServiceFactory.getInstance();
            JamServiceParams jam_service_parms = factory.createServiceParams();
            ClassLoader cl = beanObject.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            jam_service_parms.addClassLoader(cl);
            jam_service_parms.includeClass(beanObject.getClass().getName());
            JamService service = factory.createService(jam_service_parms);
            JamClassIterator jClassIter = service.getClasses();
            if (!jClassIter.hasNext()) {
                throw new AxisFault("No service class found , exception from JAM");
            }
            JClass jClass = (JClass)jClassIter.next();
            QName elemntNameSpace = null;
            if (typeTable != null && qualified) {
                QName qNamefortheType = typeTable.getQNamefortheType(beanObject.getClass().getName());
                if (qNamefortheType == null) {
                    qNamefortheType = typeTable.getQNamefortheType(beanObject.getClass().getPackage().getName());
                }
                if (qNamefortheType == null) {
                    throw new AxisFault("Mapping qname not fond for the package: " + beanObject.getClass().getPackage().getName());
                }
                elemntNameSpace = new QName(qNamefortheType.getNamespaceURI(), "elementName");
            }
            AxisService axisService = null;
            if (MessageContext.getCurrentMessageContext() != null) {
                axisService = MessageContext.getCurrentMessageContext().getAxisService();
            }
            BeanExcludeInfo beanExcludeInfo = null;
            if (axisService != null && axisService.getExcludeInfo() != null) {
                beanExcludeInfo = axisService.getExcludeInfo().getBeanExcludeInfoForClass(jClass.getQualifiedName());
            }
            ArrayList<Object> propertyList = new ArrayList<Object>();
            Object[] properties = jClass.getDeclaredProperties();
            for (int i = 0; i < properties.length; ++i) {
                JProperty property = properties[i];
                String propertyName = BeanUtil.getCorrectName(property.getSimpleName());
                if (beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName)) continue;
                propertyList.add(property);
            }
            JClass supClass = jClass.getSuperclass();
            while (!supClass.getQualifiedName().startsWith("java.")) {
                properties = supClass.getDeclaredProperties();
                ExcludeInfo excludeInfo = axisService.getExcludeInfo();
                if (excludeInfo != null) {
                    beanExcludeInfo = excludeInfo.getBeanExcludeInfoForClass(supClass.getQualifiedName());
                }
                for (int i = 0; i < properties.length; ++i) {
                    Object property = properties[i];
                    String propertyName = BeanUtil.getCorrectName(property.getSimpleName());
                    if (beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName)) continue;
                    propertyList.add(property);
                }
                supClass = supClass.getSuperclass();
            }
            properties = new JProperty[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                JProperty jProperty = (JProperty)propertyList.get(i);
                properties[i] = jProperty;
            }
            Arrays.sort(properties);
            BeanInfo beanInfo = Introspector.getBeanInfo(beanObject.getClass());
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> propertMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor propDesc = propDescs[i];
                if (propDesc.getName().equals("class")) continue;
                propertMap.put(propDesc.getName(), propDesc);
            }
            ArrayList<Object> object = new ArrayList<Object>();
            for (int i = 0; i < properties.length; ++i) {
                Object o;
                Object[] value;
                Method readMethod;
                Object property = properties[i];
                PropertyDescriptor propDesc = (PropertyDescriptor)propertMap.get(BeanUtil.getCorrectName(property.getSimpleName()));
                if (propDesc == null) {
                    propDesc = (PropertyDescriptor)propertMap.get(property.getSimpleName());
                }
                if (propDesc == null) continue;
                Class<?> ptype = propDesc.getPropertyType();
                if (propDesc.getName().equals("class")) continue;
                if (SimpleTypeMapper.isSimpleType(ptype)) {
                    readMethod = propDesc.getReadMethod();
                    if (readMethod != null) {
                        if (property.getGetter() != null && property.getGetter().isPublic()) {
                            readMethod.setAccessible(true);
                        }
                    } else {
                        throw new AxisFault("can not find read method for : " + propDesc.getName());
                    }
                    value = readMethod.invoke(beanObject, null);
                    BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                    object.add(value == null ? null : SimpleTypeMapper.getStringValue(value));
                    continue;
                }
                if (ptype.isArray()) {
                    if (SimpleTypeMapper.isSimpleType(ptype.getComponentType())) {
                        readMethod = propDesc.getReadMethod();
                        if (readMethod != null) {
                            if (property.getGetter() != null && property.getGetter().isPublic()) {
                                readMethod.setAccessible(true);
                            }
                        } else {
                            throw new AxisFault("can not find read method for : " + propDesc.getName());
                        }
                        value = readMethod.invoke(beanObject, null);
                        if (value != null) {
                            if ("byte".equals(ptype.getComponentType().getName())) {
                                BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                                object.add(Base64.encode((byte[])value));
                                continue;
                            }
                            int i1 = Array.getLength(value);
                            for (int j = 0; j < i1; ++j) {
                                o = Array.get(value, j);
                                BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                                object.add(o == null ? null : SimpleTypeMapper.getStringValue(o));
                            }
                            continue;
                        }
                        BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                        object.add(value);
                        continue;
                    }
                    readMethod = propDesc.getReadMethod();
                    value = null;
                    if (readMethod != null) {
                        if (property.getGetter() != null && property.getGetter().isPublic()) {
                            readMethod.setAccessible(true);
                        }
                        value = (Object[])propDesc.getReadMethod().invoke(beanObject, null);
                    }
                    if (value != null) {
                        for (int j = 0; j < value.length; ++j) {
                            Object o2 = value[j];
                            BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                            object.add(o2);
                        }
                        continue;
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                    object.add(value);
                    continue;
                }
                if (SimpleTypeMapper.isCollection(ptype)) {
                    Collection objList;
                    readMethod = propDesc.getReadMethod();
                    if (property.getGetter() != null && property.getGetter().isPublic()) {
                        readMethod.setAccessible(true);
                    }
                    if ((objList = (Collection)(value = readMethod.invoke(beanObject, null))) != null && objList.size() > 0) {
                        Iterator j = objList.iterator();
                        while (j.hasNext()) {
                            o = j.next();
                            if (SimpleTypeMapper.isSimpleType(o)) {
                                BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                                object.add(o);
                                continue;
                            }
                            BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                            object.add(o);
                        }
                        continue;
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                    object.add(value);
                    continue;
                }
                BeanUtil.addTypeQname(elemntNameSpace, object, propDesc, beanName, processingDocLitBare);
                readMethod = propDesc.getReadMethod();
                if (property.getGetter() != null && property.getGetter().isPublic()) {
                    readMethod.setAccessible(true);
                }
                value = readMethod.invoke(beanObject, null);
                if ("java.lang.Object".equals(ptype.getName()) && (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Float)) {
                    object.add(value.toString());
                    continue;
                }
                object.add(value);
            }
            ArrayList<Object> objectAttributes = new ArrayList<Object>();
            objectAttributes.add(new QName("type"));
            objectAttributes.add(beanObject.getClass().getName());
            return new ADBXMLStreamReaderImpl(beanName, object.toArray(), objectAttributes.toArray(), typeTable, qualified);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addTypeQname(QName elemntNameSpace, ArrayList object, PropertyDescriptor propDesc, QName beanName, boolean processingDocLitBare) {
        if (elemntNameSpace != null) {
            object.add(new QName(elemntNameSpace.getNamespaceURI(), BeanUtil.getCorrectName(propDesc.getName()), elemntNameSpace.getPrefix()));
        } else if (processingDocLitBare) {
            object.add(new QName(BeanUtil.getCorrectName(propDesc.getName())));
        } else {
            object.add(new QName(beanName.getNamespaceURI(), BeanUtil.getCorrectName(propDesc.getName()), beanName.getPrefix()));
        }
    }

    public static XMLStreamReader getPullParser(Object beanObject) {
        String className = beanObject.getClass().getName();
        if (className.indexOf(".") > 0) {
            className = className.substring(className.lastIndexOf(46) + 1, className.length());
        }
        return BeanUtil.getPullParser(beanObject, new QName(className), null, false, false);
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, ObjectSupplier objectSupplier, String arrayLocalName) throws AxisFault {
        Object beanObj = null;
        try {
            String instanceTypeName = beanElement.getAttributeValue(new QName("type"));
            if (instanceTypeName != null && !beanClass.isArray()) {
                try {
                    beanClass = Loader.loadClass(beanClass.getClassLoader(), instanceTypeName);
                }
                catch (ClassNotFoundException ce) {
                    throw AxisFault.makeFault(ce);
                }
            }
            if (beanClass.isArray()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                Class<?> arrayClassType = beanClass.getComponentType();
                if ("byte".equals(arrayClassType.getName())) {
                    return Base64.decode(beanElement.getFirstElement().getText());
                }
                Iterator parts = beanElement.getChildElements();
                while (parts.hasNext()) {
                    Object obj;
                    OMElement omElement;
                    Object objValue = parts.next();
                    if (!(objValue instanceof OMElement) || !arrayLocalName.equals((omElement = (OMElement)objValue).getLocalName()) || (obj = BeanUtil.deserialize(arrayClassType, omElement, objectSupplier, null)) == null) continue;
                    valueList.add(obj);
                }
                return ConverterUtil.convertToArray(arrayClassType, valueList);
            }
            if (SimpleTypeMapper.isSimpleType(beanClass)) {
                return SimpleTypeMapper.getSimpleTypeObject(beanClass, beanElement);
            }
            if ("java.lang.Object".equals(beanClass.getName())) {
                return beanElement.getFirstOMChild();
            }
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor proprty = propDescs[i];
                properties.put(proprty.getName(), proprty);
            }
            Iterator elements = beanElement.getChildren();
            if (beanObj == null) {
                beanObj = objectSupplier.getObject(beanClass);
            }
            while (elements.hasNext()) {
                Object objValue = elements.next();
                if (!(objValue instanceof OMElement)) continue;
                OMElement parts = (OMElement)objValue;
                OMAttribute attribute = parts.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
                String partsLocalName = parts.getLocalName();
                PropertyDescriptor prty = (PropertyDescriptor)properties.remove(partsLocalName);
                if (prty == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.equals("class")) continue;
                Object partObj = attribute != null ? null : (SimpleTypeMapper.isSimpleType(parameters) ? SimpleTypeMapper.getSimpleTypeObject(parameters, parts) : (SimpleTypeMapper.isCollection(parameters) ? SimpleTypeMapper.getArrayList((OMElement)parts.getParent(), prty.getName()) : (SimpleTypeMapper.isDataHandler(parameters) ? SimpleTypeMapper.getDataHandler(parts) : (parameters.isArray() ? BeanUtil.deserialize(parameters, (OMElement)parts.getParent(), objectSupplier, prty.getName()) : BeanUtil.deserialize(parameters, parts, objectSupplier, null)))));
                Object[] parms = new Object[]{partObj};
                Method writeMethod = prty.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.setAccessible(true);
                writeMethod.invoke(beanObj, parms);
            }
            return beanObj;
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, MultirefHelper helper, ObjectSupplier objectSupplier) throws AxisFault {
        Object beanObj;
        try {
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor proprty = propDescs[i];
                properties.put(proprty.getName(), proprty);
            }
            beanObj = objectSupplier.getObject(beanClass);
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                Object partObj;
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object child = elements.next();
                if (!(child instanceof OMElement) || (prty = (PropertyDescriptor)properties.get((partsLocalName = (parts = (OMElement)child).getLocalName()).toLowerCase())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.equals("class")) continue;
                OMAttribute attr = MultirefHelper.processRefAtt(parts);
                if (attr != null) {
                    String refId = MultirefHelper.getAttvalue(attr);
                    partObj = helper.getObject(refId);
                    if (partObj == null) {
                        partObj = helper.processRef(parameters, refId, objectSupplier);
                    }
                } else {
                    partObj = SimpleTypeMapper.getSimpleTypeObject(parameters, parts);
                    if (partObj == null) {
                        partObj = BeanUtil.deserialize(parameters, parts, objectSupplier, null);
                    }
                }
                Object[] parms = new Object[]{partObj};
                Method writeMethod = prty.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.setAccessible(true);
                writeMethod.invoke(beanObj, parms);
            }
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
        return beanObj;
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes, ObjectSupplier objectSupplier) throws AxisFault {
        int length = javaTypes.length;
        int count = 0;
        Object[] retObjs = new Object[length];
        Iterator parts = response.getChildren();
        MultirefHelper helper = new MultirefHelper((OMElement)response.getParent());
        while (parts.hasNext() && count < length) {
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            OMElement omElement = (OMElement)objValue;
            String currentLocalName = omElement.getLocalName();
            Class classType = (Class)javaTypes[count];
            omElement = BeanUtil.ProcessElement(classType, omElement, helper, parts, currentLocalName, retObjs, count, objectSupplier);
            while (omElement != null) {
                omElement = BeanUtil.ProcessElement((Class)javaTypes[++count], omElement, helper, parts, omElement.getLocalName(), retObjs, count, objectSupplier);
            }
            ++count;
        }
        for (int i = 0; i < length; ++i) {
            Class clazz = (Class)javaTypes[i];
            if (retObjs[i] != null || !clazz.isArray()) continue;
            retObjs[i] = Array.newInstance(clazz.getComponentType(), 0);
        }
        helper.clean();
        return retObjs;
    }

    private static OMElement ProcessElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, String currentLocalName, Object[] retObjs, int count, ObjectSupplier objectSupplier) throws AxisFault {
        if (classType.isArray()) {
            boolean done = true;
            ArrayList<Object> valueList = new ArrayList<Object>();
            Class<?> arrayClassType = classType.getComponentType();
            if ("byte".equals(arrayClassType.getName())) {
                retObjs[count] = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier);
                return null;
            }
            valueList.add(BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier));
            while (parts.hasNext()) {
                Object objValue = parts.next();
                if (!(objValue instanceof OMElement)) continue;
                omElement = (OMElement)objValue;
                if (!currentLocalName.equals(omElement.getLocalName())) {
                    done = false;
                    break;
                }
                Object o = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier);
                valueList.add(o);
            }
            retObjs[count] = valueList.get(0) == null ? null : ConverterUtil.convertToArray(arrayClassType, valueList);
            if (!done) {
                return omElement;
            }
        } else {
            retObjs[count] = BeanUtil.processObject(omElement, classType, helper, false, objectSupplier);
        }
        return null;
    }

    public static Object processObject(OMElement omElement, Class classType, MultirefHelper helper, boolean isArrayType, ObjectSupplier objectSupplier) throws AxisFault {
        boolean hasRef = false;
        OMAttribute omatribute = MultirefHelper.processRefAtt(omElement);
        String ref = null;
        if (omatribute != null) {
            hasRef = true;
            ref = MultirefHelper.getAttvalue(omatribute);
        }
        if (OMElement.class.isAssignableFrom(classType)) {
            if (hasRef) {
                OMElement elemnt = helper.getOMElement(ref);
                if (elemnt == null) {
                    return helper.processOMElementRef(ref);
                }
                return elemnt;
            }
            return omElement;
        }
        if (hasRef) {
            if (helper.getObject(ref) != null) {
                return helper.getObject(ref);
            }
            return helper.processRef(classType, ref, objectSupplier);
        }
        OMAttribute attribute = omElement.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
        if (attribute != null) {
            return null;
        }
        if (SimpleTypeMapper.isSimpleType(classType)) {
            if (isArrayType && "byte".equals(classType.getName())) {
                String value = omElement.getText();
                return Base64.decode(value);
            }
            return SimpleTypeMapper.getSimpleTypeObject(classType, omElement);
        }
        if (SimpleTypeMapper.isCollection(classType)) {
            return SimpleTypeMapper.getArrayList(omElement);
        }
        if (SimpleTypeMapper.isDataHandler(classType)) {
            return SimpleTypeMapper.getDataHandler(omElement);
        }
        return BeanUtil.deserialize(classType, omElement, objectSupplier, null);
    }

    public static OMElement getOMElement(QName opName, Object[] args, QName partName, boolean qualifed, TypeTable typeTable) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int argCount = 0;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                if (partName == null) {
                    objects.add("item" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(arg);
                continue;
            }
            if (arg instanceof Object[]) {
                Object[] array = (Object[])arg;
                for (int j = 0; j < array.length; ++j) {
                    Object o = array[j];
                    if (o == null) {
                        objects.add("item" + argCount);
                        objects.add(o);
                        continue;
                    }
                    if (SimpleTypeMapper.isSimpleType(o)) {
                        objects.add("item" + argCount);
                        objects.add(SimpleTypeMapper.getStringValue(o));
                        continue;
                    }
                    objects.add(new QName("item" + argCount));
                    if (o instanceof OMElement) {
                        OMElement wrappingElement;
                        OMFactory fac = OMAbstractFactory.getOMFactory();
                        if (partName == null) {
                            wrappingElement = fac.createOMElement("item" + argCount, null);
                            wrappingElement.addChild((OMElement)o);
                        } else {
                            wrappingElement = fac.createOMElement(partName, null);
                            wrappingElement.addChild((OMElement)o);
                        }
                        objects.add(wrappingElement);
                        continue;
                    }
                    objects.add(o);
                }
            } else if (SimpleTypeMapper.isSimpleType(arg)) {
                if (partName == null) {
                    objects.add("arg" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(SimpleTypeMapper.getStringValue(arg));
            } else {
                if (partName == null) {
                    objects.add(new QName("arg" + argCount));
                } else {
                    objects.add(partName);
                }
                if (arg instanceof OMElement) {
                    OMElement wrappingElement;
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    if (partName == null) {
                        wrappingElement = fac.createOMElement("arg" + argCount, null);
                        wrappingElement.addChild((OMElement)arg);
                    } else {
                        wrappingElement = fac.createOMElement(partName, null);
                        wrappingElement.addChild((OMElement)arg);
                    }
                    objects.add(wrappingElement);
                } else if (arg instanceof byte[]) {
                    objects.add(Base64.encode((byte[])arg));
                } else if (SimpleTypeMapper.isDataHandler(arg.getClass())) {
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    OMElement wrappingElement = partName == null ? fac.createOMElement("arg" + argCount, null) : fac.createOMElement(partName, null);
                    OMText text = fac.createOMText(arg, true);
                    wrappingElement.addChild(text);
                    objects.add(wrappingElement);
                } else {
                    objects.add(arg);
                }
            }
            ++argCount;
        }
        ADBXMLStreamReaderImpl xr = new ADBXMLStreamReaderImpl(opName, objects.toArray(), null, typeTable, qualifed);
        StreamWrapper parser = new StreamWrapper(xr);
        StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getSOAP11Factory(), parser);
        return stAXOMBuilder.getDocumentElement();
    }

    public static synchronized String getUniquePrifix() {
        return BeanUtil.getUniquePrefix();
    }

    public static synchronized String getUniquePrefix() {
        if (nsCount > 1000) {
            nsCount = 1;
        }
        return "s" + nsCount++;
    }

    private static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }
}

