/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dataretrieval;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRetrievalUtil {
    private static final Log log = LogFactory.getLog(DataRetrievalUtil.class);
    private static DataRetrievalUtil instance = null;

    public static DataRetrievalUtil getInstance() {
        if (instance == null) {
            instance = new DataRetrievalUtil();
        }
        return instance;
    }

    public OMElement buildOM(ClassLoader classLoader, String file) throws DataRetrievalException {
        OMElement element = null;
        InputStream servicexmlStream = null;
        try {
            servicexmlStream = DataRetrievalUtil.getInputStream(classLoader, file);
            element = DataRetrievalUtil.convertToOMElement(servicexmlStream);
        }
        catch (Exception e) {
            throw new DataRetrievalException("Failed to load from file, " + file, e);
        }
        return element;
    }

    public static OMElement convertToOMElement(InputStream servicexmlStream) throws XMLStreamException, OMException {
        OMElement element = null;
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader(servicexmlStream);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
        element = staxOMBuilder.getDocumentElement();
        element.build();
        return element;
    }

    private static InputStream getInputStream(ClassLoader classLoader, String file) throws XMLStreamException {
        InputStream servicexmlStream = classLoader.getResourceAsStream(file);
        if (servicexmlStream == null) {
            String message = "File does not exist in the Service Repository! File=" + file;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new XMLStreamException(message);
        }
        return servicexmlStream;
    }
}

