/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.ApplicationXMLBuilder;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.MIMEBuilder;
import org.apache.axis2.builder.MTOMBuilder;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.builder.XFormURLEncodedBuilder;
import org.apache.axis2.deployment.ClusterBuilder;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.transaction.TransactionConfiguration;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisConfigBuilder
extends DescriptionBuilder {
    protected static final Log log = LogFactory.getLog(AxisConfigBuilder.class);
    private DeploymentEngine deploymentEngine;

    public AxisConfigBuilder(InputStream serviceInputStream, AxisConfiguration axisConfiguration, DeploymentEngine deploymentEngine) {
        super(serviceInputStream, axisConfiguration);
        this.deploymentEngine = deploymentEngine;
    }

    public AxisConfigBuilder(AxisConfiguration axisConfiguration) {
        this.axisConfig = axisConfiguration;
    }

    public void populateConfig() throws DeploymentException {
        try {
            OMElement attachmentsLifecycleManagerElement;
            Iterator deployerItr;
            OMElement messageFormattersElement;
            OMElement rolePlayerElement;
            OMElement dataLocatorElement;
            OMElement transactionElement;
            OMElement clusterElement;
            OMElement defaultModuleVerionElement;
            Iterator policyRefElements;
            OMElement config_element = this.buildOM();
            if (!"axisconfig".equals(config_element.getLocalName())) {
                throw new DeploymentException(Messages.getMessage("badelementfound", "axisconfig", config_element.getLocalName()));
            }
            Iterator itr = config_element.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.axisConfig, this.axisConfig);
            OMElement messageReceiver = config_element.getFirstChildWithName(new QName("messageReceivers"));
            if (messageReceiver != null) {
                HashMap mrs = this.processMessageReceivers(messageReceiver);
                for (String key : mrs.keySet()) {
                    this.axisConfig.addMessageReceiver(key, (MessageReceiver)mrs.get(key));
                }
            }
            Iterator moduleitr = config_element.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleitr, this.axisConfig);
            Iterator trs_senders = config_element.getChildrenWithName(new QName("transportSender"));
            this.processTransportSenders(trs_senders);
            Iterator trs_Reivers = config_element.getChildrenWithName(new QName("transportReceiver"));
            this.processTransportReceivers(trs_Reivers);
            OMElement targetResolvers = config_element.getFirstChildWithName(new QName("targetResolvers"));
            this.processTargetResolvers(this.axisConfig, targetResolvers);
            OMElement threadContextMigrators = config_element.getFirstChildWithName(new QName("threadContextMigrators"));
            this.processThreadContextMigrators(this.axisConfig, threadContextMigrators);
            Iterator obs_ittr = config_element.getChildrenWithName(new QName("listener"));
            this.processObservers(obs_ittr);
            Iterator phaseorders = config_element.getChildrenWithName(new QName("phaseOrder"));
            this.processPhaseOrders(phaseorders);
            Iterator moduleConfigs = config_element.getChildrenWithName(new QName("moduleConfig"));
            this.processModuleConfig(moduleConfigs, this.axisConfig, this.axisConfig);
            Iterator policyElements = config_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null && policyElements.hasNext()) {
                this.processPolicyElements(policyElements, this.axisConfig.getPolicySubject());
            }
            if ((policyRefElements = config_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null && policyRefElements.hasNext()) {
                this.processPolicyRefElements(policyElements, this.axisConfig.getPolicySubject());
            }
            if ((defaultModuleVerionElement = config_element.getFirstChildWithName(new QName("defaultModuleVersions"))) != null) {
                this.processDefaultModuleVersions(defaultModuleVerionElement);
            }
            if ((clusterElement = config_element.getFirstChildWithName(new QName("cluster"))) != null) {
                ClusterBuilder clusterBuilder = new ClusterBuilder(this.axisConfig);
                clusterBuilder.buildCluster(clusterElement);
            }
            if ((transactionElement = config_element.getFirstChildWithName(new QName("transaction"))) != null) {
                ParameterIncludeImpl transactionParameters = new ParameterIncludeImpl();
                Iterator parameters = transactionElement.getChildrenWithName(new QName("parameter"));
                this.processParameters(parameters, transactionParameters, null);
                TransactionConfiguration txcfg = new TransactionConfiguration(transactionParameters);
                OMAttribute timeoutAttribute = transactionElement.getAttribute(new QName("timeout"));
                if (timeoutAttribute != null) {
                    txcfg.setTransactionTimeout(Integer.parseInt(timeoutAttribute.getAttributeValue()));
                }
                this.axisConfig.setTransactionConfig(txcfg);
            }
            this.axisConfig.addMessageBuilder("multipart/related", new MIMEBuilder());
            this.axisConfig.addMessageBuilder("application/soap+xml", new SOAPBuilder());
            this.axisConfig.addMessageBuilder("text/xml", new SOAPBuilder());
            this.axisConfig.addMessageBuilder("application/xop+xml", new MTOMBuilder());
            this.axisConfig.addMessageBuilder("application/xml", new ApplicationXMLBuilder());
            this.axisConfig.addMessageBuilder("application/x-www-form-urlencoded", new XFormURLEncodedBuilder());
            OMElement messageBuildersElement = config_element.getFirstChildWithName(new QName("messageBuilders"));
            if (messageBuildersElement != null) {
                HashMap builderSelector = this.processMessageBuilders(messageBuildersElement);
                for (String key : builderSelector.keySet()) {
                    this.axisConfig.addMessageBuilder(key, (Builder)builderSelector.get(key));
                }
            }
            if ((dataLocatorElement = config_element.getFirstChildWithName(new QName("dataLocator"))) != null) {
                this.processDataLocatorConfig(dataLocatorElement);
            }
            if ((rolePlayerElement = config_element.getFirstChildWithName(new QName("SOAPRoleConfiguration"))) != null) {
                this.processSOAPRoleConfig(this.axisConfig, rolePlayerElement);
            }
            if ((messageFormattersElement = config_element.getFirstChildWithName(new QName("messageFormatters"))) != null) {
                HashMap messageFormatters = this.processMessageFormatters(messageFormattersElement);
                for (String key : messageFormatters.keySet()) {
                    this.axisConfig.addMessageFormatter(key, (MessageFormatter)messageFormatters.get(key));
                }
            }
            if ((deployerItr = config_element.getChildrenWithName(new QName("deployer"))) != null) {
                this.processDeployers(deployerItr);
            }
            if ((attachmentsLifecycleManagerElement = config_element.getFirstChildWithName(new QName("attachmentsLifecycleManager"))) != null) {
                this.processAttachmentsLifecycleManager(this.axisConfig, attachmentsLifecycleManagerElement);
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
    }

    private void processTargetResolvers(AxisConfiguration axisConfig, OMElement targetResolvers) {
        if (targetResolvers != null) {
            Iterator iterator = targetResolvers.getChildrenWithName(new QName("targetResolver"));
            while (iterator.hasNext()) {
                OMElement targetResolver = (OMElement)iterator.next();
                OMAttribute classNameAttribute = targetResolver.getAttribute(new QName("class"));
                String className = classNameAttribute.getAttributeValue();
                try {
                    Class classInstance = Loader.loadClass(className);
                    TargetResolver tr = (TargetResolver)classInstance.newInstance();
                    axisConfig.addTargetResolver(tr);
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("processTargetResolvers: Exception thrown initialising TargetResolver: " + e.getMessage()));
                }
            }
        }
    }

    private void processThreadContextMigrators(AxisConfiguration axisConfig, OMElement targetResolvers) {
        if (targetResolvers != null) {
            Iterator iterator = targetResolvers.getChildrenWithName(new QName("threadContextMigrator"));
            while (iterator.hasNext()) {
                OMElement threadContextMigrator = (OMElement)iterator.next();
                OMAttribute listIdAttribute = threadContextMigrator.getAttribute(new QName("listId"));
                String listId = listIdAttribute.getAttributeValue();
                OMAttribute classNameAttribute = threadContextMigrator.getAttribute(new QName("class"));
                String className = classNameAttribute.getAttributeValue();
                try {
                    Class clazz = Loader.loadClass(className);
                    ThreadContextMigrator migrator = (ThreadContextMigrator)clazz.newInstance();
                    ThreadContextMigratorUtil.addThreadContextMigrator(axisConfig, listId, migrator);
                }
                catch (UnsupportedClassVersionError e) {
                    log.info((Object)("Disabled - " + className + " - " + e.getMessage()));
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("processThreadContextMigrators: Exception thrown initialising ThreadContextMigrator: " + e.getMessage()));
                }
            }
        }
    }

    private void processAttachmentsLifecycleManager(AxisConfiguration axisConfig, OMElement element) {
        block2: {
            String className = element.getAttributeValue(new QName("class"));
            try {
                Class classInstance = Loader.loadClass(className);
                LifecycleManager manager = (LifecycleManager)classInstance.newInstance();
                axisConfig.addParameter("attachmentsLifecycleManager", manager);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)("processAttachmentsLifecycleManager: Exception thrown initialising LifecycleManager: " + e.getMessage()));
            }
        }
    }

    private void processSOAPRoleConfig(AxisConfiguration axisConfig, OMElement soaproleconfigElement) {
        block4: {
            if (soaproleconfigElement != null) {
                final boolean isUltimateReceiever = JavaUtils.isTrue(soaproleconfigElement.getAttributeValue(new QName("isUltimateReceiver")), true);
                ArrayList<String> roles = new ArrayList<String>();
                Iterator iterator = soaproleconfigElement.getChildrenWithName(new QName("role"));
                while (iterator.hasNext()) {
                    OMElement roleElement = (OMElement)iterator.next();
                    roles.add(roleElement.getText());
                }
                final List unmodifiableRoles = Collections.unmodifiableList(roles);
                try {
                    RolePlayer rolePlayer = new RolePlayer(){

                        public List getRoles() {
                            return unmodifiableRoles;
                        }

                        public boolean isUltimateDestination() {
                            return isUltimateReceiever;
                        }
                    };
                    axisConfig.addParameter("rolePlayer", rolePlayer);
                }
                catch (AxisFault e) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)("processTargetResolvers: Exception thrown initialising TargetResolver: " + e.getMessage()));
                }
            }
        }
    }

    private void processDeployers(Iterator deployerItr) {
        HashMap<String, Deployer> extensionToDeployerMappingMap = new HashMap<String, Deployer>();
        HashMap<String, Map<String, Deployer>> deployers = new HashMap<String, Map<String, Deployer>>();
        while (deployerItr.hasNext()) {
            Deployer deployer;
            OMElement element = (OMElement)deployerItr.next();
            String directory = element.getAttributeValue(new QName("directory"));
            if (directory == null) {
                log.error((Object)("Deployer missing 'directory' attribute : " + ((Object)element).toString()));
                continue;
            }
            String extension = element.getAttributeValue(new QName("extension"));
            if (extension == null) {
                log.error((Object)("Deployer missing 'extension' attribute : " + ((Object)element).toString()));
                continue;
            }
            if (extension.charAt(0) == '.') {
                extension = extension.substring(1);
            }
            String deployerClassName = element.getAttributeValue(new QName("class"));
            try {
                Class deployerClass = Loader.loadClass(deployerClassName);
                deployer = (Deployer)deployerClass.newInstance();
            }
            catch (UnsupportedClassVersionError ex) {
                log.info((Object)("Disabled - " + deployerClassName + " - " + ex.getMessage()));
                continue;
            }
            catch (Exception e) {
                log.info((Object)("Unable to instantiate deployer " + deployerClassName));
                log.debug((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            deployer.setDirectory(directory);
            deployer.setExtension(extension);
            HashMap<String, Deployer> extensionMap = (HashMap<String, Deployer>)deployers.get(directory);
            if (extensionMap == null) {
                extensionMap = new HashMap<String, Deployer>();
                deployers.put(directory, extensionMap);
            }
            extensionMap.put(extension, deployer);
            extensionToDeployerMappingMap.put(extension, deployer);
        }
        if (this.deploymentEngine != null) {
            this.deploymentEngine.setExtensionToDeployerMappingMap(extensionToDeployerMappingMap);
            this.deploymentEngine.setDeployers(deployers);
        }
    }

    protected void processModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisConfiguration config) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(module, parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            config.addModuleConfig(moduleConfiguration);
        }
    }

    protected void processModuleRefs(Iterator moduleRefs, AxisConfiguration config) {
        while (moduleRefs.hasNext()) {
            OMElement moduleref = (OMElement)moduleRefs.next();
            OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
            String refName = moduleRefAttribute.getAttributeValue();
            this.axisConfig.addGlobalModuleRef(refName);
        }
    }

    private void processObservers(Iterator oservers) {
        while (oservers.hasNext()) {
            try {
                Class observerclass;
                OMElement observerelement = (OMElement)oservers.next();
                OMAttribute trsClas = observerelement.getAttribute(new QName("class"));
                if (trsClas == null) {
                    log.info((Object)Messages.getMessage("obsererror"));
                    return;
                }
                final String clasName = trsClas.getAttributeValue();
                try {
                    observerclass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Loader.loadClass(clasName);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (ClassNotFoundException)e.getException();
                }
                AxisObserver observer = (AxisObserver)observerclass.newInstance();
                Iterator itr = observerelement.getChildrenWithName(new QName("parameter"));
                this.processParameters(itr, observer, this.axisConfig);
                try {
                    observer.init(this.axisConfig);
                }
                catch (Throwable e) {
                    log.info((Object)e.getMessage());
                }
                this.axisConfig.addObservers(observer);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
            }
        }
    }

    private ArrayList processPhaseList(OMElement phaseOrders) throws DeploymentException {
        ArrayList<Phase> phaselist = new ArrayList<Phase>();
        Iterator phases = phaseOrders.getChildrenWithName(new QName("phase"));
        while (phases.hasNext()) {
            Phase phase;
            OMElement phaseelement = (OMElement)phases.next();
            String phaseName = phaseelement.getAttribute(new QName("name")).getAttributeValue();
            String phaseClass = phaseelement.getAttributeValue(new QName("class"));
            try {
                phase = this.getPhase(phaseClass);
            }
            catch (Exception e) {
                throw new DeploymentException(Messages.getMessage("phaseclassnotfound", phaseClass, e.getMessage()));
            }
            phase.setName(phaseName);
            Iterator handlers = phaseelement.getChildrenWithName(new QName("handler"));
            while (handlers.hasNext()) {
                OMElement omElement = (OMElement)handlers.next();
                HandlerDescription handler = this.processHandler(omElement, this.axisConfig, phaseName);
                handler.getRules().setPhaseName(phaseName);
                try {
                    if (!Utils.loadHandler(this.axisConfig.getSystemClassLoader(), handler)) continue;
                    try {
                        phase.addHandler(handler);
                    }
                    catch (PhaseException e) {
                        throw new DeploymentException(e);
                    }
                }
                catch (UnsupportedClassVersionError e) {
                    log.info((Object)("Disabled - " + handler + " - " + e.getMessage()));
                }
            }
            phaselist.add(phase);
        }
        return phaselist;
    }

    private void processPhaseOrders(Iterator phaserders) throws DeploymentException {
        PhasesInfo info = this.axisConfig.getPhasesInfo();
        while (phaserders.hasNext()) {
            OMElement phaseOrders = (OMElement)phaserders.next();
            String flowType = phaseOrders.getAttribute(new QName("type")).getAttributeValue();
            if ("InFlow".equals(flowType)) {
                info.setINPhases(this.processPhaseList(phaseOrders));
                continue;
            }
            if ("InFaultFlow".equals(flowType)) {
                info.setIN_FaultPhases(this.processPhaseList(phaseOrders));
                continue;
            }
            if ("OutFlow".equals(flowType)) {
                info.setOUTPhases(this.processPhaseList(phaseOrders));
                continue;
            }
            if (!"OutFaultFlow".equals(flowType)) continue;
            info.setOUT_FaultPhases(this.processPhaseList(phaseOrders));
        }
    }

    private void processDefaultModuleVersions(OMElement defaultVersions) throws DeploymentException {
        Iterator moduleVersions = defaultVersions.getChildrenWithName(new QName("module"));
        while (moduleVersions.hasNext()) {
            OMElement omElement = (OMElement)moduleVersions.next();
            String name = omElement.getAttributeValue(new QName("name"));
            if (name == null) {
                throw new DeploymentException(Messages.getMessage("modulenamecannotbenull"));
            }
            String version = omElement.getAttributeValue(new QName("version"));
            if (version == null) {
                throw new DeploymentException(Messages.getMessage("moduleversioncannotbenull"));
            }
            this.axisConfig.addDefaultModuleVersion(name, version);
        }
    }

    public ArrayList processTransportReceivers(Iterator trs_senders) throws DeploymentException {
        ArrayList<TransportInDescription> transportReceivers = new ArrayList<TransportInDescription>();
        while (trs_senders.hasNext()) {
            OMElement transport = (OMElement)trs_senders.next();
            OMAttribute trsName = transport.getAttribute(new QName("name"));
            if (trsName == null) continue;
            String name = trsName.getAttributeValue();
            TransportInDescription transportIN = new TransportInDescription(name);
            OMAttribute trsClas = transport.getAttribute(new QName("class"));
            if (trsClas != null) {
                try {
                    String clasName = trsClas.getAttributeValue();
                    Class receiverClass = Loader.loadClass(clasName);
                    TransportListener receiver = (TransportListener)receiverClass.newInstance();
                    transportIN.setReceiver(receiver);
                }
                catch (NoClassDefFoundError e) {
                    if (this.deploymentEngine != null) {
                        throw new DeploymentException(e);
                    }
                    log.debug((Object)Messages.getMessage("classnotfound", trsClas.getAttributeValue()));
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(e);
                }
                catch (IllegalAccessException e) {
                    throw new DeploymentException(e);
                }
                catch (InstantiationException e) {
                    throw new DeploymentException(e);
                }
            }
            try {
                Iterator itr = transport.getChildrenWithName(new QName("parameter"));
                this.processParameters(itr, transportIN, this.axisConfig);
                this.axisConfig.addTransportIn(transportIN);
                transportReceivers.add(transportIN);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
        }
        return transportReceivers;
    }

    public void processTransportSenders(Iterator trs_senders) throws DeploymentException {
        while (trs_senders.hasNext()) {
            OMElement transport = (OMElement)trs_senders.next();
            OMAttribute trsName = transport.getAttribute(new QName("name"));
            if (trsName == null) continue;
            String name = trsName.getAttributeValue();
            TransportOutDescription transportout = new TransportOutDescription(name);
            OMAttribute trsClas = transport.getAttribute(new QName("class"));
            if (trsClas == null) {
                throw new DeploymentException(Messages.getMessage("transportSenderError", name));
            }
            String clasName = trsClas.getAttributeValue();
            try {
                Class sender = Loader.loadClass(clasName);
                TransportSender transportSender = (TransportSender)sender.newInstance();
                transportout.setSender(transportSender);
                Iterator itr = transport.getChildrenWithName(new QName("parameter"));
                this.processParameters(itr, transportout, this.axisConfig);
                this.axisConfig.addTransportOut(transportout);
            }
            catch (NoClassDefFoundError e) {
                if (this.deploymentEngine != null) {
                    log.debug((Object)Messages.getMessage("errorinloadingts", clasName), (Throwable)e);
                    throw new DeploymentException(e);
                }
                log.debug((Object)Messages.getMessage("classnotfound", trsClas.getAttributeValue()));
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)Messages.getMessage("errorinloadingts", clasName), (Throwable)e);
                throw new DeploymentException(e);
            }
            catch (IllegalAccessException e) {
                log.debug((Object)Messages.getMessage("errorinloadingts", clasName), (Throwable)e);
                throw new DeploymentException(e);
            }
            catch (InstantiationException e) {
                log.debug((Object)Messages.getMessage("errorinloadingts", clasName), (Throwable)e);
                throw new DeploymentException(e);
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("errorinloadingts", clasName), (Throwable)axisFault);
                throw new DeploymentException(axisFault);
            }
        }
    }

    private void processDataLocatorConfig(OMElement dataLocatorElement) {
        OMAttribute serviceOverallDataLocatorclass = dataLocatorElement.getAttribute(new QName("class"));
        if (serviceOverallDataLocatorclass != null) {
            String className = serviceOverallDataLocatorclass.getAttributeValue();
            this.axisConfig.addDataLocatorClassNames("GlobalLevel", className);
        }
        Iterator iterator = dataLocatorElement.getChildrenWithName(new QName("dialectLocator"));
        while (iterator.hasNext()) {
            OMElement locatorElement = (OMElement)iterator.next();
            OMAttribute dialect = locatorElement.getAttribute(new QName("dialect"));
            OMAttribute dialectclass = locatorElement.getAttribute(new QName("class"));
            this.axisConfig.addDataLocatorClassNames(dialect.getAttributeValue(), dialectclass.getAttributeValue());
        }
    }

    protected HashMap processMessageFormatters(OMElement messageFormattersElement) throws DeploymentException {
        try {
            return super.processMessageFormatters(messageFormattersElement);
        }
        catch (NoClassDefFoundError e) {
            if (this.deploymentEngine != null) {
                throw new DeploymentException(e);
            }
            return new HashMap();
        }
    }

    protected HashMap processMessageBuilders(OMElement messageBuildersElement) throws DeploymentException {
        try {
            return super.processMessageBuilders(messageBuildersElement);
        }
        catch (NoClassDefFoundError e) {
            if (this.deploymentEngine != null) {
                throw new DeploymentException(e);
            }
            return new HashMap();
        }
    }

    private Phase getPhase(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (className == null) {
            return new Phase();
        }
        Class phaseClass = Loader.loadClass(this.axisConfig.getSystemClassLoader(), className);
        return (Phase)phaseClass.newInstance();
    }
}

