/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.datagram;

import java.io.IOException;
import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.axis2.transport.base.datagram.DatagramDispatcher;
import org.apache.axis2.transport.base.datagram.DatagramDispatcherCallback;
import org.apache.axis2.transport.base.datagram.DatagramEndpoint;
import org.apache.axis2.transport.base.datagram.ProcessPacketTask;
import org.apache.axis2.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatagramTransportListener<E extends DatagramEndpoint>
extends AbstractTransportListenerEx<E> {
    private DatagramDispatcher<E> dispatcher;
    private String defaultIp;

    @Override
    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        super.init(cfgCtx, transportIn);
        DatagramDispatcherCallback callback = new DatagramDispatcherCallback(){

            public void receive(DatagramEndpoint endpoint, byte[] data, int length) {
                AbstractDatagramTransportListener.this.workerPool.execute(new ProcessPacketTask(endpoint, data, length));
            }
        };
        try {
            this.dispatcher = this.createDispatcher(callback);
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to create selector", ex);
        }
        try {
            this.defaultIp = Utils.getIpAddress(cfgCtx.getAxisConfiguration());
        }
        catch (SocketException ex) {
            throw new AxisFault("Unable to determine the host's IP address", ex);
        }
    }

    @Override
    protected final E createEndpoint() {
        E endpoint = this.doCreateEndpoint();
        ((DatagramEndpoint)endpoint).setMetrics(this.metrics);
        return endpoint;
    }

    protected abstract E doCreateEndpoint();

    @Override
    protected void startEndpoint(E endpoint) throws AxisFault {
        try {
            this.dispatcher.addEndpoint(endpoint);
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to listen on endpoint " + ((ProtocolEndpoint)endpoint).getEndpointReferences(this.defaultIp)[0], ex);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Started listening on endpoint " + ((ProtocolEndpoint)endpoint).getEndpointReferences(this.defaultIp)[0] + " [contentType=" + ((DatagramEndpoint)endpoint).getContentType() + "; service=" + ((ProtocolEndpoint)endpoint).getServiceName() + "]"));
        }
    }

    @Override
    protected void stopEndpoint(E endpoint) {
        try {
            this.dispatcher.removeEndpoint(endpoint);
        }
        catch (IOException ex) {
            this.log.error((Object)("I/O exception while stopping listener for service " + ((ProtocolEndpoint)endpoint).getServiceName()), (Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.dispatcher.stop();
        }
        catch (IOException ex) {
            this.log.error((Object)"Failed to stop dispatcher", (Throwable)ex);
        }
    }

    protected abstract DatagramDispatcher<E> createDispatcher(DatagramDispatcherCallback var1) throws IOException;
}

