/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.TextMessage;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSListener;
import org.apache.axis2.transport.jms.JMSMessageReceiver;
import org.apache.axis2.transport.jms.ServiceTaskManager;
import org.apache.axis2.transport.jms.ServiceTaskManagerFactory;
import org.apache.axis2.transport.jms.ctype.ContentTypeRuleFactory;
import org.apache.axis2.transport.jms.ctype.ContentTypeRuleSet;
import org.apache.axis2.transport.jms.ctype.MessageTypeRule;
import org.apache.axis2.transport.jms.ctype.PropertyRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSEndpoint
extends ProtocolEndpoint {
    private static final Log log = LogFactory.getLog(JMSEndpoint.class);
    private final JMSListener listener;
    private final WorkerPool workerPool;
    private JMSConnectionFactory cf;
    private String jndiDestinationName;
    private int destinationType = 0;
    private String jndiReplyDestinationName;
    private String replyDestinationType = "generic";
    private Set<EndpointReference> endpointReferences = new HashSet<EndpointReference>();
    private ContentTypeRuleSet contentTypeRuleSet;
    private ServiceTaskManager serviceTaskManager;

    public JMSEndpoint(JMSListener listener, WorkerPool workerPool) {
        this.listener = listener;
        this.workerPool = workerPool;
    }

    public String getJndiDestinationName() {
        return this.jndiDestinationName;
    }

    private void setDestinationType(String destinationType) {
        this.destinationType = "topic".equalsIgnoreCase(destinationType) ? 2 : ("queue".equalsIgnoreCase(destinationType) ? 1 : 0);
    }

    private void setReplyDestinationType(String destinationType) {
        this.replyDestinationType = "topic".equalsIgnoreCase(destinationType) ? "topic" : ("queue".equalsIgnoreCase(destinationType) ? "queue" : "generic");
    }

    public String getJndiReplyDestinationName() {
        return this.jndiReplyDestinationName;
    }

    public String getReplyDestinationType() {
        return this.replyDestinationType;
    }

    public EndpointReference[] getEndpointReferences(String ip) {
        return this.endpointReferences.toArray(new EndpointReference[this.endpointReferences.size()]);
    }

    private void computeEPRs() {
        ArrayList eprs = new ArrayList();
        for (Parameter o : this.getService().getParameters()) {
            Parameter p = o;
            if (!"transport.jms.PublishEPR".equals(p.getName()) || !(p.getValue() instanceof String)) continue;
            if ("legacy".equalsIgnoreCase((String)p.getValue())) {
                this.endpointReferences.add(new EndpointReference(this.getEPR()));
                continue;
            }
            this.endpointReferences.add(new EndpointReference((String)p.getValue()));
        }
        if (eprs.isEmpty()) {
            this.endpointReferences.add(new EndpointReference(this.getEPR()));
        }
    }

    private String getEPR() {
        String contentTypeProperty;
        StringBuffer sb = new StringBuffer();
        sb.append("jms:/").append(this.jndiDestinationName);
        sb.append("?").append("transport.jms.DestinationType").append("=").append(this.destinationType == 2 ? "topic" : "queue");
        if (this.contentTypeRuleSet != null && (contentTypeProperty = this.contentTypeRuleSet.getDefaultContentTypeProperty()) != null) {
            sb.append("&");
            sb.append("transport.jms.ContentTypeProperty");
            sb.append("=");
            sb.append(contentTypeProperty);
        }
        for (Map.Entry<String, String> entry : this.cf.getParameters().entrySet()) {
            if ("java.naming.security.principal".equalsIgnoreCase(entry.getKey()) || "java.naming.security.credentials".equalsIgnoreCase(entry.getKey()) || "transport.jms.UserName".equalsIgnoreCase(entry.getKey()) || "transport.jms.Password".equalsIgnoreCase(entry.getKey())) continue;
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public ContentTypeRuleSet getContentTypeRuleSet() {
        return this.contentTypeRuleSet;
    }

    public JMSConnectionFactory getCf() {
        return this.cf;
    }

    public ServiceTaskManager getServiceTaskManager() {
        return this.serviceTaskManager;
    }

    public void setServiceTaskManager(ServiceTaskManager serviceTaskManager) {
        this.serviceTaskManager = serviceTaskManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        if (!(params instanceof AxisService)) {
            return false;
        }
        AxisService service = (AxisService)params;
        this.cf = this.listener.getConnectionFactory(service);
        if (this.cf == null) {
            return false;
        }
        Parameter destParam = service.getParameter("transport.jms.Destination");
        this.jndiDestinationName = destParam != null ? (String)destParam.getValue() : service.getName();
        Parameter destTypeParam = service.getParameter("transport.jms.DestinationType");
        if (destTypeParam != null) {
            String paramValue = (String)destTypeParam.getValue();
            if (!"queue".equals(paramValue) && !"topic".equals(paramValue)) throw new AxisFault("Invalid destinaton type value " + paramValue);
            this.setDestinationType(paramValue);
        } else {
            log.debug((Object)"JMS destination type not given. default queue");
            this.destinationType = 1;
        }
        Parameter replyDestTypeParam = service.getParameter("transport.jms.ReplyDestinationType");
        if (replyDestTypeParam != null) {
            String paramValue = (String)replyDestTypeParam.getValue();
            if (!"queue".equals(paramValue) && !"topic".equals(paramValue)) throw new AxisFault("Invalid destinaton type value " + paramValue);
            this.setReplyDestinationType(paramValue);
        } else {
            log.debug((Object)"JMS reply destination type not given. default queue");
            this.destinationType = 1;
        }
        this.jndiReplyDestinationName = ParamUtils.getOptionalParam(service, "transport.jms.ReplyDestination");
        Parameter contentTypeParam = service.getParameter("transport.jms.ContentType");
        if (contentTypeParam == null) {
            this.contentTypeRuleSet = new ContentTypeRuleSet();
            this.contentTypeRuleSet.addRule(new PropertyRule("Content-Type"));
            this.contentTypeRuleSet.addRule(new MessageTypeRule(BytesMessage.class, "application/octet-stream"));
            this.contentTypeRuleSet.addRule(new MessageTypeRule(TextMessage.class, "text/plain"));
        } else {
            this.contentTypeRuleSet = ContentTypeRuleFactory.parse(contentTypeParam);
        }
        this.computeEPRs();
        this.serviceTaskManager = ServiceTaskManagerFactory.createTaskManagerForService(this.cf, service, this.workerPool);
        this.serviceTaskManager.setJmsMessageReceiver(new JMSMessageReceiver(this.listener, this.cf, this));
        return true;
    }
}

