/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.extension.AbstractCodeGenerationExtension;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class JAXWSWapperExtension
extends AbstractCodeGenerationExtension {
    private CodeGenConfiguration codeGenConfiguration;

    public void engage(CodeGenConfiguration configuration) throws CodeGenerationException {
        this.codeGenConfiguration = configuration;
        if (!this.codeGenConfiguration.isParametersWrapped() && this.codeGenConfiguration.getOutputLanguage().equals("jax-ws")) {
            List services = configuration.getAxisServices();
            Iterator servicesIter = services.iterator();
            while (servicesIter.hasNext()) {
                AxisService axisService = (AxisService)servicesIter.next();
                Iterator<AxisOperation> operations = axisService.getOperations();
                while (operations.hasNext()) {
                    AxisOperation op = operations.next();
                    boolean wrappable = true;
                    if (WSDLUtil.isInputPresentForMEP(op.getMessageExchangePattern())) {
                        AxisMessage message = op.getMessage("In");
                        XmlSchemaElement schemaElement = message.getSchemaElement();
                        String opName = ((AxisOperation)message.getParent()).getName().getLocalPart();
                        if (!schemaElement.getName().equals(opName)) {
                            return;
                        }
                        wrappable = this.walkSchema(op.getMessage("In"), "_input");
                    }
                    if (!WSDLUtil.isOutputPresentForMEP(op.getMessageExchangePattern()) || !wrappable) continue;
                    this.walkSchema(op.getMessage("Out"), "_output");
                }
            }
        }
    }

    public boolean walkSchema(AxisMessage message, String qnameSuffix) throws CodeGenerationException {
        if (message.getSchemaElement() == null) {
            return false;
        }
        LinkedList partNameList = new LinkedList();
        XmlSchemaElement schemaElement = message.getSchemaElement();
        XmlSchemaType schemaType = schemaElement.getSchemaType();
        QName schemaTypeQname = schemaElement.getSchemaTypeName();
        if (schemaType == null && schemaTypeQname != null) {
            AxisService axisService = (AxisService)message.getParent().getParent();
            ArrayList<XmlSchema> schemasList = axisService.getSchema();
            XmlSchema schema = null;
            Iterator<XmlSchema> iter = schemasList.iterator();
            while (iter.hasNext() && (schemaType = this.getSchemaType(schema = iter.next(), schemaTypeQname)) == null) {
            }
        }
        if (schemaType instanceof XmlSchemaComplexType) {
            if (!this.handleAllCasesOfComplexTypes(schemaType, message, partNameList, qnameSuffix)) {
                return false;
            }
        } else {
            return false;
        }
        try {
            message.addParameter(this.getParameter("UnWrapped", Boolean.TRUE));
            MessagePartInformationHolder infoHolder = new MessagePartInformationHolder();
            infoHolder.setOperationName(((AxisOperation)message.getParent()).getName());
            infoHolder.setPartsList(partNameList);
            message.addParameter(this.getParameter("UnWrapped_details", infoHolder));
        }
        catch (AxisFault axisFault) {
            throw new CodeGenerationException(axisFault);
        }
        return true;
    }

    private Parameter getParameter(String key, Object value) {
        Parameter myParameter = new Parameter();
        myParameter.setName(key);
        myParameter.setValue(value);
        return myParameter;
    }

    private XmlSchemaType getSchemaType(XmlSchema schema, QName typeName) {
        XmlSchemaObjectCollection includes;
        XmlSchemaType xmlSchemaType = null;
        if (schema != null && (xmlSchemaType = schema.getTypeByName(typeName)) == null && (includes = schema.getIncludes()) != null) {
            Iterator includesIter = includes.getIterator();
            Object object = null;
            while (includesIter.hasNext()) {
                XmlSchema schema1;
                object = includesIter.next();
                if (object instanceof XmlSchemaImport) {
                    schema1 = ((XmlSchemaImport)object).getSchema();
                    xmlSchemaType = this.getSchemaType(schema1, typeName);
                }
                if (object instanceof XmlSchemaInclude) {
                    schema1 = ((XmlSchemaInclude)object).getSchema();
                    xmlSchemaType = this.getSchemaType(schema1, typeName);
                }
                if (xmlSchemaType == null) continue;
                break;
            }
        }
        return xmlSchemaType;
    }

    private boolean handleAllCasesOfComplexTypes(XmlSchemaType schemaType, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType cmplxType = (XmlSchemaComplexType)schemaType;
            XmlSchemaObjectCollection xmlObjectCollection = cmplxType.getAttributes();
            if (xmlObjectCollection.getCount() != 0) {
                return false;
            }
            if (cmplxType.getContentModel() == null) {
                if (cmplxType.getParticle() != null) {
                    return this.processXMLSchemaSequence(cmplxType.getParticle(), message, partNameList, qnameSuffix);
                }
            } else {
                return this.processComplexContentModel(cmplxType, message, partNameList, qnameSuffix);
            }
        }
        return false;
    }

    private boolean processComplexContentModel(XmlSchemaComplexType cmplxType, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        return false;
    }

    private boolean processXMLSchemaSequence(XmlSchemaParticle schemaParticle, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        if (schemaParticle instanceof XmlSchemaSequence) {
            QName opName = ((AxisOperation)message.getParent()).getName();
            XmlSchemaSequence sequence = (XmlSchemaSequence)schemaParticle;
            XmlSchemaObjectCollection items = sequence.getItems();
            if (items.getCount() == 0) {
                return true;
            }
            Iterator i = items.getIterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (item instanceof XmlSchemaElement) {
                    XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)item;
                    XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                    String partName = null;
                    partName = xmlSchemaElement.getRefName() != null ? xmlSchemaElement.getRefName().getLocalPart() : xmlSchemaElement.getName();
                    partNameList.add(WSDLUtil.getPartQName(opName.getLocalPart(), qnameSuffix, partName));
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

