/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.codegen.schema.NamespacePrefix;
import org.apache.axis2.wsdl.codegen.schema.TopElement;
import org.apache.axis2.wsdl.codegen.schema.XmlComplexType;
import org.apache.axis2.wsdl.codegen.schema.XmlElement;
import org.apache.axis2.wsdl.codegen.schema.XmlImport;
import org.apache.axis2.wsdl.codegen.schema.XmlSchema;
import org.apache.axis2.wsdl.codegen.schema.exception.DummySchemaGenerationException;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisServiceTopElementSchemaGenerator {
    private AxisService axisService;

    public AxisServiceTopElementSchemaGenerator(AxisService service) {
        this.axisService = service;
    }

    public List getDummySchemaList() throws DummySchemaGenerationException {
        Set topElements = this.getTopElements();
        Map schemaMap = this.getSchemaMap(topElements);
        return this.getXmlSchemaList(schemaMap);
    }

    public List getXmlSchemaList(Map schemaMap) throws DummySchemaGenerationException {
        ArrayList<org.apache.ws.commons.schema.XmlSchema> xmlSchemaList = new ArrayList<org.apache.ws.commons.schema.XmlSchema>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Iterator iter = schemaMap.values().iterator();
            while (iter.hasNext()) {
                XmlSchema xmlSchema = (XmlSchema)iter.next();
                Element element = xmlSchema.getSchemaElement(document);
                XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
                xmlSchemaList.add(xmlSchemaCollection.read(element));
            }
        }
        catch (ParserConfigurationException e) {
            throw new DummySchemaGenerationException("Can not build the dom tree", e);
        }
        return xmlSchemaList;
    }

    public Map getSchemaMap(Set topElements) {
        HashMap schemaMap = new HashMap();
        NamespacePrefix namespacePrefix = new NamespacePrefix();
        Iterator iter = topElements.iterator();
        while (iter.hasNext()) {
            TopElement topElement = (TopElement)iter.next();
            XmlSchema xmlSchema = this.getXmlSchemaForNamespace(topElement.getElementQName().getNamespaceURI(), schemaMap);
            if (xmlSchema.isElementExists(topElement.getElementQName().getLocalPart())) continue;
            if (topElement.getTypeQName() == null) {
                xmlSchema.addElement(this.getXmlElement(topElement));
                continue;
            }
            if (topElement.getTypeQName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                xmlSchema.addElement(this.getXmlElement(topElement));
                continue;
            }
            XmlSchema complexElementSchema = this.getXmlSchemaForNamespace(topElement.getTypeQName().getNamespaceURI(), schemaMap);
            if (!complexElementSchema.isComplexTypeExists(topElement.getTypeQName().getLocalPart())) {
                XmlComplexType xmlComplexType = new XmlComplexType();
                xmlComplexType.setName(topElement.getTypeQName().getLocalPart());
                xmlComplexType.setNamespace(topElement.getTypeQName().getNamespaceURI());
                complexElementSchema.addComplexType(xmlComplexType);
            }
            if (!xmlSchema.getNamespacesPrefixMap().containsKey(topElement.getTypeQName().getNamespaceURI())) {
                xmlSchema.getNamespacesPrefixMap().put(topElement.getTypeQName().getNamespaceURI(), namespacePrefix.getNextNamespacePrefix());
                XmlImport xmlImport = new XmlImport();
                xmlImport.setTargetNamespace(topElement.getTypeQName().getNamespaceURI());
                xmlSchema.addImport(xmlImport);
            }
            xmlSchema.addElement(this.getXmlElement(topElement));
        }
        return schemaMap;
    }

    private XmlElement getXmlElement(TopElement topElement) {
        XmlElement xmlElement = new XmlElement();
        xmlElement.setName(topElement.getElementQName().getLocalPart());
        xmlElement.setNamespace(topElement.getElementQName().getNamespaceURI());
        xmlElement.setType(topElement.getTypeQName());
        return xmlElement;
    }

    private XmlSchema getXmlSchemaForNamespace(String targetNamespace, Map schemaMap) {
        if (!schemaMap.containsKey(targetNamespace)) {
            XmlSchema xmlSchema = new XmlSchema(targetNamespace);
            schemaMap.put(targetNamespace, xmlSchema);
        }
        return (XmlSchema)schemaMap.get(targetNamespace);
    }

    public Set getTopElements() {
        HashSet<TopElement> topSchemaElements = new HashSet<TopElement>();
        Iterator<AxisOperation> operationIter = this.axisService.getOperations();
        while (operationIter.hasNext()) {
            XmlSchemaElement xmlSchemaElement;
            TopElement topElement;
            AxisMessage axisMessage;
            AxisOperation axisOperation = operationIter.next();
            Iterator<AxisMessage> messageIter = axisOperation.getMessages();
            while (messageIter.hasNext()) {
                axisMessage = messageIter.next();
                topElement = new TopElement(axisMessage.getElementQName());
                xmlSchemaElement = axisMessage.getSchemaElement();
                topElement.setTypeQName(xmlSchemaElement.getSchemaTypeName());
                topSchemaElements.add(topElement);
                Iterator soapHeaderIter = axisMessage.getSoapHeaders().iterator();
                while (soapHeaderIter.hasNext()) {
                    SOAPHeaderMessage soapHeaderMessage = (SOAPHeaderMessage)soapHeaderIter.next();
                    topElement = new TopElement(soapHeaderMessage.getElement());
                    topSchemaElements.add(topElement);
                    xmlSchemaElement = this.getSchemaElement(soapHeaderMessage.getElement());
                    topElement.setTypeQName(xmlSchemaElement.getSchemaTypeName());
                    topSchemaElements.add(topElement);
                }
            }
            Iterator<AxisMessage> faultMessagesIter = axisOperation.getFaultMessages().iterator();
            while (faultMessagesIter.hasNext()) {
                axisMessage = faultMessagesIter.next();
                topElement = new TopElement(axisMessage.getElementQName());
                xmlSchemaElement = axisMessage.getSchemaElement();
                topElement.setTypeQName(xmlSchemaElement.getSchemaTypeName());
                topSchemaElements.add(topElement);
            }
        }
        return topSchemaElements;
    }

    public XmlSchemaElement getSchemaElement(QName elementQName) {
        XmlSchemaElement xmlSchemaElement = null;
        ArrayList<org.apache.ws.commons.schema.XmlSchema> schemas = this.axisService.getSchema();
        Iterator<org.apache.ws.commons.schema.XmlSchema> schemaIter = schemas.iterator();
        while (schemaIter.hasNext() && (xmlSchemaElement = this.getSchemaElement(schemaIter.next(), elementQName)) == null) {
        }
        return xmlSchemaElement;
    }

    private XmlSchemaElement getSchemaElement(org.apache.ws.commons.schema.XmlSchema schema, QName elementQName) {
        XmlSchemaObjectCollection includes;
        XmlSchemaElement xmlSchemaElement = null;
        if (schema != null && (xmlSchemaElement = schema.getElementByName(elementQName)) == null && (includes = schema.getIncludes()) != null) {
            Iterator includesIter = includes.getIterator();
            while (includesIter.hasNext()) {
                org.apache.ws.commons.schema.XmlSchema schema1;
                Object object = includesIter.next();
                if (object instanceof XmlSchemaImport) {
                    schema1 = ((XmlSchemaImport)object).getSchema();
                    xmlSchemaElement = this.getSchemaElement(schema1, elementQName);
                }
                if (object instanceof XmlSchemaInclude) {
                    schema1 = ((XmlSchemaInclude)object).getSchema();
                    xmlSchemaElement = this.getSchemaElement(schema1, elementQName);
                }
                if (xmlSchemaElement == null) continue;
                break;
            }
        }
        return xmlSchemaElement;
    }
}

