/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public abstract class AbstractMessageParser
implements NHttpMessageParser {
    private final SessionInputBuffer sessionBuffer;
    private static final int READ_HEAD_LINE = 0;
    private static final int READ_HEADERS = 1;
    private static final int COMPLETED = 2;
    private int state;
    private boolean endOfStream;
    private HttpMessage message;
    private CharArrayBuffer lineBuf;
    private final List<CharArrayBuffer> headerBufs;
    private int maxLineLen = -1;
    private int maxHeaderCount = -1;
    protected final LineParser lineParser;

    public AbstractMessageParser(SessionInputBuffer buffer, LineParser parser, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sessionBuffer = buffer;
        this.state = 0;
        this.endOfStream = false;
        this.headerBufs = new ArrayList<CharArrayBuffer>();
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
        this.lineParser = parser != null ? parser : BasicLineParser.DEFAULT;
    }

    public void reset() {
        this.state = 0;
        this.endOfStream = false;
        this.headerBufs.clear();
        this.message = null;
    }

    public int fillBuffer(ReadableByteChannel channel) throws IOException {
        int bytesRead = this.sessionBuffer.fill(channel);
        if (bytesRead == -1) {
            this.endOfStream = true;
        }
        return bytesRead;
    }

    protected abstract HttpMessage createMessage(CharArrayBuffer var1) throws HttpException, ParseException;

    private void parseHeadLine() throws HttpException, ParseException {
        this.message = this.createMessage(this.lineBuf);
    }

    private void parseHeader() throws IOException {
        CharArrayBuffer current = this.lineBuf;
        int count = this.headerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && count > 0) {
            char ch;
            int i;
            CharArrayBuffer previous = this.headerBufs.get(count - 1);
            for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
            }
            if (this.maxLineLen > 0 && previous.length() + 1 + current.length() - i > this.maxLineLen) {
                throw new IOException("Maximum line length limit exceeded");
            }
            previous.append(' ');
            previous.append(current, i, current.length() - i);
        } else {
            this.headerBufs.add(current);
            this.lineBuf = null;
        }
    }

    public HttpMessage parse() throws IOException, HttpException {
        while (this.state != 2) {
            if (this.lineBuf == null) {
                this.lineBuf = new CharArrayBuffer(64);
            } else {
                this.lineBuf.clear();
            }
            boolean lineComplete = this.sessionBuffer.readLine(this.lineBuf, this.endOfStream);
            if (this.maxLineLen > 0 && (this.lineBuf.length() > this.maxLineLen || !lineComplete && this.sessionBuffer.length() > this.maxLineLen)) {
                throw new IOException("Maximum line length limit exceeded");
            }
            if (!lineComplete) break;
            switch (this.state) {
                case 0: {
                    try {
                        this.parseHeadLine();
                    }
                    catch (ParseException px) {
                        throw new ProtocolException(px.getMessage(), px);
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (this.lineBuf.length() > 0) {
                        if (this.maxHeaderCount > 0 && this.headerBufs.size() >= this.maxHeaderCount) {
                            throw new IOException("Maximum header count exceeded");
                        }
                        this.parseHeader();
                        break;
                    }
                    this.state = 2;
                }
            }
            if (!this.endOfStream || this.sessionBuffer.hasData()) continue;
            this.state = 2;
        }
        if (this.state == 2) {
            for (int i = 0; i < this.headerBufs.size(); ++i) {
                CharArrayBuffer buffer = this.headerBufs.get(i);
                try {
                    this.message.addHeader(this.lineParser.parseHeader(buffer));
                    continue;
                }
                catch (ParseException ex) {
                    throw new ProtocolException(ex.getMessage(), ex);
                }
            }
            return this.message;
        }
        return null;
    }
}

