/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.apache.http.impl.nio.reactor.BaseIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.ExceptionEvent;
import org.apache.http.nio.params.NIOReactorParams;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    protected volatile IOReactorStatus status;
    protected final HttpParams params;
    protected final Selector selector;
    protected final long selectTimeout;
    private final int workerCount;
    private final ThreadFactory threadFactory;
    private final BaseIOReactor[] dispatchers;
    private final Worker[] workers;
    private final Thread[] threads;
    private final Object statusLock;
    protected IOReactorExceptionHandler exceptionHandler;
    protected List<ExceptionEvent> auditLog;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        if (workerCount <= 0) {
            throw new IllegalArgumentException("Worker count may not be negative or zero");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
        this.params = params;
        this.selectTimeout = NIOReactorParams.getSelectInterval(params);
        this.statusLock = new Object();
        this.workerCount = workerCount;
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.dispatchers = new BaseIOReactor[workerCount];
        this.workers = new Worker[workerCount];
        this.threads = new Thread[workerCount];
        this.status = IOReactorStatus.INACTIVE;
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status;
    }

    public synchronized List<ExceptionEvent> getAuditLog() {
        if (this.auditLog != null) {
            return new ArrayList<ExceptionEvent>(this.auditLog);
        }
        return null;
    }

    protected synchronized void addExceptionEvent(Throwable ex, Date timestamp) {
        if (ex == null) {
            return;
        }
        if (timestamp == null) {
            timestamp = new Date();
        }
        if (this.auditLog == null) {
            this.auditLog = new ArrayList<ExceptionEvent>();
        }
        this.auditLog.add(new ExceptionEvent(ex, timestamp));
    }

    protected void addExceptionEvent(Throwable ex) {
        this.addExceptionEvent(ex, null);
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected abstract void processEvents(int var1) throws IOReactorException;

    protected abstract void cancelRequests() throws IOReactorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        int i;
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        Object object = this.statusLock;
        synchronized (object) {
            BaseIOReactor dispatcher;
            if (this.status.compareTo(IOReactorStatus.SHUTDOWN_REQUEST) >= 0) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.statusLock.notifyAll();
                return;
            }
            if (this.status.compareTo(IOReactorStatus.INACTIVE) != 0) {
                throw new IllegalStateException("Illegal state: " + (Object)((Object)this.status));
            }
            this.status = IOReactorStatus.ACTIVE;
            for (i = 0; i < this.dispatchers.length; ++i) {
                dispatcher = new BaseIOReactor(this.selectTimeout);
                dispatcher.setExceptionHandler(this.exceptionHandler);
                this.dispatchers[i] = dispatcher;
            }
            for (i = 0; i < this.workerCount; ++i) {
                dispatcher = this.dispatchers[i];
                this.workers[i] = new Worker(dispatcher, eventDispatch);
                this.threads[i] = this.threadFactory.newThread(this.workers[i]);
            }
        }
        try {
            for (int i2 = 0; i2 < this.workerCount; ++i2) {
                if (this.status != IOReactorStatus.ACTIVE) {
                    return;
                }
                this.threads[i2].start();
            }
            block29: while (true) {
                int readyCount;
                try {
                    readyCount = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status.compareTo(IOReactorStatus.ACTIVE) > 0) {
                    break;
                }
                this.processEvents(readyCount);
                i = 0;
                while (true) {
                    Exception ex;
                    if (i >= this.workerCount) continue block29;
                    Worker worker = this.workers[i];
                    Thread thread = this.threads[i];
                    if (!thread.isAlive() && (ex = worker.getException()) != null) {
                        throw new IOReactorException("I/O dispatch worker terminated abnormally", ex);
                    }
                    ++i;
                }
                break;
            }
        }
        catch (ClosedSelectorException ex) {
            this.addExceptionEvent(ex);
        }
        catch (IOReactorException ex) {
            if (ex.getCause() != null) {
                this.addExceptionEvent(ex.getCause());
            }
            throw ex;
        }
        finally {
            Object ex = this.statusLock;
            synchronized (ex) {
                this.doShutdown();
                this.status = IOReactorStatus.SHUT_DOWN;
                this.statusLock.notifyAll();
            }
        }
    }

    protected void doShutdown() throws InterruptedIOException {
        block17: {
            if (this.status.compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
                return;
            }
            this.status = IOReactorStatus.SHUTTING_DOWN;
            try {
                this.cancelRequests();
            }
            catch (IOReactorException ex) {
                if (ex.getCause() == null) break block17;
                this.addExceptionEvent(ex.getCause());
            }
        }
        this.selector.wakeup();
        if (this.selector.isOpen()) {
            Set<SelectionKey> keys = this.selector.keys();
            Iterator<SelectionKey> it = keys.iterator();
            while (it.hasNext()) {
                try {
                    SelectionKey key = it.next();
                    SelectableChannel channel = key.channel();
                    if (channel == null) continue;
                    channel.close();
                }
                catch (IOException ex) {
                    this.addExceptionEvent(ex);
                }
            }
            try {
                this.selector.close();
            }
            catch (IOException ex) {
                this.addExceptionEvent(ex);
            }
        }
        for (int i = 0; i < this.workerCount; ++i) {
            BaseIOReactor dispatcher = this.dispatchers[i];
            dispatcher.gracefulShutdown();
        }
        long gracePeriod = NIOReactorParams.getGracePeriod(this.params);
        try {
            int i;
            for (i = 0; i < this.workerCount; ++i) {
                BaseIOReactor dispatcher = this.dispatchers[i];
                if (dispatcher.getStatus() != IOReactorStatus.INACTIVE) {
                    dispatcher.awaitShutdown(gracePeriod);
                }
                if (dispatcher.getStatus() == IOReactorStatus.SHUT_DOWN) continue;
                try {
                    dispatcher.hardShutdown();
                    continue;
                }
                catch (IOReactorException ex) {
                    if (ex.getCause() == null) continue;
                    this.addExceptionEvent(ex.getCause());
                }
            }
            for (i = 0; i < this.workerCount; ++i) {
                Thread t = this.threads[i];
                if (t == null) continue;
                t.join(gracePeriod);
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException(ex.getMessage());
        }
    }

    protected void addChannel(ChannelEntry entry) {
        int i = Math.abs(this.currentWorker++ % this.workerCount);
        this.dispatchers[i].addChannel(entry);
    }

    protected SelectionKey registerChannel(SelectableChannel channel, int ops) throws ClosedChannelException {
        return channel.register(this.selector, ops);
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(this.params));
        int linger = HttpConnectionParams.getLinger(this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitShutdown(long timeout) throws InterruptedException {
        Object object = this.statusLock;
        synchronized (object) {
            long deadline = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.status != IOReactorStatus.SHUT_DOWN) {
                this.statusLock.wait(remaining);
                if (timeout <= 0L || (remaining = deadline - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long waitMs) throws IOException {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status.compareTo(IOReactorStatus.ACTIVE) > 0) {
                return;
            }
            this.status = IOReactorStatus.SHUTDOWN_REQUEST;
            this.selector.wakeup();
            try {
                this.awaitShutdown(waitMs);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static volatile int COUNT = 0;

        DefaultThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "I/O dispatcher " + ++COUNT);
        }
    }

    static class Worker
    implements Runnable {
        final BaseIOReactor dispatcher;
        final IOEventDispatch eventDispatch;
        private volatile Exception exception;

        public Worker(BaseIOReactor dispatcher, IOEventDispatch eventDispatch) {
            this.dispatcher = dispatcher;
            this.eventDispatch = eventDispatch;
        }

        public void run() {
            try {
                this.dispatcher.execute(this.eventDispatch);
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

