/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.HttpsToken;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyBasedResultsValidator
implements PolicyValidatorCallbackHandler {
    private static Log log = LogFactory.getLog((Class)PolicyBasedResultsValidator.class);

    public void validate(ValidatorData data, Vector results) throws RampartException {
        Timestamp timestamp;
        X509Certificate returnCert;
        WSSecurityEngineResult actionResult;
        String incomingTransport;
        RampartMessageData rmd = data.getRampartMessageData();
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd != null && results == null) {
            throw new RampartException("noSecurityResults");
        }
        WSSecurityEngineResult tsResult = null;
        if (rpd != null && rpd.isIncludeTimestamp() && (tsResult = WSSecurityUtil.fetchActionResult(results, 32)) == null) {
            throw new RampartException("timestampMissing");
        }
        Vector encryptedParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd != null && rpd.isSignatureProtection() && this.isSignatureRequired(rmd)) {
            String sigId = RampartUtil.getSigElementId(rmd);
            encryptedParts.add(new WSEncryptionPart("Signature", "http://www.w3.org/2000/09/xmldsig#", "Element"));
        }
        Vector signatureParts = RampartUtil.getSignedParts(rmd);
        if (rpd != null && rpd.isIncludeTimestamp() && !rpd.isTransportBinding()) {
            signatureParts.add(new WSEncryptionPart("timestamp"));
        }
        if (!rmd.isInitiator()) {
            SignedEncryptedParts sgndEndSignedParts;
            SupportingToken sgndEndSupportingToken;
            SignedEncryptedParts endSignedParts;
            SupportingToken endSupportingToken = rpd.getEndorsingSupportingTokens();
            if (endSupportingToken != null && ((endSignedParts = endSupportingToken.getSignedParts()) != null && (endSignedParts.isBody() || endSignedParts.getHeaders().size() > 0) || rpd.isIncludeTimestamp())) {
                signatureParts.add(new WSEncryptionPart("EndorsingSupportingTokens"));
            }
            if ((sgndEndSupportingToken = rpd.getSignedEndorsingSupportingTokens()) != null && ((sgndEndSignedParts = sgndEndSupportingToken.getSignedParts()) != null && (sgndEndSignedParts.isBody() || sgndEndSignedParts.getHeaders().size() > 0) || rpd.isIncludeTimestamp())) {
                signatureParts.add(new WSEncryptionPart("SignedEndorsingSupportingTokens"));
            }
        }
        this.validateEncrSig(data, encryptedParts, signatureParts, results);
        if (!rpd.isTransportBinding()) {
            this.validateProtectionOrder(data, results);
        }
        if (rpd.isTransportBinding() && !rmd.isInitiator() && rpd.getTransportToken() instanceof HttpsToken && !(incomingTransport = rmd.getMsgContext().getIncomingTransportName()).equals("https")) {
            throw new RampartException("invalidTransport", new String[]{incomingTransport});
        }
        this.validateEncryptedParts(data, encryptedParts, results);
        this.validateSignedPartsHeaders(data, signatureParts, results);
        this.validateRequiredElements(data);
        if (!rmd.isInitiator()) {
            this.validateSupportingTokens(data, results);
        }
        if ((actionResult = WSSecurityUtil.fetchActionResult(results, 2)) != null && (returnCert = (X509Certificate)actionResult.get("x509-certificate")) != null && !this.verifyTrust(returnCert, rmd)) {
            throw new RampartException("trustVerificationError");
        }
        actionResult = WSSecurityUtil.fetchActionResult(results, 32);
        if (actionResult != null && (timestamp = (Timestamp)actionResult.get("timestamp")) != null && !this.verifyTimestamp(timestamp, rmd)) {
            throw new RampartException("cannotValidateTimestamp");
        }
    }

    protected void validateEncrSig(ValidatorData data, Vector encryptedParts, Vector signatureParts, Vector results) throws RampartException {
        ArrayList actions = this.getSigEncrActions(results);
        boolean sig = false;
        boolean encr = false;
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            Integer act = (Integer)iter.next();
            if (act == 2) {
                sig = true;
                continue;
            }
            if (act != 4) continue;
            encr = true;
        }
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        SupportingToken sgndSupTokens = rpd.getSignedSupportingTokens();
        SupportingToken sgndEndorSupTokens = rpd.getSignedEndorsingSupportingTokens();
        if (!(!sig || signatureParts.size() != 0 || sgndSupTokens != null && sgndSupTokens.getTokens().size() != 0 || sgndEndorSupTokens != null && sgndEndorSupTokens.getTokens().size() != 0)) {
            throw new RampartException("unexprectedSignature");
        }
        if (!sig && signatureParts.size() > 0) {
            throw new RampartException("signatureMissing");
        }
        if (encr && encryptedParts.size() == 0) {
            ArrayList list = this.getResults(results, 4);
            boolean encrDataFound = false;
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                WSSecurityEngineResult result = (WSSecurityEngineResult)iter2.next();
                ArrayList dataRefURIs = (ArrayList)result.get("data-ref-uris");
                if (dataRefURIs == null || dataRefURIs.size() == 0) continue;
                encrDataFound = true;
            }
            if (encrDataFound && !this.isUsernameTokenPresent(data)) {
                throw new RampartException("unexprectedEncryptedPart");
            }
        } else if (!encr && encryptedParts.size() > 0) {
            throw new RampartException("encryptionMissing");
        }
    }

    protected void validateSupportingTokens(ValidatorData data, Vector results) throws RampartException {
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        SupportingToken suppTok = rpd.getSupportingTokens();
        this.handleSupportingTokens(results, suppTok);
        SupportingToken signedSuppToken = rpd.getSignedSupportingTokens();
        this.handleSupportingTokens(results, signedSuppToken);
        SupportingToken signedEndSuppToken = rpd.getSignedEndorsingSupportingTokens();
        this.handleSupportingTokens(results, signedEndSuppToken);
        SupportingToken endSuppToken = rpd.getEndorsingSupportingTokens();
        this.handleSupportingTokens(results, endSuppToken);
    }

    protected void handleSupportingTokens(Vector results, SupportingToken suppTok) throws RampartException {
        if (suppTok == null) {
            return;
        }
        ArrayList tokens = suppTok.getTokens();
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            WSSecurityEngineResult x509Result;
            Token token = (Token)iter.next();
            if (token instanceof UsernameToken) {
                WSSecurityEngineResult utResult = WSSecurityUtil.fetchActionResult(results, 1);
                if (utResult != null) continue;
                throw new RampartException("usernameTokenMissing");
            }
            if (token instanceof IssuedToken) {
                WSSecurityEngineResult samlResult = WSSecurityUtil.fetchActionResult(results, 8);
                if (samlResult != null) continue;
                throw new RampartException("samlTokenMissing");
            }
            if (!(token instanceof X509Token) || (x509Result = WSSecurityUtil.fetchActionResult(results, 4096)) != null) continue;
            throw new RampartException("binaryTokenMissing");
        }
    }

    protected void validateProtectionOrder(ValidatorData data, Vector results) throws RampartException {
        String protectionOrder = data.getRampartMessageData().getPolicyData().getProtectionOrder();
        ArrayList sigEncrActions = this.getSigEncrActions(results);
        if (sigEncrActions.size() < 2) {
            return;
        }
        boolean sigNotPresent = true;
        boolean encrNotPresent = true;
        Iterator iter = sigEncrActions.iterator();
        while (iter.hasNext()) {
            Integer act = (Integer)iter.next();
            if (act == 2) {
                sigNotPresent = false;
                continue;
            }
            if (act != 4) continue;
            encrNotPresent = false;
        }
        if (sigNotPresent || encrNotPresent) {
            return;
        }
        boolean done = false;
        if ("SignBeforeEncrypting".equals(protectionOrder)) {
            Integer act;
            boolean sigFound = false;
            Iterator iter2 = sigEncrActions.iterator();
            while (!(!iter2.hasNext() && done || (act = (Integer)iter2.next()) == 4 && !sigFound)) {
                if (act == 2) {
                    sigFound = true;
                    continue;
                }
                if (!sigFound) continue;
                done = true;
            }
        } else {
            Integer act;
            boolean encrFound = false;
            Iterator iter3 = sigEncrActions.iterator();
            while (iter3.hasNext() && ((act = (Integer)iter3.next()) != 2 || encrFound)) {
                if (act == 4) {
                    encrFound = true;
                    continue;
                }
                if (!encrFound) continue;
                done = true;
            }
        }
        if (!done) {
            throw new RampartException("protectionOrderMismatch");
        }
    }

    protected ArrayList getSigEncrActions(Vector results) {
        ArrayList<Integer> sigEncrActions = new ArrayList<Integer>();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            Integer actInt = (Integer)((WSSecurityEngineResult)iter.next()).get("action");
            int action = actInt;
            if (2 != action && 4 != action) continue;
            sigEncrActions.add(action);
        }
        return sigEncrActions;
    }

    protected void validateEncryptedParts(ValidatorData data, Vector encryptedParts, Vector results) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        ArrayList encrRefs = this.getEncryptedReferences(results);
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isEncryptBody() && !this.isRefIdPresent(encrRefs, data.getBodyEncrDataId())) {
            throw new RampartException("encryptedPartMissing", new String[]{data.getBodyEncrDataId()});
        }
        for (int i = 0; i < encryptedParts.size(); ++i) {
            WSEncryptionPart encPart = (WSEncryptionPart)encryptedParts.get(i);
            if (encPart.getType() == 2) continue;
            if ("Signature".equals(encPart.getName()) && "http://www.w3.org/2000/09/xmldsig#".equals(encPart.getNamespace()) || encPart.getType() == 1) {
                if (this.isRefIdPresent(encrRefs, new QName(encPart.getNamespace(), encPart.getName()))) continue;
                throw new RampartException("encryptedPartMissing", new String[]{encPart.getNamespace() + ":" + encPart.getName()});
            }
            if (encPart.getEncId() == null) {
                throw new RampartException("encryptedPartMissing", new String[]{encPart.getNamespace() + ":" + encPart.getName()});
            }
            if (this.isRefIdPresent(encrRefs, encPart.getEncId())) continue;
            throw new RampartException("encryptedPartMissing", new String[]{encPart.getNamespace() + ":" + encPart.getName()});
        }
    }

    public void validateRequiredElements(ValidatorData data) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        Iterator elementsIter = rpd.getRequiredElements().iterator();
        while (elementsIter.hasNext()) {
            String expression = (String)elementsIter.next();
            if (RampartUtil.checkRequiredElements(envelope, rpd.getDeclaredNamespaces(), expression)) continue;
            throw new RampartException("requiredElementsMissing", new String[]{expression});
        }
    }

    protected void validateSignedPartsHeaders(ValidatorData data, Vector signatureParts, Vector results) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        Node envelope = rmd.getDocument().getFirstChild();
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, 2);
        Vector<Element> actuallySigned = new Vector<Element>();
        if (actionResult != null) {
            Set signedIDs = (Set)actionResult.get("signed-element-ids");
            Iterator i = signedIDs.iterator();
            while (i.hasNext()) {
                String e = (String)i.next();
                Element element = WSSecurityUtil.findElementById(envelope, e, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                actuallySigned.add(element);
            }
        }
        for (int i = 0; i < signatureParts.size(); ++i) {
            WSEncryptionPart wsep = (WSEncryptionPart)signatureParts.get(i);
            Element headerElement = (Element)WSSecurityUtil.findElement(envelope, wsep.getName(), wsep.getNamespace());
            if (headerElement == null || actuallySigned.contains(headerElement)) continue;
            throw new RampartException("signedPartHeaderNotSigned", new String[]{wsep.getName()});
        }
    }

    protected boolean isSignatureRequired(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        return rpd.isSymmetricBinding() && rpd.getSignatureToken() != null || !rpd.isSymmetricBinding() && !rpd.isTransportBinding() && (rpd.getInitiatorToken() != null && rmd.isInitiator() || rpd.getRecipientToken() != null && !rmd.isInitiator());
    }

    protected boolean verifyTimestamp(Timestamp timestamp, RampartMessageData rmd) throws RampartException {
        Calendar cre = timestamp.getCreated();
        if (cre != null) {
            long now = Calendar.getInstance().getTimeInMillis();
            long maxSkew = RampartUtil.getTimestampMaxSkew(rmd);
            if (maxSkew > 0L) {
                now += maxSkew * 1000L;
            }
            if (cre.getTimeInMillis() > now) {
                return false;
            }
        }
        return true;
    }

    protected boolean verifyTrust(X509Certificate cert, RampartMessageData rmd) throws RampartException {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        boolean doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("WSHandler: Transmitted certificate has subject " + subjectString));
            log.debug((Object)("WSHandler: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            alias = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getAliasForX509Cert(issuerString, issuerSerial);
        }
        catch (WSSecurityException ex) {
            throw new RampartException("cannotFindAliasForCert", new String[]{subjectString}, ex);
        }
        if (alias != null) {
            try {
                certs = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new RampartException("noCertForAlias", new String[]{alias}, ex);
            }
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (doDebug) {
                    log.debug((Object)("Direct trust for certificate with " + subjectString));
                }
                return true;
            }
        } else if (doDebug) {
            log.debug((Object)("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            aliases = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getAliasesForDN(issuerString);
        }
        catch (WSSecurityException ex) {
            throw new RampartException("cannotFindAliasForCert", new String[]{issuerString}, ex);
        }
        if (aliases == null || aliases.length < 1) {
            if (doDebug) {
                log.debug((Object)("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (doDebug) {
                log.debug((Object)("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString));
            }
            try {
                certs = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new RampartException("noCertForAlias", new String[]{alias}, ex);
            }
            if (certs == null || certs.length < 1) {
                throw new RampartException("noCertForAlias", new String[]{alias});
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length + 1];
            x509certs[0] = cert;
            for (int j = 0; j < certs.length; ++j) {
                x509certs[j + 1] = cert = certs[j];
            }
            certs = x509certs;
            try {
                if (!RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).validateCertPath(certs)) continue;
                if (doDebug) {
                    log.debug((Object)("WSHandler: Certificate path has been verified for certificate with subject " + subjectString));
                }
                return true;
            }
            catch (WSSecurityException ex) {
                throw new RampartException("certPathVerificationFailed", new String[]{subjectString}, ex);
            }
        }
        log.debug((Object)("WSHandler: Certificate path could not be verified for certificate with subject " + subjectString));
        return false;
    }

    protected ArrayList getEncryptedReferences(Vector results) {
        ArrayList encrResults = this.getResults(results, 4);
        ArrayList<WSDataRef> refs = new ArrayList<WSDataRef>();
        Iterator iter = encrResults.iterator();
        while (iter.hasNext()) {
            WSSecurityEngineResult engineResult = (WSSecurityEngineResult)iter.next();
            ArrayList dataRefUris = (ArrayList)engineResult.get("data-ref-uris");
            if (dataRefUris == null) continue;
            Iterator iterator = dataRefUris.iterator();
            while (iterator.hasNext()) {
                WSDataRef uri = (WSDataRef)iterator.next();
                refs.add(uri);
            }
        }
        return refs;
    }

    protected ArrayList getResults(Vector results, int action) {
        ArrayList<WSSecurityEngineResult> list = new ArrayList<WSSecurityEngineResult>();
        for (int i = 0; i < results.size(); ++i) {
            Integer actInt = (Integer)((WSSecurityEngineResult)results.get(i)).get("action");
            if (actInt != action) continue;
            list.add((WSSecurityEngineResult)results.get(i));
        }
        return list;
    }

    protected boolean isUsernameTokenPresent(ValidatorData data) {
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        SupportingToken suppTok = rpd.getSupportingTokens();
        if (this.isUsernameTokenPresent(suppTok)) {
            return true;
        }
        SupportingToken signedSuppToken = rpd.getSignedSupportingTokens();
        if (this.isUsernameTokenPresent(signedSuppToken)) {
            return true;
        }
        SupportingToken signedEndSuppToken = rpd.getSignedEndorsingSupportingTokens();
        if (this.isUsernameTokenPresent(signedEndSuppToken)) {
            return true;
        }
        SupportingToken endSuppToken = rpd.getEndorsingSupportingTokens();
        return this.isUsernameTokenPresent(endSuppToken);
    }

    protected boolean isUsernameTokenPresent(SupportingToken suppTok) {
        if (suppTok == null) {
            return false;
        }
        ArrayList tokens = suppTok.getTokens();
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!(token instanceof UsernameToken)) continue;
            return true;
        }
        return false;
    }

    private boolean isRefIdPresent(ArrayList refList, String id) {
        for (int i = 0; i < refList.size(); ++i) {
            WSDataRef dataRef = (WSDataRef)refList.get(i);
            if (dataRef == null) continue;
            String dataRefUri = dataRef.getWsuId();
            if (dataRefUri == null) {
                dataRefUri = dataRef.getDataref();
            }
            if (dataRefUri == null || !dataRefUri.equals(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isRefIdPresent(ArrayList refList, QName qname) {
        for (int i = 0; i < refList.size(); ++i) {
            QName dataRefQName;
            WSDataRef dataRef = (WSDataRef)refList.get(i);
            if (dataRef == null || (dataRefQName = dataRef.getName()) == null || !dataRefQName.equals(qname)) continue;
            return true;
        }
        return false;
    }
}

