/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.namespace.Constants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.RampartEngine;
import org.apache.rampart.RampartException;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;

public class RampartReceiver
implements Handler {
    private static Log mlog = LogFactory.getLog((String)"org.apache.rampart.MESSAGE");
    private static HandlerDescription EMPTY_HANDLER_METADATA = new HandlerDescription("default Handler");
    private HandlerDescription handlerDesc = EMPTY_HANDLER_METADATA;

    public void cleanup() {
    }

    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (!msgContext.isEngaged("rampart")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (mlog.isDebugEnabled()) {
            mlog.debug((Object)("*********************** RampartReceiver received \n" + msgContext.getEnvelope()));
        }
        RampartEngine engine = new RampartEngine();
        Vector wsResult = null;
        try {
            wsResult = engine.process(msgContext);
        }
        catch (WSSecurityException e) {
            this.setFaultCodeAndThrowAxisFault(msgContext, e);
        }
        catch (WSSPolicyException e) {
            this.setFaultCodeAndThrowAxisFault(msgContext, e);
        }
        catch (RampartException e) {
            this.setFaultCodeAndThrowAxisFault(msgContext, e);
        }
        if (wsResult == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        Vector<WSHandlerResult> results = null;
        results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            msgContext.setProperty("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult("", wsResult);
        results.add(0, rResult);
        SOAPHeader header = null;
        try {
            header = msgContext.getEnvelope().getHeader();
        }
        catch (OMException ex) {
            throw new AxisFault("RampartReceiver: cannot get SOAP header after security processing", ex);
        }
        Iterator headers = header.getChildElements();
        SOAPHeaderBlock headerBlock = null;
        while (headers.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)headers.next();
            if (!hb.getLocalName().equals("Security") || !hb.getNamespace().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            headerBlock = hb;
            break;
        }
        if (headerBlock != null) {
            headerBlock.setProcessed();
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public HandlerDescription getHandlerDesc() {
        return this.handlerDesc;
    }

    public String getName() {
        return "Apache Rampart inflow handler";
    }

    public Parameter getParameter(String name) {
        return this.handlerDesc.getParameter(name);
    }

    private void setFaultCodeAndThrowAxisFault(MessageContext msgContext, Exception e) throws AxisFault {
        msgContext.setProperty("SECURITY_VALIDATION_FAILURE", Boolean.TRUE);
        String soapVersionURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        QName invalidSecurity = new QName(WSConstants.INVALID_SECURITY.getNamespaceURI(), WSConstants.INVALID_SECURITY.getLocalPart(), "wsse");
        if (soapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            throw new AxisFault(invalidSecurity, e.getMessage(), (Throwable)e);
        }
        if (soapVersionURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            ArrayList<QName> subfaultCodes = new ArrayList<QName>();
            subfaultCodes.add(invalidSecurity);
            throw new AxisFault(Constants.FAULT_SOAP12_SENDER, subfaultCodes, e.getMessage(), e);
        }
    }
}

